package org.jeecg.modules.pad.controller;

import cn.hutool.core.util.StrUtil;
import io.swagger.annotations.Api;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.CreateOutTaskReq;
import org.jeecg.modules.pad.api.bean.req.CreatePutTaskReq;
import org.jeecg.modules.pad.api.bean.req.InventoryReq;
import org.jeecg.modules.pad.api.bean.res.GoodsDetail;
import org.jeecg.modules.pad.api.bean.res.InternalInventory;
import org.jeecg.modules.pad.service.IPdaManualStorageIn;
import org.jeecg.modules.pad.service.IPdaManualStorageOut;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.*;

@Api(tags="手工出库")
@RestController
@RequestMapping("/pda/manualStorageOut")
@Slf4j
@AllArgsConstructor
public class PdaManualStorageOutController {
    private final IPdaManualStorageOut pdaManualStorageOut;

    @GetMapping("/getMaterialInfoByCode")
    public Result<InternalInventory> getMaterialInfoByCode(InventoryReq req){
        if (req == null){
            return Result.error("参数异常");
        }
        WmsRes<InternalInventory> result = pdaManualStorageOut.getMaterialInfoByCode(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @PostMapping("/manualStorageOut")
    public Result<String> manualStorageOut(@RequestBody CreateOutTaskReq req){
        if (req == null){
            return Result.error("参数异常");
        }

        LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        if (sysUser == null){
            return Result.error("用户未登录");
        }
        req.setUser(sysUser.getUsername());

        WmsRes<?> result = pdaManualStorageOut.manualStorageOut(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK("操作成功");
    }
}
