package org.jeecg.modules.pad.controller;

import cn.hutool.core.util.StrUtil;
import io.swagger.annotations.Api;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.CreatePutTaskReq;
import org.jeecg.modules.pad.api.bean.res.GoodsDetail;
import org.jeecg.modules.pad.service.IPdaManualStorageIn;
import org.springframework.web.bind.annotation.*;

@Api(tags="手工入库")
@RestController
@RequestMapping("/pda/manualStorageIn")
@Slf4j
@AllArgsConstructor
public class PdaManualStorageInController {
    private final IPdaManualStorageIn pdaManualStorageIn;

    @GetMapping("/getMaterialInfoByCode")
    public Result<GoodsDetail> getMaterialInfoByCode(@RequestParam(name="code", defaultValue="")String code){
        if (StrUtil.isBlank(code)){
            return Result.error("参数异常");
        }
        WmsRes<GoodsDetail> result = pdaManualStorageIn.getMaterialInfoByCode(code);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @PostMapping("/manualStorageIn")
    public Result<String> manualStorageIn(@RequestBody CreatePutTaskReq req){
        if (req == null){
            return Result.error("参数异常");
        }

        LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        if (sysUser == null){
            return Result.error("用户未登录");
        }
        req.setUser(sysUser.getUsername());

        WmsRes<?> result = pdaManualStorageIn.manualStorageIn(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK("操作成功");
    }
}
