package org.jeecg.modules.pad.controller;

import cn.hutool.core.util.StrUtil;
import io.swagger.annotations.Api;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.res.GoodsDetail;
import org.jeecg.modules.pad.api.bean.res.Inventory;
import org.jeecg.modules.pad.service.IPdaInventorySearch;
import org.jeecg.modules.pad.service.IPdaManualStorageIn;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags="库存查询")
@RestController
@RequestMapping("/pda/inventorySearch")
@Slf4j
@AllArgsConstructor
public class PdaInventorySearchController {
    private final IPdaInventorySearch pdaInventorySearch;
    @GetMapping("/getMaterialInfoByCode")
    public Result<Inventory> getMaterialInfoByCode(@RequestParam(name="code", defaultValue="") String code){
        if (StrUtil.isBlank(code)){
            return Result.error("参数异常");
        }
        WmsRes<Inventory> result = pdaInventorySearch.getMaterialInfoByCode(code);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }
}
