package org.jeecg.modules.pad.controller;

import cn.hutool.core.util.StrUtil;
import io.swagger.annotations.Api;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.BoxInfoReq;
import org.jeecg.modules.pad.api.bean.req.SecondPickReq;
import org.jeecg.modules.pad.api.bean.res.SecondPickInfo;
import org.jeecg.modules.pad.service.IPdaHourSorting;
import org.springframework.web.bind.annotation.*;

@Api(tags="小时分拣")
@RestController
@RequestMapping("/pda/hourSorting")
@Slf4j
@AllArgsConstructor
public class PdaHourSortingController {
    private final IPdaHourSorting hourSortingService;

    @PostMapping("/listSecondPick")
    public Result<SecondPickInfo> listSecondPick(@RequestBody BoxInfoReq req) {
        if (req == null){
            return Result.error("参数异常");
        }
        WmsRes<SecondPickInfo> result = hourSortingService.listSecondPick(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @PostMapping("/executeSecondPick")
    public Result<?> executeSecondPick(@RequestBody SecondPickReq req) {
        if (req == null){
            return Result.error("参数异常");
        }

        LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        if (sysUser == null){
            return Result.error("用户未登录");
        }
        req.setUser(sysUser.getUsername());

        WmsRes<?> result = hourSortingService.executeSecondPick(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK("操作成功");
    }
}
