package org.jeecg.modules.pad.controller;

import io.swagger.annotations.Api;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.CreateEmptyPutTaskReq;
import org.jeecg.modules.pad.api.bean.req.CreateOutTaskReq;
import org.jeecg.modules.pad.service.IPdaEmptyPalletsStorageIn;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags="空托入库")
@RestController
@RequestMapping("/pda/emptyPalletsStorageIn")
@Slf4j
@AllArgsConstructor
public class PdaEmptyPalletsStorageInController {
    private final IPdaEmptyPalletsStorageIn pdaEmptyPalletsStorageIn;

    @PostMapping("/storageIn")
    public Result<String> storageIn(@RequestBody CreateEmptyPutTaskReq req){
        if (req == null){
            return Result.error("参数异常");
        }

        LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        if (sysUser == null){
            return Result.error("用户未登录");
        }
        req.setUser(sysUser.getUsername());

        WmsRes<?> result = pdaEmptyPalletsStorageIn.emptyStorageIn(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK("操作成功");
    }
}
