package org.jeecg.modules.pad.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.pad.api.bean.base.WmsPageRes;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.DeliveryOrderItemReq;
import org.jeecg.modules.pad.api.bean.req.DeliveryOrderReq;
import org.jeecg.modules.pad.api.bean.req.SoExecuteSecondPickProReq;
import org.jeecg.modules.pad.api.bean.res.*;
import org.jeecg.modules.pad.service.IPdaDelivery;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags="配送")
@RestController
@RequestMapping("/pda/delivery")
@Slf4j
@AllArgsConstructor
public class PdaDeliveryController {
    private final IPdaDelivery pdaDelivery;

    @GetMapping("/listSecondPickDelivery")
    public Result<List<DeliveryOrderInfo>> listSecondPickDelivery()
    {

        WmsRes<List<DeliveryOrderInfo>> result = pdaDelivery.listSecondPickDelivery();
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @GetMapping("/listSecondPickDeliveryItem")
    public Result<IPage<DeliveryOrderItemInfo>> listSecondPickDeliveryItem(DeliveryOrderReq orderInfo,
                                                                          @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
                                                                          @RequestParam(name="pageSize", defaultValue="10") Integer pageSize)
    {
        if (orderInfo == null){
            return Result.error("参数异常");
        }

        WmsPageRes<DeliveryOrderItemInfo> result = pdaDelivery.listSecondPickDeliveryItem(orderInfo, pageNo, pageSize);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        IPage<DeliveryOrderItemInfo> page = new Page<>(pageNo, pageSize, result.getTotal());
        page.setRecords(result.getRows());
        return Result.OK(page);
    }

    @PostMapping("/listSecondPickPro")
    public Result<SecondPickProInfo> listSecondPickPro(@RequestBody DeliveryOrderItemReq req)
    {
        if (req == null){
            return Result.error("参数异常");
        }

        WmsRes<SecondPickProInfo> result = pdaDelivery.listSecondPickPro(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @PostMapping("/executeSecondPickPro")
    public Result<?> executeSecondPickPro(@RequestBody SoExecuteSecondPickProReq req){
        if (req == null){
            return Result.error("参数异常");
        }

        WmsRes<?> result = pdaDelivery.executeSecondPickPro(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK("操作成功");
    }
}
