package org.jeecg.modules.pad.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.system.UserInfo;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.jeecg.common.api.CommonAPI;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.PasswordUtil;
import org.jeecg.modules.pad.api.bean.base.WmsPageRes;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.CheckCallReq;
import org.jeecg.modules.pad.api.bean.req.CheckSkuInfoReq;
import org.jeecg.modules.pad.api.bean.req.CheckToDoReq;
import org.jeecg.modules.pad.api.bean.req.CheckUpdateSkuReq;
import org.jeecg.modules.pad.api.bean.res.CheckInfo;
import org.jeecg.modules.pad.api.bean.res.CheckOrderInfo;
import org.jeecg.modules.pad.api.bean.res.CheckSkuInfo;
import org.jeecg.modules.pad.service.IPdaCheckInventory;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Set;

@Api(tags="库存盘点")
@RestController
@RequestMapping("/pda/checkInventory")
@Slf4j
@AllArgsConstructor
public class PdaCheckInventoryController {
    private final IPdaCheckInventory pdaCheckInventory;
    private final CommonAPI commonAPI;

    @AutoLog(value = "编辑物料用户验证")
    @ApiOperation(value="编辑物料用户验证", notes="编辑物料用户验证")
    @RequestMapping(value = "/verify", method = {RequestMethod.PUT,RequestMethod.POST})
    public Result<String> verify(@RequestBody LoginUser loginUser) {
        if (loginUser == null || StrUtil.isBlank(loginUser.getUsername()) || StrUtil.isBlank(loginUser.getPassword())){
            return Result.error("参数异常");
        }

        Result<LoginUser> result = commonAPI.verifyUserInfo(loginUser.getUsername(), loginUser.getPassword());
        if (result == null){
            return Result.error("登录信息异常");
        }
        if (!result.isSuccess()){
            return Result.error(result.getMessage());
        }

        LoginUser user = result.getResult();

        Set<String> permissions = commonAPI.queryUserAuths(user.getId());
        if (!permissions.contains("wms:wms_check_bill:verify")){
            return Result.error("您没有权限进行此操作");
        }
        return Result.OK("验证成功!");
    }

    @GetMapping("/orders")
    public Result<?> getCheckOrders(CheckToDoReq req,
                                    @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
                                    @RequestParam(name="pageSize", defaultValue="10") Integer pageSize){
        req.setPageNum(pageNo);
        req.setPageSize(pageSize);
        WmsPageRes<CheckOrderInfo> result = pdaCheckInventory.getCheckOrders(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }
        IPage<CheckOrderInfo> page = new Page<>(pageNo, pageSize, result.getTotal());
        page.setRecords(result.getRows());
        return Result.OK(page);
    }

    @GetMapping("/orderInfo")
    public Result<?> getCheckOrderInfo(@RequestParam(name="id", defaultValue="") Integer id){
        if (id == null){
            return Result.error("参数异常");
        }
        WmsRes<CheckInfo> result = pdaCheckInventory.getCheckOrderInfo(id);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @PostMapping("/boxInfo")
    public Result<?> getBoxInfo(@RequestBody CheckSkuInfoReq req){
        if (req == null){
            return Result.error("参数异常");
        }
        WmsRes<List<CheckSkuInfo>> result = pdaCheckInventory.getBoxInfo(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @PostMapping("/callBox")
    public Result<?> callBox(@RequestBody CheckCallReq req) {
        if (req == null){
            return Result.error("参数异常");
        }
        WmsRes<?> result = pdaCheckInventory.callBox(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @PostMapping("/callBoxMulti")
    public Result<?> callBox(@RequestBody List<CheckCallReq> req) {
        if (CollectionUtil.isEmpty(req)){
            return Result.error("参数异常");
        }
        WmsRes<?> result = pdaCheckInventory.callBox(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @PostMapping("/updateMaterial")
    public Result<?> updateMaterialInfo(@RequestBody CheckUpdateSkuReq req){
        if (req == null){
            return Result.error("参数异常");
        }
        WmsRes<?> result = pdaCheckInventory.updateMaterialInfo(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @PostMapping("/returnBox")
    public Result<?> returnBox(@RequestBody CheckCallReq req){
        if (req == null){
            return Result.error("参数异常");
        }
        WmsRes<?> result = pdaCheckInventory.returnBox(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @GetMapping("/finishOrder")
    public Result<?> finishCheckOrder(String orderNo){
        if (StrUtil.isBlank(orderNo)){
            return Result.error("参数异常");
        }
        WmsRes<?> result = pdaCheckInventory.finishCheckOrder(orderNo);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }
}
