package org.jeecg.modules.pad.api.bean.res;

import lombok.Data;

import java.util.List;

@Data
public class SoFirstPickByCode {
    // 托盘号
    private String palletCode;
    // 是否整托出库 整托出库允许原箱分拣，不需要搬运物料到另一个托盘
    private boolean isAllOut;
    // 料箱列表
    private List<SoBoxInfo> soBoxList;

    @Data
    public static class SoBoxInfo {
        // 料箱号
        private String boxCode;
        // 订单ID
        private long orderId;
        // 物料列表
        private List<PickInfo> pickList;
        // 工站号
        private String stationCode;
        // 状态
        private String status;
    }

    @Data
    public static class PickInfo {
        // 批次号
        private String batchNo;
        // 物料名
        private String goodsName;
        // 出库数量
        private long pickedQty;
        // 需求数量
        private long qty;
        // 物料号
        private String sku;
        // 状态
        private String status;
    }
}
