package org.jeecg.modules.pad.api;

import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.StationReleaseReq;
import org.jeecg.modules.pad.api.bean.res.StationInfo;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import top.crossoverjie.feign.plus.register.FeignPlusClient;


@RequestMapping("/xh/station")
@FeignPlusClient(name = "station", url = "${feign.wms.url}", port = "${feign.wms.port}")
public interface WmsStationApi {
    // 查询站位状态
    @GetMapping("/getStationInfo/{stationCode}")
    WmsRes<StationInfo> getStationInfo(@PathVariable("stationCode") String stationCode);

    // 释放站位
    @PostMapping("/release")
    WmsRes<?> release(@RequestBody StationReleaseReq req);
}
