package org.jeecg.modules.pad.api;

import org.jeecg.modules.pad.api.bean.base.WmsPageRes;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.*;
import org.jeecg.modules.pad.api.bean.res.*;
import org.springframework.web.bind.annotation.*;
import top.crossoverjie.feign.plus.contract.SpringQueryMap;
import top.crossoverjie.feign.plus.register.FeignPlusClient;

import java.util.List;

@RequestMapping("/xh/so")
@FeignPlusClient(name = "so", url = "${feign.wms.url}", port = "${feign.wms.port}")
public interface WmsSoApi {
    //出库物料查询
    @PostMapping("/listGoods")
    WmsRes<SoListGoods> listGoods(@RequestBody SoListGoodsReq req);
    //出库物料分页查询
    @PostMapping("/listGoodsPro")
    WmsPageRes<SoListGoods.GoodsInfo> listGoodsPro(@RequestBody SoListGoodsReq req,
                                         @RequestParam(name="pageNum", defaultValue="1") Integer pageNum,
                                         @RequestParam(name="pageSize", defaultValue="10") Integer pageSize);
    //出库物料拣选查询
    @PostMapping("/pick/listFirstPick")
    WmsRes<SoFirstPickInfo> listFirstPick(@RequestBody SoListFirstPickReq req);
    //执行出库
    @PostMapping("/pullFirstPick")
    WmsRes<?> pullFirstPick(@RequestBody SoPullFirstPickReq req);
    //列出托盘物料拣选信息
    @GetMapping("/pick/pallet/listFirstPick/{palletCode}")
    WmsRes<SoFirstPickByCode> listFirstPickByCode(@PathVariable("palletCode") String palletCode);
    //执行拣选
    @PostMapping("/pick/pallet/executeFirstPick")
    WmsRes<?> executeFirstPick(@RequestBody SoExecuteFirstPickReq req);
    //余料查询
    @GetMapping("/listRestPick/{palletCode}")
    WmsRes<SoListRestPick> listRestPick(@PathVariable("palletCode") String palletCode);
    //余料回库
    @PostMapping("/returnRestPick")
    WmsRes<?> returnRestPick(@RequestBody SoReturnRestPickReq req);

    //获取待出库物料类型列表
    @GetMapping("/getGoodsTypeList")
    WmsRes<GoodsTypeInfo> getGoodsTypeList();
    //获取出库物料责任人列表
    @GetMapping("/getResponsibleUserList")
    WmsRes<ResponsibleUserInfo> getResponsibleUserList();
    //执行拣选增强
    @PostMapping("/pick/pallet/executeFirstPickPro")
    WmsRes<SoBoxInfo> executeFirstPickPro(@RequestBody SoExecuteFirstPickProReq req);
    //完成拣选
    @PostMapping("/pick/pallet/finishFirstPick")
    WmsRes<SoBoxInfo> finishFirstPick(@RequestBody SoExecuteFirstPickProReq req);

    //列出料箱扣账出库物料信息
    @PostMapping("/listSecondPick")
    WmsRes<SecondPickInfo> listSecondPick(@RequestBody BoxInfoReq req);
    //执行扣账出库
    @PostMapping("/executeSecondPick")
    WmsRes<?> executeSecondPick(@RequestBody SecondPickReq req);


    //列出未完成的配送单列表
    @GetMapping("/listSecondPickDelivery")
    WmsRes<List<DeliveryOrderInfo>> listSecondPickDelivery();
    //列出配送单明细列表
    @PostMapping("/listSecondPickDeliveryItem")
    WmsPageRes<DeliveryOrderItemInfo> listSecondPickDeliveryItem(@RequestBody DeliveryOrderReq orderInfo,
                                                                   @RequestParam(name="pageNum", defaultValue="1") Integer pageNum,
                                                                   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize);
    //列出配送单上指定物料在拣选区中的存储信息
    @PostMapping("/listSecondPickPro")
    WmsRes<SecondPickProInfo> listSecondPickPro(@RequestBody DeliveryOrderItemReq req);
    //执行配送单扣账出库
    @PostMapping("/executeSecondPickPro")
    WmsRes<?> executeSecondPickPro(@RequestBody SoExecuteSecondPickProReq req);


}
