package org.jeecg.modules.pad.api;

import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.*;
import org.jeecg.modules.pad.api.bean.res.MergeInfo;
import org.jeecg.modules.pad.api.bean.res.ScanTray;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import top.crossoverjie.feign.plus.contract.SpringQueryMap;
import top.crossoverjie.feign.plus.register.FeignPlusClient;

import java.util.List;

@RequestMapping("/xh/pallet")
@FeignPlusClient(name = "pallet", url = "${feign.wms.url}", port = "${feign.wms.port}")
public interface WmsPalletApi {
    //查询托盘物料信息
    @GetMapping("/scanTray")
    WmsRes<List<ScanTray>> scanTray(@SpringQueryMap ScanTrayReq req);
    //查询料箱物料信息
    @GetMapping("/scanBox")
    WmsRes<List<ScanTray>> scanBox(@SpringQueryMap ScanBoxReq req);
    //托盘转运
    @PostMapping("/transfer")
    WmsRes<?> transfer(@RequestBody TransferReq req);
    //合托
    @PostMapping("merge")
    WmsRes<MergeInfo> merge(@RequestBody MergeReq req);
}
