package org.jeecg.modules.pad.api;

import org.jeecg.modules.pad.api.bean.base.WmsPageRes;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.*;
import org.jeecg.modules.pad.api.bean.res.CheckInfo;
import org.jeecg.modules.pad.api.bean.res.CheckSkuInfo;
import org.jeecg.modules.pad.api.bean.res.CheckOrderInfo;
import org.jeecg.modules.pad.api.bean.res.StockGoods;
import org.springframework.web.bind.annotation.*;
import top.crossoverjie.feign.plus.contract.SpringQueryMap;
import top.crossoverjie.feign.plus.register.FeignPlusClient;

import java.util.List;

@RequestMapping("/xh/checkBill/ex/")
@FeignPlusClient(name = "check", url = "${feign.wms.url}", port = "${feign.wms.port}")
public interface WmsCheckApi {
    //Pda盘点-待盘点列表
    @GetMapping("/todoList")
    WmsPageRes<CheckOrderInfo> todoList(@SpringQueryMap CheckToDoReq req);
    //Pda盘点-获取盘点单详细信息
    @GetMapping("/getInfo/{id}")
    WmsRes<CheckInfo> getInfo(@PathVariable("id") int id);
    //Pda盘点-根据箱号获取箱子内商品列表
    @PostMapping("/getSkuInfoBuContainerCode")
    WmsRes<List<CheckSkuInfo>> getSkuInfoBuContainerCode(@RequestBody CheckSkuInfoReq req);
    //Pda盘点-呼叫料箱
    @PostMapping("/callOut")
    WmsRes<?> callOut(@RequestBody CheckCallReq req);
    //Pda盘点-一键呼叫料箱
    @PostMapping("/callOutMulti")
    WmsRes<?> callOutMulti(@RequestBody List<CheckCallReq> req);
    //Pda盘点-修改物料信息
    @PostMapping("/updateSku")
    WmsRes<?> updateSku(@RequestBody CheckUpdateSkuReq req);
    //Pda盘点-料箱回库
    @PostMapping("/callBack")
    WmsRes<?> callBack(@RequestBody CheckCallReq req);
    //Pda盘点-完成盘点单
    @GetMapping("/done/{orderNo}")
    WmsRes<?> done(@PathVariable("orderNo") String orderNo);

    //Web盘点-库存货品列表
    @GetMapping("/list")
    WmsPageRes<StockGoods> list();
    //Web盘点-创建盘点单
    @PostMapping("/create")
    WmsRes<?> create(@RequestBody CheckCreateReq req);
    //Web盘点-下发盘点单
    @GetMapping("/pullDown/{orderNo}")
    WmsRes<?> pullDown(@PathVariable("orderNo") String orderNo);
    //Web盘点-修改盘点单
    @PostMapping("/update")
    WmsRes<?> update(@RequestBody CheckUpdateReq req);
    //Web盘点-取消盘点单
    @GetMapping("/cancel/{orderNo}")
    WmsRes<?> cancel(@PathVariable("orderNo") String orderNo);
    //Web盘点-同步库存
    @GetMapping("/syncInventory/{orderNo}")
    WmsRes<?> syncInventory(@PathVariable("orderNo") String orderNo);
}
