package org.jeecg.modules.pad.api;

import org.jeecg.modules.pad.api.bean.base.WmsPageRes;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.*;
import org.jeecg.modules.pad.api.bean.res.*;
import org.springframework.web.bind.annotation.*;
import top.crossoverjie.feign.plus.contract.SpringQueryMap;
import top.crossoverjie.feign.plus.register.FeignPlusClient;

import java.util.List;

@RequestMapping("/pda/api/")
@FeignPlusClient(name = "wms", url = "${feign.wms.url}", port = "${feign.wms.port}")
public interface WmsApi {
    //库存查询
    @GetMapping("/inventory")
    WmsRes<Inventory> inventory(@SpringQueryMap InventoryReq req);

    //任务查询
    @GetMapping("/task")
    WmsPageRes<TaskInfo> task(@SpringQueryMap TaskReq req);

    //手工入库-载具物料信息查询
    @GetMapping("/goodsDetails")
    WmsRes<GoodsDetail> goodsDetails(@SpringQueryMap GoodsDetailReq req);

    //手工出库-库存查询
    @GetMapping("/internalInventory")
    WmsRes<InternalInventory> internalInventory(@SpringQueryMap InventoryReq req);

    //查询sku列表
    @GetMapping("/skuList")
    WmsPageRes<String> skuList(@SpringQueryMap SkuReq req);

    //手工入库
    @PostMapping("/createPutTask")
    WmsRes<?> createPutTask(@RequestBody CreatePutTaskReq req);

    //手工出库
    @PostMapping("/createOutTask")
    WmsRes<?> createOutTask(@RequestBody CreateOutTaskReq req);

    //空箱/空托入库
    @PostMapping("/createEmptyPutTask")
    WmsRes<?> createEmptyPutTask(@RequestBody CreateEmptyPutTaskReq req);

    //空箱/空托出库
    @PostMapping("/createEmptyOutTask")
    WmsRes<?> createEmptyOutTask(@RequestBody CreateEmptyOutTaskReq req);

    //手工任务更新
    @PostMapping("/updateTaskStatus")
    WmsRes<?> updateTaskStatus(@RequestBody TaskUpdateReq req);

    //手工重新下发任务至wcs
    @PostMapping("/retryTaskToWcs")
    WmsRes<?> retryTaskToWcs(@RequestBody TaskUpdateReq req);

    //条码解析
    @GetMapping("/parseQrCode")
    WmsRes<QrcodeInfo> parseQrCode(@SpringQueryMap QrcodeReq req);

    //合托
    @PostMapping("/bindPallet")
    WmsRes<?> bindPallet(@RequestBody PalletBindReq req);
}
