package org.jeecg.modules.form.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import org.jeecg.modules.form.api.WmsRecordApi;
import org.jeecg.modules.form.api.bean.req.XhPutAndOutDailyRecordReq;
import org.jeecg.modules.form.entity.XhPutAndOutDailyRecord;
import org.jeecg.modules.form.mapper.XhPutAndOutDailyRecordMapper;
import org.jeecg.modules.form.service.IXhPutAndOutDailyRecordService;
import org.jeecg.modules.form.vo.FormDataVo;
import org.jeecg.modules.form.api.bean.res.XhPutAndOutDailyRecordRes;
import org.jeecg.modules.pad.api.bean.base.WmsPageRes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.util.*;

/**
 * @Description: xh_put_and_out_daily_record
 * @Author: jeecg-boot
 * @Date:   2024-11-29
 * @Version: V1.0
 */
@DS("wms-db")
@Service
public class XhPutAndOutDailyRecordServiceImpl extends ServiceImpl<XhPutAndOutDailyRecordMapper, XhPutAndOutDailyRecord> implements IXhPutAndOutDailyRecordService {
    @Autowired
    private WmsRecordApi wmsRecordApi;
    @Override
    public FormDataVo<Map<String, Object>> form(String areaCode, String supplierName, String sku, String goodsName, String recordDateStart, String recordDateEnd, Integer pageNo, Integer pageSize) {
        XhPutAndOutDailyRecordReq req = new XhPutAndOutDailyRecordReq();
        req.setAreaCode(areaCode);
        req.setSupplierName(supplierName);
        req.setSku(sku);
        req.setGoodsName(goodsName);
        req.setRecordDateStart(recordDateStart);
        req.setRecordDateEnd(recordDateEnd);
        WmsPageRes<XhPutAndOutDailyRecordRes> page = this.wmsRecordApi.listStatistics(req, pageNo, pageSize);
        if (page.getCode() != 200){
            return null;
        }

        List<Map<String, Object>> resultList = new ArrayList<>();
        List<XhPutAndOutDailyRecordRes> rows = page.getRows();

        for (XhPutAndOutDailyRecordRes row : rows) {
            List<XhPutAndOutDailyRecordRes.StatisticsInfo> statisticsList = row.getStatisticsList();
            if (statisticsList != null) {
                for (XhPutAndOutDailyRecordRes.StatisticsInfo stat : statisticsList) {
                    String recordDate = stat.getRecordDate();
                    if (recordDate != null) {
                        Map<String, Object> result = new LinkedHashMap<>();

                        result.put("areaCode", row.getAreaCode());
                        result.put("sku", row.getSku());
                        result.put("goodsName", row.getGoodsName());
                        result.put("supplierName", row.getSupplierName());
                        result.put("startQty", row.getStartQty());
                        result.put("endQty", row.getEndQty());
                        result.put("putQty", row.getPutQty());
                        result.put("takeQty", row.getTakeQty());

                        result.put("month", recordDate);
                        result.put("receipt", stat.getPutQty()!=0?stat.getPutQty():"");
                        result.put("send", stat.getTakeQty()!=0?stat.getTakeQty():"");
                        result.put("start", stat.getStartQty());
                        result.put("end", stat.getEndQty());

                        resultList.add(result);
                    }
                }
            }
        }

        // 获取页总数
        long recordCount = page.getTotal();
        long pageTotal = convertRecordCountToPageTotal(recordCount, pageSize);
        FormDataVo<Map<String, Object>> vo = new FormDataVo<>(resultList, recordCount, pageTotal);
        return vo;
    }

    // 转换记录总数到页总数
   private long convertRecordCountToPageTotal(long recordCount, Integer pageSize) {
         long pageTotal;
        if (recordCount == 0) {
            pageTotal = 0;
        } else if (pageSize == null || pageSize == 0) {
            pageTotal = 1;
        } else {
            pageTotal = recordCount / pageSize;
            if (Math.floorMod(recordCount, pageSize) != 0) {
                pageTotal++;
            }
        } 

        return pageTotal;
    }
}
