package org.jeecg.modules.form.controller;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;

import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.config.shiro.IgnoreAuth;
import org.jeecg.modules.form.entity.XhPutAndOutDailyRecord;
import org.jeecg.modules.form.service.IXhPutAndOutDailyRecordService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecg.modules.form.vo.FormDataVo;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: xh_put_and_out_daily_record
 * @Author: jeecg-boot
 * @Date:   2024-11-29
 * @Version: V1.0
 */
@Api(tags="xh_put_and_out_daily_record")
@RestController
@RequestMapping("/wms/xhPutAndOutDailyRecord")
@Slf4j
public class XhPutAndOutDailyRecordController extends JeecgController<XhPutAndOutDailyRecord, IXhPutAndOutDailyRecordService> {
	@Autowired
	private IXhPutAndOutDailyRecordService xhPutAndOutDailyRecordService;
	
	/**
	 * 分页列表查询
	 *
	 * @param xhPutAndOutDailyRecord
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "xh_put_and_out_daily_record-分页列表查询")
	@ApiOperation(value="xh_put_and_out_daily_record-分页列表查询", notes="xh_put_and_out_daily_record-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<XhPutAndOutDailyRecord>> queryPageList(XhPutAndOutDailyRecord xhPutAndOutDailyRecord,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<XhPutAndOutDailyRecord> queryWrapper = QueryGenerator.initQueryWrapper(xhPutAndOutDailyRecord, req.getParameterMap());
		Page<XhPutAndOutDailyRecord> page = new Page<>(pageNo, pageSize);
		IPage<XhPutAndOutDailyRecord> pageList = xhPutAndOutDailyRecordService.page(page, queryWrapper);
		return Result.OK(pageList);
	}

    @RequiresPermissions("wms:xh_put_and_out_daily_record:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, XhPutAndOutDailyRecord xhPutAndOutDailyRecord) {
        return super.exportXls(request, xhPutAndOutDailyRecord, XhPutAndOutDailyRecord.class, "xh_put_and_out_daily_record");
    }

    @GetMapping("form")
    @IgnoreAuth
    public FormDataVo<Map<String,Object>> form(
            @RequestParam(name="areaCode", required=false) String areaCode,
            @RequestParam(name="supplierName", required=false) String supplierName,
            @RequestParam(name="sku", required=false) String sku,
            @RequestParam(name="goodsName", required=false) String goodsName,
            @RequestParam(name="month_begin", required=false) String recordDateStart,
            @RequestParam(name="month_end", required=false) String recordDateEnd,
            @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
            @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        FormDataVo<Map<String, Object>> vo = xhPutAndOutDailyRecordService.form(areaCode, supplierName, sku, goodsName, recordDateStart, recordDateEnd, pageNo, pageSize);
        return vo;
    }
}
