package org.jeecg.modules.form.api;

import org.jeecg.modules.form.api.bean.req.XhPutAndOutDailyRecordReq;
import org.jeecg.modules.form.api.bean.res.XhPutAndOutDailyRecordRes;
import org.jeecg.modules.pad.api.bean.base.WmsPageRes;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import top.crossoverjie.feign.plus.register.FeignPlusClient;

@RequestMapping("/xh/record/")
@FeignPlusClient(name = "record", url = "${feign.wms.url}", port = "${feign.wms.port}")
public interface WmsRecordApi {
    @PostMapping("/putAndOutDailyRecord/listStatistics")
    WmsPageRes<XhPutAndOutDailyRecordRes> listStatistics(@RequestBody XhPutAndOutDailyRecordReq req,
                                                         @RequestParam(name="pageNum", defaultValue="1") Integer pageNum,
                                                         @RequestParam(name="pageSize", defaultValue="10") Integer pageSize);
}
