package org.jeecg.modules.api;

import cn.hutool.json.JSONUtil;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import top.crossoverjie.feign.plus.decoder.FeignErrorDecoder;
import top.crossoverjie.feign.plus.register.EnableFeignPlusClients;

@EnableFeignPlusClients(basePackages = {"org.jeecg.modules.pad.api", "org.jeecg.modules.form.api"})
@Configuration
public class FeignConfig {
    @Bean
    public FeignErrorDecoder feignExceptionDecoder() {
        return (methodName, response, e) -> {
            HttpStatus status = JSONUtil.toBean(response, HttpStatus.class);
            return new RuntimeException(status.toString());
        };
    }
}
