/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.test.seata.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import io.seata.core.context.RootContext;
import io.seata.spring.annotation.GlobalTransactional;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.jeecg.modules.test.seata.order.dto.PlaceOrderRequest;
import org.jeecg.modules.test.seata.order.entity.SeataOrder;
import org.jeecg.modules.test.seata.order.enums.OrderStatus;
import org.jeecg.modules.test.seata.order.feign.AccountClient;
import org.jeecg.modules.test.seata.order.feign.ProductClient;
import org.jeecg.modules.test.seata.order.mapper.SeataOrderMapper;
import org.jeecg.modules.test.seata.order.service.SeataOrderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SeataOrderServiceImpl
implements SeataOrderService {
    private static final Logger log = LoggerFactory.getLogger(SeataOrderServiceImpl.class);
    @Resource
    private SeataOrderMapper orderMapper;
    @Resource
    private AccountClient accountClient;
    @Resource
    private ProductClient productClient;

    @Override
    @DS(value="order")
    @Transactional(rollbackFor={Exception.class})
    @GlobalTransactional
    public void placeOrder(PlaceOrderRequest request) {
        log.info("xid:" + RootContext.getXID());
        log.info("=============ORDER START=================");
        Long userId = request.getUserId();
        Long productId = request.getProductId();
        Integer count = request.getCount();
        log.info("\u6536\u5230\u4e0b\u5355\u8bf7\u6c42,\u7528\u6237:{}, \u5546\u54c1:{},\u6570\u91cf:{}", new Object[]{userId, productId, count});
        SeataOrder order = SeataOrder.builder().userId(userId).productId(productId).status(OrderStatus.INIT).count(count).build();
        this.orderMapper.insert(order);
        log.info("\u8ba2\u5355\u4e00\u9636\u6bb5\u751f\u6210\uff0c\u7b49\u5f85\u6263\u5e93\u5b58\u4ed8\u6b3e\u4e2d");
        BigDecimal amount = this.productClient.reduceStock(productId, count);
        String str = this.accountClient.reduceBalance(userId, amount);
        JSONObject jsonObject = JSONObject.parseObject((String)str);
        if (jsonObject.getInteger("code") != 200) {
            throw new RuntimeException();
        }
        order.setStatus(OrderStatus.SUCCESS);
        order.setTotalPrice(amount);
        this.orderMapper.updateById(order);
        log.info("\u8ba2\u5355\u5df2\u6210\u529f\u4e0b\u5355");
        log.info("=============ORDER END=================");
    }
}

