/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.test.xxljob;

import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.util.ShardingUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DemoJobHandler {
    private static final Logger log = LoggerFactory.getLogger(DemoJobHandler.class);

    @XxlJob(value="demoJob")
    public ReturnT<String> demoJobHandler(String params) {
        log.info("\u6211\u662f jeecg-system \u670d\u52a1\u91cc\u7684\u5b9a\u65f6\u4efb\u52a1 demoJob\uff0c\u6211\u6267\u884c\u4e86...............................");
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="shardingJobHandler")
    public ReturnT<String> shardingJobHandler(String param) throws Exception {
        ShardingUtil.ShardingVO shardingVO = ShardingUtil.getShardingVo();
        log.info("\u5206\u7247\u53c2\u6570\uff1a\u5f53\u524d\u5206\u7247\u5e8f\u53f7 = {}, \u603b\u5206\u7247\u6570 = {}", (Object)shardingVO.getIndex(), (Object)shardingVO.getTotal());
        for (int i = 0; i < shardingVO.getTotal(); ++i) {
            if (i == shardingVO.getIndex()) {
                log.info("\u7b2c {} \u7247, \u547d\u4e2d\u5206\u7247\u5f00\u59cb\u5904\u7406", (Object)i);
                continue;
            }
            log.info("\u7b2c {} \u7247, \u5ffd\u7565", (Object)i);
        }
        return ReturnT.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XxlJob(value="commandJobHandler")
    public ReturnT<String> commandJobHandler(String param) throws Exception {
        String command = param;
        int exitValue = -1;
        try (BufferedReader bufferedReader = null;){
            String line;
            Process process = Runtime.getRuntime().exec(command);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
            bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
            while ((line = bufferedReader.readLine()) != null) {
                log.info(line);
            }
            process.waitFor();
            exitValue = process.exitValue();
        }
        if (exitValue == 0) {
            return IJobHandler.SUCCESS;
        }
        return new ReturnT(IJobHandler.FAIL.getCode(), "command exit value(" + exitValue + ") is failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XxlJob(value="httpJobHandler")
    public ReturnT<String> httpJobHandler(String param) throws Exception {
        String[] methodArray = new String[]{"GET", "POST"};
        int okState = 200;
        if (param == null || param.trim().length() == 0) {
            log.info("param[" + param + "] invalid.");
            return ReturnT.FAIL;
        }
        String[] httpParams = param.split("\n");
        String url = null;
        String method = null;
        String data = null;
        for (String httpParam : httpParams) {
            if (httpParam.startsWith("url:")) {
                url = httpParam.substring(httpParam.indexOf("url:") + 4).trim();
            }
            if (httpParam.startsWith("method:")) {
                method = httpParam.substring(httpParam.indexOf("method:") + 7).trim().toUpperCase();
            }
            if (!httpParam.startsWith("data:")) continue;
            data = httpParam.substring(httpParam.indexOf("data:") + 5).trim();
        }
        if (url == null || url.trim().length() == 0) {
            log.info("url[" + url + "] invalid.");
            return ReturnT.FAIL;
        }
        if (method == null || !Arrays.asList(methodArray).contains(method)) {
            log.info("method[" + method + "] invalid.");
            return ReturnT.FAIL;
        }
        HttpURLConnection connection = null;
        BufferedReader bufferedReader = null;
        try {
            String line;
            int statusCode;
            URL realUrl = new URL(url);
            connection = (HttpURLConnection)realUrl.openConnection();
            connection.setRequestMethod(method);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setReadTimeout(5000);
            connection.setConnectTimeout(3000);
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            connection.setRequestProperty("Accept-Charset", "application/json;charset=UTF-8");
            connection.connect();
            if (data != null && data.trim().length() > 0) {
                DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());
                dataOutputStream.write(data.getBytes("UTF-8"));
                dataOutputStream.flush();
                dataOutputStream.close();
            }
            if ((statusCode = connection.getResponseCode()) != okState) {
                throw new RuntimeException("Http Request StatusCode(" + statusCode + ") Invalid.");
            }
            bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            StringBuilder result = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                result.append(line);
            }
            String responseMsg = result.toString();
            log.info(responseMsg);
            ReturnT returnT = ReturnT.SUCCESS;
            return returnT;
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
            ReturnT returnT = ReturnT.FAIL;
            return returnT;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Exception e2) {
                log.info(e2.getMessage(), (Throwable)e2);
            }
        }
    }

    @XxlJob(value="demoJobHandler2", init="init", destroy="destroy")
    public ReturnT<String> demoJobHandler2(String param) throws Exception {
        log.info("XXL-JOB, Hello World.");
        return ReturnT.SUCCESS;
    }

    public void init() {
        log.info("init");
    }

    public void destroy() {
        log.info("destory");
    }
}

