/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.test.lock;

import org.jeecg.boot.starter.lock.annotation.JLock;
import org.jeecg.boot.starter.lock.client.RedissonLockClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DemoLockTest {
    private static final Logger log = LoggerFactory.getLogger(DemoLockTest.class);
    @Autowired
    RedissonLockClient redissonLock;

    @Scheduled(cron="0/5 * * * * ?")
    @JLock(lockKey={"demoLockKey1"})
    public void execute() throws InterruptedException {
        log.info("\u6267\u884cexecute\u4efb\u52a1\u5f00\u59cb\uff0c\u4f11\u7720\u5341\u79d2\u5f00\u59cb\uff0c\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\u6233\uff08\u79d2\uff09\uff1a" + System.currentTimeMillis() / 1000L);
        Thread.sleep(10000L);
        log.info("========\u6267\u884c \u5206\u5e03\u5f0f\u9501 \u4e1a\u52a1\u903b\u8f911=============");
        log.info("execute\u4efb\u52a1\u7ed3\u675f\uff0c\u4f11\u7720\u5341\u79d2\u5b8c\u6210\uff0c\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\u6233\uff08\u79d2\uff09\uff1a" + System.currentTimeMillis() / 1000L);
    }

    public void execute2() throws InterruptedException {
        int expireSeconds = 6000;
        if (this.redissonLock.tryLock("demoLockKey2", -1L, (long)expireSeconds)) {
            log.info("\u6267\u884c\u4efb\u52a1execute2\u5f00\u59cb\uff0c\u4f11\u7720\u5341\u79d2");
            Thread.sleep(10000L);
            log.info("=============\u4e1a\u52a1\u903b\u8f912===================");
            log.info("\u5b9a\u65f6execute2\u7ed3\u675f\uff0c\u4f11\u7720\u5341\u79d2");
            this.redissonLock.unlock("demoLockKey2");
        } else {
            log.info("execute2\u83b7\u53d6\u9501\u5931\u8d25");
        }
    }
}

