/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.test.seata.product.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import io.seata.core.context.RootContext;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.jeecg.modules.test.seata.product.entity.SeataProduct;
import org.jeecg.modules.test.seata.product.mapper.SeataProductMapper;
import org.jeecg.modules.test.seata.product.service.SeataProductService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SeataProductServiceImpl
implements SeataProductService {
    private static final Logger log = LoggerFactory.getLogger(SeataProductServiceImpl.class);
    @Resource
    private SeataProductMapper productMapper;

    @Override
    @DS(value="product")
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public BigDecimal reduceStock(Long productId, Integer count) {
        log.info("xid:" + RootContext.getXID());
        log.info("=============PRODUCT START=================");
        SeataProduct product = (SeataProduct)this.productMapper.selectById(productId);
        Assert.notNull((Object)product, (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        Integer stock = product.getStock();
        log.info("\u5546\u54c1\u7f16\u53f7\u4e3a {} \u7684\u5e93\u5b58\u4e3a{},\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e3a{}", new Object[]{productId, stock, count});
        if (stock < count) {
            log.warn("\u5546\u54c1\u7f16\u53f7\u4e3a{} \u5e93\u5b58\u4e0d\u8db3\uff0c\u5f53\u524d\u5e93\u5b58:{}", (Object)productId, (Object)stock);
            throw new RuntimeException("\u5e93\u5b58\u4e0d\u8db3");
        }
        log.info("\u5f00\u59cb\u6263\u51cf\u5546\u54c1\u7f16\u53f7\u4e3a {} \u5e93\u5b58,\u5355\u4ef7\u5546\u54c1\u4ef7\u683c\u4e3a{}", (Object)productId, (Object)product.getPrice());
        int currentStock = stock - count;
        product.setStock(currentStock);
        this.productMapper.updateById(product);
        BigDecimal totalPrice = product.getPrice().multiply(new BigDecimal(count));
        log.info("\u6263\u51cf\u5546\u54c1\u7f16\u53f7\u4e3a {} \u5e93\u5b58\u6210\u529f,\u6263\u51cf\u540e\u5e93\u5b58\u4e3a{}, {} \u4ef6\u5546\u54c1\u603b\u4ef7\u4e3a {} ", new Object[]{productId, currentStock, count, totalPrice});
        log.info("=============PRODUCT END=================");
        return totalPrice;
    }
}

