/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.entity.SysUserDepart;
import org.jeecg.modules.system.mapper.SysUserDepartMapper;
import org.jeecg.modules.system.mapper.SysUserMapper;
import org.jeecg.modules.system.mapper.SysUserTenantMapper;
import org.jeecg.modules.system.model.DepartIdModel;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.service.ISysUserDepartService;
import org.jeecg.modules.system.service.ISysUserService;
import org.jeecg.modules.system.vo.SysUserDepVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SysUserDepartServiceImpl
extends ServiceImpl<SysUserDepartMapper, SysUserDepart>
implements ISysUserDepartService {
    @Autowired
    private ISysDepartService sysDepartService;
    @Lazy
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private SysUserTenantMapper userTenantMapper;

    @Override
    public List<DepartIdModel> queryDepartIdsOfUser(String userId) {
        LambdaQueryWrapper queryUserDep = new LambdaQueryWrapper();
        LambdaQueryWrapper queryDep = new LambdaQueryWrapper();
        try {
            queryUserDep.eq(SysUserDepart::getUserId, (Object)userId);
            ArrayList<String> depIdList = new ArrayList<String>();
            ArrayList<DepartIdModel> depIdModelList = new ArrayList<DepartIdModel>();
            List userDepList = this.list((Wrapper)queryUserDep);
            if (userDepList != null && userDepList.size() > 0) {
                for (SysUserDepart userDepart : userDepList) {
                    depIdList.add(userDepart.getDepId());
                }
                if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
                    Integer tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
                    queryDep.eq(SysDepart::getTenantId, (Object)tenantId);
                }
                queryDep.in(SysDepart::getId, depIdList);
                List depList = this.sysDepartService.list((Wrapper)queryDep);
                if (depList != null && depList.size() > 0) {
                    for (SysDepart depart : depList) {
                        depIdModelList.add(new DepartIdModel().convertByUserDepart(depart));
                    }
                }
                return depIdModelList;
            }
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
        return null;
    }

    @Override
    public List<SysUser> queryUserByDepId(String depId) {
        LambdaQueryWrapper queryUserDep = new LambdaQueryWrapper();
        queryUserDep.eq(SysUserDepart::getDepId, (Object)depId);
        ArrayList<String> userIdList = new ArrayList<String>();
        List uDepList = this.list((Wrapper)queryUserDep);
        if (uDepList != null && uDepList.size() > 0) {
            for (SysUserDepart uDep : uDepList) {
                userIdList.add(uDep.getUserId());
            }
            List userList = this.sysUserMapper.selectBatchIds(userIdList);
            for (SysUser sysUser : userList) {
                sysUser.setSalt("");
                sysUser.setPassword("");
            }
            return userList;
        }
        return new ArrayList<SysUser>();
    }

    @Override
    public List<SysUser> queryUserByDepCode(String depCode, String realname) {
        if (oConvertUtils.isNotEmpty((Object)realname)) {
            realname = realname.trim();
        }
        List<SysUser> userList = ((SysUserDepartMapper)this.baseMapper).queryDepartUserList(depCode, realname);
        HashMap<String, SysUser> map = new HashMap<String, SysUser>(5);
        for (SysUser sysUser : userList) {
            sysUser.setSalt("");
            sysUser.setPassword("");
            map.put(sysUser.getId(), sysUser);
        }
        return new ArrayList<SysUser>(map.values());
    }

    @Override
    public IPage<SysUser> queryDepartUserPageList(String departId, String username, String realname, int pageSize, int pageNo, String id, String isMultiTranslate) {
        IPage pageList = null;
        Page page = new Page((long)pageNo, (long)pageSize);
        if (oConvertUtils.isEmpty((Object)departId)) {
            String tenantId;
            List<String> userIdList;
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(SysUser::getStatus, (Object)Integer.parseInt("1"));
            if (oConvertUtils.isNotEmpty((Object)username)) {
                String COMMA = ",";
                if (oConvertUtils.isNotEmpty((Object)isMultiTranslate) && username.contains(COMMA)) {
                    Object[] usernameArr = username.split(COMMA);
                    query.in(SysUser::getUsername, usernameArr);
                } else {
                    query.like(SysUser::getUsername, (Object)username);
                }
            }
            if (oConvertUtils.isNotEmpty((Object)id)) {
                query.eq(SysUser::getId, (Object)id);
            }
            query.ne(SysUser::getUsername, (Object)"_reserve_user_external");
            if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue() && null != (userIdList = this.userTenantMapper.getUserIdsByTenantId(Integer.valueOf(tenantId = oConvertUtils.getString((String)TenantContext.getTenant(), (String)"0")))) && userIdList.size() > 0) {
                query.in(SysUser::getId, userIdList);
            }
            pageList = this.sysUserMapper.selectPage((IPage)page, (Wrapper)query);
        } else {
            SysDepart sysDepart = (SysDepart)this.sysDepartService.getById((Serializable)((Object)departId));
            pageList = ((SysUserDepartMapper)this.baseMapper).queryDepartUserPageList((Page<SysUser>)page, sysDepart.getOrgCode(), username, realname);
        }
        List userList = pageList.getRecords();
        if (userList != null && userList.size() > 0) {
            List<String> userIds = userList.stream().map(SysUser::getId).collect(Collectors.toList());
            HashMap map = new HashMap(5);
            if (userIds != null && userIds.size() > 0) {
                Map<String, String> useDepNames = this.getDepNamesByUserIds(userIds);
                userList.forEach(item -> {
                    item.setOrgCodeTxt((String)useDepNames.get(item.getId()));
                    item.setSalt("");
                    item.setPassword("");
                    map.put(item.getId(), item);
                });
            }
            pageList.setRecords(new ArrayList(map.values()));
        }
        return pageList;
    }

    @Override
    public IPage<SysUser> getUserInformation(Integer tenantId, String departId, String keyword, Integer pageSize, Integer pageNo) {
        IPage pageList = null;
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (oConvertUtils.isEmpty((Object)departId)) {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(SysUser::getStatus, (Object)Integer.parseInt("1"));
            query.ne(SysUser::getUsername, (Object)"_reserve_user_external");
            if (tenantId != null) {
                List<String> userIds = this.userTenantMapper.getUserIdsByTenantId(tenantId);
                if (oConvertUtils.listIsNotEmpty(userIds)) {
                    query.in(SysUser::getId, userIds);
                } else {
                    query.eq(SysUser::getId, (Object)"\u901a\u8fc7\u79df\u6237ID\u67e5\u4e0d\u5230\u7528\u6237");
                }
            }
            query.ne(SysUser::getId, (Object)sysUser.getId());
            if (StringUtils.isNotEmpty((CharSequence)keyword)) {
                query.and(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(SysUser::getUsername, (Object)keyword)).or()).like(SysUser::getRealname, (Object)keyword);
                });
            }
            pageList = this.sysUserMapper.selectPage((IPage)page, (Wrapper)query);
        } else {
            SysDepart sysDepart = (SysDepart)this.sysDepartService.getById((Serializable)((Object)departId));
            pageList = ((SysUserDepartMapper)this.baseMapper).getUserInformation((Page<SysUser>)page, sysDepart.getOrgCode(), keyword, sysUser.getId());
        }
        return pageList;
    }

    @Override
    public IPage<SysUser> getUserInformation(Integer tenantId, String departId, String roleId, String keyword, Integer pageSize, Integer pageNo, String excludeUserIdList) {
        IPage pageList = null;
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        ArrayList<String> userIdList = new ArrayList();
        if (oConvertUtils.isNotEmpty((Object)excludeUserIdList)) {
            userIdList = Arrays.asList(excludeUserIdList.split(","));
        }
        if (oConvertUtils.isNotEmpty((Object)departId)) {
            SysDepart sysDepart = (SysDepart)this.sysDepartService.getById((Serializable)((Object)departId));
            pageList = ((SysUserDepartMapper)this.baseMapper).getProcessUserList((Page<SysUser>)page, sysDepart.getOrgCode(), keyword, tenantId, userIdList);
        } else if (oConvertUtils.isNotEmpty((Object)roleId)) {
            pageList = this.sysUserMapper.selectUserListByRoleId((Page<SysUser>)page, roleId, keyword, tenantId, userIdList);
        } else {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(SysUser::getStatus, (Object)Integer.parseInt("1"));
            query.ne(SysUser::getUsername, (Object)"_reserve_user_external");
            if (oConvertUtils.isNotEmpty((Object)excludeUserIdList)) {
                query.notIn(SysUser::getId, Arrays.asList(excludeUserIdList.split(",")));
            }
            if (tenantId != null) {
                List<String> userIds = this.userTenantMapper.getUserIdsByTenantId(tenantId);
                if (oConvertUtils.listIsNotEmpty(userIds)) {
                    query.in(SysUser::getId, userIds);
                } else {
                    query.eq(SysUser::getId, (Object)"\u901a\u8fc7\u79df\u6237ID\u67e5\u4e0d\u5230\u7528\u6237");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)keyword)) {
                query.and(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(SysUser::getUsername, (Object)keyword)).or()).like(SysUser::getRealname, (Object)keyword);
                });
            }
            pageList = this.sysUserMapper.selectPage((IPage)page, (Wrapper)query);
        }
        List<String> userIds = pageList.getRecords().stream().map(SysUser::getId).collect(Collectors.toList());
        if (userIds.size() > 0) {
            Map<String, String> useDepNames = this.sysUserService.getDepNamesByUserIds(userIds);
            pageList.getRecords().forEach(item -> item.setOrgCodeTxt((String)useDepNames.get(item.getId())));
        }
        return pageList;
    }

    @Override
    public List<SysUser> getUsersByDepartTenantId(String departId, Integer tenantId) {
        return ((SysUserDepartMapper)this.baseMapper).getUsersByDepartTenantId(departId, tenantId);
    }

    private Map<String, String> getDepNamesByUserIds(List<String> userIds) {
        List<SysUserDepVo> list = this.sysUserMapper.getDepNamesByUserIds(userIds);
        HashMap<String, String> res = new HashMap<String, String>(5);
        list.forEach(item -> {
            if (res.get(item.getUserId()) == null) {
                res.put(item.getUserId(), item.getDepartName());
            } else {
                res.put(item.getUserId(), (String)res.get(item.getUserId()) + "," + item.getDepartName());
            }
        });
        return res;
    }
}

