/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.List;
import org.jeecg.common.base.BaseMap;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysGatewayRoute;
import org.jeecg.modules.system.mapper.SysGatewayRouteMapper;
import org.jeecg.modules.system.service.ISysGatewayRouteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysGatewayRouteServiceImpl
extends ServiceImpl<SysGatewayRouteMapper, SysGatewayRoute>
implements ISysGatewayRouteService {
    private static final Logger log = LoggerFactory.getLogger(SysGatewayRouteServiceImpl.class);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    private static final String STRING_STATUS = "status";

    @Override
    public void addRoute2Redis(String key) {
        List ls = this.list((Wrapper)new LambdaQueryWrapper());
        this.redisTemplate.opsForValue().set((Object)key, (Object)JSON.toJSONString((Object)ls));
    }

    @Override
    public void deleteById(String id) {
        this.removeById((Serializable)((Object)id));
        this.resreshRouter(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateAll(JSONObject json) {
        log.info("--gateway \u8def\u7531\u914d\u7f6e\u4fee\u6539--");
        try {
            json = json.getJSONObject("router");
            String id = json.getString("id");
            SysGatewayRoute route = oConvertUtils.isEmpty((Object)id) ? new SysGatewayRoute() : (SysGatewayRoute)this.getById((Serializable)((Object)id));
            if (ObjectUtil.isEmpty((Object)route)) {
                route = new SysGatewayRoute();
            }
            route.setRouterId(json.getString("routerId"));
            route.setName(json.getString("name"));
            route.setPredicates(json.getString("predicates"));
            String filters = json.getString("filters");
            if (ObjectUtil.isEmpty((Object)filters)) {
                filters = "[]";
            }
            route.setFilters(filters);
            route.setUri(json.getString("uri"));
            if (json.get((Object)STRING_STATUS) == null) {
                route.setStatus(1);
            } else {
                route.setStatus(json.getInteger(STRING_STATUS));
            }
            this.saveOrUpdate(route);
            this.resreshRouter(null);
        }
        catch (Exception e) {
            log.error("\u8def\u7531\u914d\u7f6e\u89e3\u6790\u5931\u8d25", (Throwable)e);
            this.resreshRouter(null);
            e.printStackTrace();
        }
    }

    private void resreshRouter(String delRouterId) {
        this.addRoute2Redis("sys:cache:cloud:gateway_routes");
        BaseMap params = new BaseMap();
        params.put("handlerName", (Object)"loderRouderHandler");
        params.put("delRouterId", (Object)delRouterId);
        this.redisTemplate.convertAndSend("jeecg_redis_topic", (Object)params);
    }

    @Override
    public void clearRedis() {
        this.redisTemplate.opsForValue().set((Object)"sys:cache:cloud:gateway_routes", null);
    }
}

