/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import cn.hutool.core.util.RandomUtil;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.util.ResourceUtil;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.system.vo.DictModelMany;
import org.jeecg.common.system.vo.DictQuery;
import org.jeecg.common.util.CommonUtils;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.SqlInjectionUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.modules.system.entity.SysDict;
import org.jeecg.modules.system.entity.SysDictItem;
import org.jeecg.modules.system.mapper.SysDictItemMapper;
import org.jeecg.modules.system.mapper.SysDictMapper;
import org.jeecg.modules.system.model.DuplicateCheckVo;
import org.jeecg.modules.system.model.TreeSelectModel;
import org.jeecg.modules.system.security.DictQueryBlackListHandler;
import org.jeecg.modules.system.service.ISysDictService;
import org.jeecg.modules.system.vo.lowapp.SysDictVo;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SysDictServiceImpl
extends ServiceImpl<SysDictMapper, SysDict>
implements ISysDictService {
    private static final Logger log = LoggerFactory.getLogger(SysDictServiceImpl.class);
    @Autowired
    private SysDictMapper sysDictMapper;
    @Autowired
    private SysDictItemMapper sysDictItemMapper;
    @Autowired
    private DictQueryBlackListHandler dictQueryBlackListHandler;
    @Lazy
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Lazy
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public boolean duplicateCheckData(DuplicateCheckVo duplicateCheckVo) {
        Long count = null;
        String table = SqlInjectionUtil.getSqlInjectTableName((String)duplicateCheckVo.getTableName());
        String fieldName = SqlInjectionUtil.getSqlInjectField((String)duplicateCheckVo.getFieldName());
        duplicateCheckVo.setTableName(table);
        duplicateCheckVo.setFieldName(fieldName);
        SqlInjectionUtil.filterContentMulti((String[])new String[]{table, fieldName});
        String checkSql = table + "," + fieldName + ",";
        this.sysBaseAPI.dictTableWhiteListCheckByDict(table, new String[]{fieldName});
        this.dictQueryBlackListHandler.isPass(checkSql);
        try {
            count = StringUtils.isNotBlank((String)duplicateCheckVo.getDataId()) ? this.sysDictMapper.duplicateCheckCountSql(duplicateCheckVo) : this.sysDictMapper.duplicateCheckCountSqlNoDataId(duplicateCheckVo);
        }
        catch (MyBatisSystemException e) {
            log.error(e.getMessage(), (Throwable)e);
            String errorCause = "\u67e5\u8be2\u5f02\u5e38,\u8bf7\u68c0\u67e5\u552f\u4e00\u6821\u9a8c\u7684\u914d\u7f6e\uff01";
            throw new JeecgBootException(errorCause);
        }
        if (count == null || count == 0L) {
            return true;
        }
        log.info("\u8be5\u503c\u4e0d\u53ef\u7528\uff0c\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff01");
        return false;
    }

    @Override
    @Cacheable(value={"sys:cache:dict"}, key="#code", unless="#result == null ")
    public List<DictModel> queryDictItemsByCode(String code) {
        log.debug("\u65e0\u7f13\u5b58dictCache\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        return this.sysDictMapper.queryDictItemsByCode(code);
    }

    @Override
    @Cacheable(value={"sys:cache:dictEnable"}, key="#code", unless="#result == null ")
    public List<DictModel> queryEnableDictItemsByCode(String code) {
        log.debug("\u65e0\u7f13\u5b58dictCache\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        return this.sysDictMapper.queryEnableDictItemsByCode(code);
    }

    @Override
    public Map<String, List<DictModel>> queryDictItemsByCodeList(List<String> dictCodeList) {
        List<DictModelMany> list = this.sysDictMapper.queryDictItemsByCodeList(dictCodeList);
        HashMap<String, List<DictModel>> dictMap = new HashMap<String, List<DictModel>>(5);
        for (DictModelMany dict : list) {
            List dictItemList = dictMap.computeIfAbsent(dict.getDictCode(), i -> new ArrayList());
            dictItemList.add(new DictModel(dict.getValue(), dict.getText(), dict.getColor()));
        }
        return dictMap;
    }

    @Override
    public Map<String, List<DictModel>> queryAllDictItems() {
        log.info(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        long start = System.currentTimeMillis();
        Map<Object, Object> sysAllDictItems = new HashMap(5);
        ArrayList<Integer> tenantIds = null;
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            tenantIds = new ArrayList<Integer>();
            tenantIds.add(0);
            if (TenantContext.getTenant() != null) {
                tenantIds.add(oConvertUtils.getInt((String)TenantContext.getTenant()));
            }
        }
        List<DictModelMany> sysDictItemList = this.sysDictMapper.queryAllDictItems(tenantIds);
        sysAllDictItems = sysDictItemList.stream().collect(Collectors.groupingBy(DictModelMany::getDictCode, Collectors.mapping(d -> new DictModel(d.getValue(), d.getText(), d.getColor()), Collectors.toList())));
        log.info("      >>> 1 \u83b7\u53d6\u7cfb\u7edf\u5b57\u5178\u9879\u8017\u65f6\uff08SQL\uff09\uff1a" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        Map enumRes = ResourceUtil.getEnumDictData();
        sysAllDictItems.putAll(enumRes);
        log.info("      >>> 2 \u83b7\u53d6\u7cfb\u7edf\u5b57\u5178\u9879\u8017\u65f6\uff08Enum\uff09\uff1a" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        log.info("      >>> end \u83b7\u53d6\u7cfb\u7edf\u5b57\u5178\u5e93\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        log.info(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        return sysAllDictItems;
    }

    @Override
    @Cacheable(value={"sys:cache:dict"}, key="#code+':'+#key", unless="#result == null ")
    public String queryDictTextByKey(String code, String key) {
        log.debug("\u65e0\u7f13\u5b58dictText\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        return this.sysDictMapper.queryDictTextByKey(code, key);
    }

    @Override
    public Map<String, List<DictModel>> queryManyDictByKeys(List<String> dictCodeList, List<String> keys) {
        List<DictModelMany> list = this.sysDictMapper.queryManyDictByKeys(dictCodeList, keys);
        HashMap<String, List<DictModel>> dictMap = new HashMap<String, List<DictModel>>(5);
        for (DictModelMany dict : list) {
            List dictItemList = dictMap.computeIfAbsent(dict.getDictCode(), i -> new ArrayList());
            dictItemList.add(new DictModel(dict.getValue(), dict.getText()));
        }
        Map enumRes = ResourceUtil.queryManyDictByKeys(dictCodeList, keys);
        dictMap.putAll(enumRes);
        return dictMap;
    }

    @Override
    @Deprecated
    public List<DictModel> queryTableDictItemsByCode(String tableFilterSql, String text, String code) {
        log.debug("\u65e0\u7f13\u5b58dictTableList\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        String str = tableFilterSql + "," + text + "," + code;
        this.sysBaseAPI.dictTableWhiteListCheckByDict(tableFilterSql, new String[]{text, code});
        if (!this.dictQueryBlackListHandler.isPass(str)) {
            log.error(this.dictQueryBlackListHandler.getError());
            return null;
        }
        String table = null;
        String filterSql = null;
        if (tableFilterSql.toLowerCase().indexOf("where") > 0) {
            String[] arr = tableFilterSql.split(" (?i)where ");
            table = arr[0];
            filterSql = oConvertUtils.getString((String)arr[1], null);
        } else {
            table = tableFilterSql;
        }
        SqlInjectionUtil.filterContentMulti((String[])new String[]{table, text, code});
        SqlInjectionUtil.specialFilterContentForDictSql((String)filterSql);
        table = SqlInjectionUtil.getSqlInjectTableName((String)table);
        text = SqlInjectionUtil.getSqlInjectField((String)text);
        code = SqlInjectionUtil.getSqlInjectField((String)code);
        return this.sysDictMapper.queryTableDictWithFilter(table, text, code, filterSql);
    }

    @Override
    public List<DictModel> queryTableDictItemsByCodeAndFilter(String table, String text, String code, String filterSql) {
        log.debug("\u65e0\u7f13\u5b58dictTableList\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        SqlInjectionUtil.specialFilterContentForDictSql((String)table);
        SqlInjectionUtil.filterContentMulti((String[])new String[]{text, code});
        SqlInjectionUtil.specialFilterContentForDictSql((String)filterSql);
        String str = table + "," + text + "," + code;
        this.sysBaseAPI.dictTableWhiteListCheckByDict(table, new String[]{text, code});
        if (!this.dictQueryBlackListHandler.isPass(str)) {
            log.error(this.dictQueryBlackListHandler.getError());
            return null;
        }
        table = SqlInjectionUtil.getSqlInjectTableName((String)table);
        text = SqlInjectionUtil.getSqlInjectField((String)text);
        code = SqlInjectionUtil.getSqlInjectField((String)code);
        return this.sysDictMapper.queryTableDictWithFilter(table, text, code, filterSql);
    }

    @Override
    @Cacheable(value={"sys:cache:dictTable"}, unless="#result == null ")
    public String queryTableDictTextByKey(String table, String text, String code, String key) {
        log.debug("\u65e0\u7f13\u5b58dictTable\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        String str = table + "," + text + "," + code;
        this.sysBaseAPI.dictTableWhiteListCheckByDict(table, new String[]{text, code});
        if (!this.dictQueryBlackListHandler.isPass(str)) {
            log.error(this.dictQueryBlackListHandler.getError());
            return null;
        }
        SqlInjectionUtil.filterContentMulti((String[])new String[]{table, text, code, key});
        table = SqlInjectionUtil.getSqlInjectTableName((String)table);
        text = SqlInjectionUtil.getSqlInjectField((String)text);
        code = SqlInjectionUtil.getSqlInjectField((String)code);
        List<DictModel> dictModeList = this.sysDictMapper.queryTableDictByKeysAndFilterSql(table, text, code, null, Arrays.asList(key));
        if (CollectionUtils.isEmpty(dictModeList)) {
            return null;
        }
        return dictModeList.get(0).getText();
    }

    @Override
    public List<DictModel> queryTableDictTextByKeys(String table, String text, String code, List<String> codeValues, String dataSource) {
        String str = table + "," + text + "," + code;
        boolean isCustomDataSource = oConvertUtils.isNotEmpty((Object)dataSource);
        if (!isCustomDataSource) {
            this.sysBaseAPI.dictTableWhiteListCheckByDict(table, new String[]{text, code});
            if (!this.dictQueryBlackListHandler.isPass(str)) {
                log.error(this.dictQueryBlackListHandler.getError());
                return null;
            }
        }
        String filterSql = null;
        if (table.toLowerCase().indexOf("where") > 0) {
            String[] arr = table.split(" (?i)where ");
            table = arr[0];
            filterSql = arr[1];
        }
        SqlInjectionUtil.filterContentMulti((String[])new String[]{table, text, code});
        SqlInjectionUtil.specialFilterContentForDictSql((String)filterSql);
        table = SqlInjectionUtil.getSqlInjectTableName((String)table);
        text = SqlInjectionUtil.getSqlInjectField((String)text);
        code = SqlInjectionUtil.getSqlInjectField((String)code);
        if (isCustomDataSource) {
            DynamicDataSourceContextHolder.push((String)dataSource);
        }
        List<DictModel> restData = this.sysDictMapper.queryTableDictByKeysAndFilterSql(table, text, code, filterSql, codeValues);
        if (isCustomDataSource) {
            DynamicDataSourceContextHolder.clear();
        }
        return restData;
    }

    @Override
    public List<String> queryTableDictByKeys(String table, String text, String code, String keys) {
        String str = table + "," + text + "," + code;
        this.sysBaseAPI.dictTableWhiteListCheckByDict(table, new String[]{text, code});
        if (!this.dictQueryBlackListHandler.isPass(str)) {
            log.error(this.dictQueryBlackListHandler.getError());
            return null;
        }
        return this.queryTableDictByKeys(table, text, code, keys, true);
    }

    @Override
    public List<String> queryTableDictByKeys(String table, String text, String code, String codeValuesStr, boolean delNotExist) {
        if (oConvertUtils.isEmpty((Object)codeValuesStr)) {
            return null;
        }
        String filterSql = null;
        if (table.toLowerCase().indexOf("where") != -1) {
            String[] arr = table.split(" (?i)where ");
            table = arr[0];
            filterSql = arr[1];
        }
        SqlInjectionUtil.filterContentMulti((String[])new String[]{table, text, code});
        SqlInjectionUtil.specialFilterContentForDictSql((String)filterSql);
        String str = table + "," + text + "," + code;
        this.sysBaseAPI.dictTableWhiteListCheckByDict(table, new String[]{text, code});
        if (!this.dictQueryBlackListHandler.isPass(str)) {
            log.error(this.dictQueryBlackListHandler.getError());
            return null;
        }
        table = SqlInjectionUtil.getSqlInjectTableName((String)table);
        text = SqlInjectionUtil.getSqlInjectField((String)text);
        code = SqlInjectionUtil.getSqlInjectField((String)code);
        String[] codeValues = codeValuesStr.split(",");
        List<DictModel> dicts = this.sysDictMapper.queryTableDictByKeysAndFilterSql(SqlInjectionUtil.getSqlInjectTableName((String)table), SqlInjectionUtil.getSqlInjectField((String)text), SqlInjectionUtil.getSqlInjectField((String)code), filterSql, Arrays.asList(codeValues));
        ArrayList<String> texts = new ArrayList<String>(dicts.size());
        for (String conditionalVal : codeValues) {
            List res = dicts.stream().filter(i -> conditionalVal.equals(i.getValue())).collect(Collectors.toList());
            if (res.size() > 0) {
                texts.add(((DictModel)res.get(0)).getText());
                continue;
            }
            if (delNotExist) continue;
            texts.add(conditionalVal);
        }
        return texts;
    }

    @Override
    public boolean deleteByDictId(SysDict sysDict) {
        sysDict.setDelFlag(CommonConstant.DEL_FLAG_1);
        return this.updateById(sysDict);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer saveMain(SysDict sysDict, List<SysDictItem> sysDictItemList) {
        int insert = 0;
        try {
            insert = this.sysDictMapper.insert(sysDict);
            if (sysDictItemList != null) {
                for (SysDictItem entity : sysDictItemList) {
                    if (oConvertUtils.isEmpty((Object)entity.getItemValue())) {
                        return -1;
                    }
                    entity.setDictId(sysDict.getId());
                    entity.setStatus(1);
                    this.sysDictItemMapper.insert(entity);
                }
            }
        }
        catch (Exception e) {
            return insert;
        }
        return insert;
    }

    @Override
    public List<DictModel> queryAllDepartBackDictModel() {
        return ((SysDictMapper)this.baseMapper).queryAllDepartBackDictModel();
    }

    @Override
    public List<DictModel> queryAllUserBackDictModel() {
        return ((SysDictMapper)this.baseMapper).queryAllUserBackDictModel();
    }

    @Override
    public List<DictModel> queryLittleTableDictItems(String tableSql, String text, String code, String condition, String keyword, int pageSize) {
        Page page = new Page(1L, (long)pageSize);
        page.setSearchCount(false);
        String table = SqlInjectionUtil.getSqlInjectTableName((String)CommonUtils.getTableNameByTableSql((String)tableSql));
        text = SqlInjectionUtil.getSqlInjectField((String)text);
        code = SqlInjectionUtil.getSqlInjectField((String)code);
        String filterSql = this.getFilterSql(tableSql, text, code, condition, keyword);
        IPage<DictModel> pageList = ((SysDictMapper)this.baseMapper).queryPageTableDictWithFilter((Page<DictModel>)page, table, text, code, filterSql);
        return pageList.getRecords();
    }

    private String getFilterSql(String tableSql, String text, String code, String condition, String keyword) {
        String filterSql = "";
        String keywordSql = null;
        String sqlWhere = "where ";
        String sqlAnd = " and ";
        boolean tableHasWhere = tableSql.toLowerCase().contains(sqlWhere);
        if (tableHasWhere) {
            sqlWhere = CommonUtils.getFilterSqlByTableSql((String)tableSql);
        }
        String orderField = "";
        String orderType = "";
        if (oConvertUtils.isNotEmpty((Object)keyword)) {
            String orderKey = "[orderby";
            if (keyword.indexOf(orderKey) >= 0 && keyword.endsWith("]")) {
                String orderInfo = keyword.substring(keyword.indexOf(orderKey) + orderKey.length() + 1, keyword.length() - 1);
                keyword = keyword.substring(0, keyword.indexOf(orderKey));
                String[] orderInfoArray = orderInfo.split(",");
                orderField = orderInfoArray[0];
                orderType = orderInfoArray[1];
            }
            if (oConvertUtils.isNotEmpty((Object)keyword)) {
                if (keyword.contains(",")) {
                    String inKeywords = "'" + String.join((CharSequence)"','", keyword.split(",")) + "'";
                    keywordSql = "(" + text + " in (" + inKeywords + ") or " + code + " in (" + inKeywords + "))";
                } else {
                    keywordSql = "(" + text + " like '%" + keyword + "%' or " + code + " like '%" + keyword + "%')";
                }
            }
        }
        if (oConvertUtils.isNotEmpty((Object)condition) && oConvertUtils.isNotEmpty(keywordSql)) {
            filterSql = filterSql + sqlWhere + (tableHasWhere ? sqlAnd : " ") + condition + sqlAnd + keywordSql;
        } else if (oConvertUtils.isNotEmpty((Object)condition)) {
            filterSql = filterSql + sqlWhere + (tableHasWhere ? sqlAnd : " ") + condition;
        } else if (oConvertUtils.isNotEmpty(keywordSql)) {
            filterSql = filterSql + sqlWhere + (tableHasWhere ? sqlAnd : " ") + keywordSql;
        } else if (tableHasWhere) {
            filterSql = filterSql + sqlWhere;
        }
        if (oConvertUtils.isNotEmpty((Object)orderField)) {
            filterSql = filterSql + " order by " + orderField + " " + orderType;
        }
        String wherePrefix = "(?i)where ";
        String filterSqlString = filterSql.trim().replaceAll("(?i)where ", "");
        SqlInjectionUtil.specialFilterContentForDictSql((String)filterSqlString);
        if (oConvertUtils.isNotEmpty((Object)filterSqlString) && filterSqlString.trim().toUpperCase().startsWith("ORDER")) {
            filterSqlString = " 1=1 " + filterSqlString;
        }
        return filterSqlString;
    }

    @Override
    public List<DictModel> queryAllTableDictItems(String table, String text, String code, String condition, String keyword) {
        String filterSql = this.getFilterSql(table, text, code, condition, keyword);
        table = SqlInjectionUtil.getSqlInjectTableName((String)table);
        text = SqlInjectionUtil.getSqlInjectField((String)text);
        code = SqlInjectionUtil.getSqlInjectField((String)code);
        List<DictModel> ls = ((SysDictMapper)this.baseMapper).queryTableDictWithFilter(table, text, code, filterSql);
        return ls;
    }

    @Override
    public List<TreeSelectModel> queryTreeList(Map<String, String> query, String table, String text, String code, String pidField, String pid, String hasChildField, int converIsLeafVal) {
        table = SqlInjectionUtil.getSqlInjectTableName((String)table);
        text = SqlInjectionUtil.getSqlInjectField((String)text);
        code = SqlInjectionUtil.getSqlInjectField((String)code);
        pidField = SqlInjectionUtil.getSqlInjectField((String)pidField);
        hasChildField = SqlInjectionUtil.getSqlInjectField((String)hasChildField);
        if (oConvertUtils.isEmpty((Object)text) || oConvertUtils.isEmpty((Object)code)) {
            log.warn("text={}\uff0ccode={}", (Object)text, (Object)code);
            log.warn("\u52a0\u8f7d\u6811\u5b57\u5178\u53c2\u6570\u6709\u8bef\uff0ctext\u548ccode\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
            return null;
        }
        String dictCode = table + "," + text + "," + code;
        SqlInjectionUtil.filterContentMulti((String[])new String[]{dictCode});
        this.sysBaseAPI.dictTableWhiteListCheckByDict(table, new String[]{text, code});
        if (!this.dictQueryBlackListHandler.isPass(dictCode)) {
            log.error("Sql\u5f02\u5e38\uff1a{}", (Object)this.dictQueryBlackListHandler.getError());
            return null;
        }
        HashMap<String, String> queryParams = null;
        if (query != null) {
            queryParams = new HashMap<String, String>(5);
            for (Map.Entry<String, String> searchItem : query.entrySet()) {
                String fieldName = searchItem.getKey();
                queryParams.put(SqlInjectionUtil.getSqlInjectField((String)fieldName), searchItem.getValue());
            }
        }
        return ((SysDictMapper)this.baseMapper).queryTreeList(queryParams, table, text, code, pidField, pid, hasChildField, converIsLeafVal);
    }

    @Override
    public void deleteOneDictPhysically(String id) {
        ((SysDictMapper)this.baseMapper).deleteOneById(id);
        this.sysDictItemMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysDictItem::getDictId, (Object)id));
    }

    @Override
    public void updateDictDelFlag(int delFlag, String id) {
        ((SysDictMapper)this.baseMapper).updateDictDelFlag(delFlag, id);
    }

    @Override
    public List<SysDict> queryDeleteList(String tenantId) {
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            if (oConvertUtils.isEmpty((Object)tenantId)) {
                return new ArrayList<SysDict>();
            }
            return ((SysDictMapper)this.baseMapper).queryDeleteListBtTenantId(oConvertUtils.getInt((String)tenantId));
        }
        return ((SysDictMapper)this.baseMapper).queryDeleteList();
    }

    @Override
    public List<DictModel> queryDictTablePageList(DictQuery query, int pageSize, int pageNo) {
        Page page = new Page((long)pageNo, (long)pageSize, false);
        String table = SqlInjectionUtil.getSqlInjectTableName((String)query.getTable());
        String text = SqlInjectionUtil.getSqlInjectTableName((String)query.getText());
        String code = SqlInjectionUtil.getSqlInjectTableName((String)query.getCode());
        query.setCode(table);
        query.setTable(text);
        query.setText(code);
        String dictCode = table + "," + text + "," + code;
        this.sysBaseAPI.dictTableWhiteListCheckByDict(table, new String[]{text, code});
        if (!this.dictQueryBlackListHandler.isPass(dictCode)) {
            log.error(this.dictQueryBlackListHandler.getError());
            return null;
        }
        SqlInjectionUtil.filterContentMulti((String[])new String[]{dictCode});
        Page<DictModel> pageList = ((SysDictMapper)this.baseMapper).queryDictTablePageList(page, query);
        return pageList.getRecords();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<DictModel> getDictItems(String dictCode) {
        Map map;
        List<DictModel> ls;
        if (dictCode.contains(",")) {
            String[] params = dictCode.split(",");
            if (params.length < 3) {
                return null;
            }
            if (params.length == 4) {
                ls = this.queryTableDictItemsByCodeAndFilter(params[0], params[1], params[2], params[3]);
            } else {
                if (params.length != 3) return null;
                ls = this.queryTableDictItemsByCode(params[0], params[1], params[2]);
            }
        } else {
            ls = this.queryDictItemsByCode(dictCode);
        }
        if (ls != null && ls.size() != 0 || !(map = ResourceUtil.getEnumDictData()).containsKey(dictCode)) return ls;
        return (List)map.get(dictCode);
    }

    @Override
    public List<DictModel> loadDict(String dictCode, String keyword, Integer pageSize) {
        this.sysBaseAPI.dictTableWhiteListCheckByDict(dictCode, new String[0]);
        if (!this.dictQueryBlackListHandler.isPass(dictCode)) {
            log.error(this.dictQueryBlackListHandler.getError());
            return null;
        }
        SqlInjectionUtil.specialFilterContentForDictSql((String)dictCode);
        if (dictCode.contains(",")) {
            String[] params = dictCode.split(",");
            String condition = null;
            if (params.length != 3 && params.length != 4) {
                return null;
            }
            if (params.length == 4 && (condition = params[3]).indexOf("#{") >= 0) {
                condition = QueryGenerator.getSqlRuleValue((String)condition);
            }
            if (oConvertUtils.isEmpty((Object)params[0])) {
                return null;
            }
            List<DictModel> ls = pageSize != null ? this.queryLittleTableDictItems(params[0], params[1], params[2], condition, keyword, pageSize) : this.queryAllTableDictItems(params[0], params[1], params[2], condition, keyword);
            return ls;
        }
        return null;
    }

    @Override
    public List<SysDictVo> getDictListByLowAppId(String lowAppId) {
        int tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        List<SysDict> list = ((SysDictMapper)this.baseMapper).getDictListByLowAppId(lowAppId, tenantId);
        ArrayList<SysDictVo> dictVoList = new ArrayList<SysDictVo>();
        for (SysDict dict : list) {
            SysDictVo dictVo = new SysDictVo();
            BeanUtils.copyProperties((Object)dict, (Object)dictVo);
            List<SysDictItem> sysDictItems = this.sysDictItemMapper.selectItemsByMainId(dict.getId());
            dictVo.setDictItemsList(sysDictItems);
            dictVoList.add(dictVo);
        }
        return dictVoList;
    }

    @Override
    public String addDictByLowAppId(SysDictVo sysDictVo) {
        String[] dictResult = this.addDict(sysDictVo.getDictName(), sysDictVo.getLowAppId(), sysDictVo.getTenantId());
        String id = dictResult[0];
        String code = dictResult[1];
        this.addDictItem(id, sysDictVo.getDictItemsList());
        return code;
    }

    @Override
    public void editDictByLowAppId(SysDictVo sysDictVo) {
        String id = sysDictVo.getId();
        SysDict dict = (SysDict)((SysDictMapper)this.baseMapper).selectById((Serializable)((Object)id));
        if (null == dict) {
            throw new JeecgBootException("\u5b57\u5178\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (!dict.getLowAppId().equals(sysDictVo.getLowAppId())) {
            throw new JeecgBootException("\u5b57\u5178\u6570\u636e\u4e0d\u5b58\u5728");
        }
        SysDict sysDict = new SysDict();
        sysDict.setDictName(sysDictVo.getDictName());
        sysDict.setId(id);
        ((SysDictMapper)this.baseMapper).updateById(sysDict);
        this.updateDictItem(id, sysDictVo.getDictItemsList());
        this.redisUtil.removeAll("sys:cache:dict::" + dict.getDictCode());
    }

    private String[] addDict(String dictName, String lowAppId, Integer tenantId) {
        SysDict dict = new SysDict();
        dict.setDictName(dictName);
        dict.setDictCode(RandomUtil.randomString((int)10));
        dict.setDelFlag(Integer.valueOf("0"));
        dict.setLowAppId(lowAppId);
        dict.setTenantId(tenantId);
        ((SysDictMapper)this.baseMapper).insert(dict);
        String[] dictResult = new String[]{dict.getId(), dict.getDictCode()};
        return dictResult;
    }

    private void addDictItem(String id, List<SysDictItem> dictItemList) {
        if (null != dictItemList && dictItemList.size() > 0) {
            for (SysDictItem dictItem : dictItemList) {
                SysDictItem sysDictItem = new SysDictItem();
                BeanUtils.copyProperties((Object)dictItem, (Object)sysDictItem);
                sysDictItem.setDictId(id);
                sysDictItem.setId("");
                sysDictItem.setStatus(Integer.valueOf("1"));
                this.sysDictItemMapper.insert(sysDictItem);
            }
        }
    }

    private void updateDictItem(String id, List<SysDictItem> dictItemList) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysDictItem::getDictId, (Object)id);
        this.sysDictItemMapper.delete((Wrapper)query);
        this.addDictItem(id, dictItemList);
    }
}

