/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.creator.DataSourceProperty;
import com.baomidou.dynamic.datasource.creator.druid.DruidDataSourceCreator;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.util.dynamic.db.DataSourceCachePool;
import org.jeecg.modules.system.entity.SysDataSource;
import org.jeecg.modules.system.mapper.SysDataSourceMapper;
import org.jeecg.modules.system.service.ISysDataSourceService;
import org.jeecg.modules.system.util.SecurityUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysDataSourceServiceImpl
extends ServiceImpl<SysDataSourceMapper, SysDataSource>
implements ISysDataSourceService {
    @Autowired
    private DruidDataSourceCreator dataSourceCreator;
    @Autowired
    private DataSource dataSource;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Result saveDataSource(SysDataSource sysDataSource) {
        try {
            boolean result;
            long count = this.checkDbCode(sysDataSource.getCode());
            if (count > 0L) {
                return Result.error((String)"\u6570\u636e\u6e90\u7f16\u7801\u5df2\u5b58\u5728");
            }
            String dbPassword = sysDataSource.getDbPassword();
            if (StringUtils.isNotBlank((String)dbPassword)) {
                String encrypt = SecurityUtil.jiami(dbPassword);
                sysDataSource.setDbPassword(encrypt);
            }
            if (!(result = this.save(sysDataSource))) return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Result editDataSource(SysDataSource sysDataSource) {
        try {
            Boolean result;
            SysDataSource d = (SysDataSource)this.getById((Serializable)((Object)sysDataSource.getId()));
            DataSourceCachePool.removeCache((String)d.getCode());
            String dbPassword = sysDataSource.getDbPassword();
            if (StringUtils.isNotBlank((String)dbPassword)) {
                String encrypt = SecurityUtil.jiami(dbPassword);
                sysDataSource.setDbPassword(encrypt);
            }
            if (!(result = Boolean.valueOf(this.updateById(sysDataSource))).booleanValue()) return Result.OK((String)"\u7f16\u8f91\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Result.OK((String)"\u7f16\u8f91\u6210\u529f!");
    }

    @Override
    public Result deleteDataSource(String id) {
        SysDataSource sysDataSource = (SysDataSource)this.getById((Serializable)((Object)id));
        DataSourceCachePool.removeCache((String)sysDataSource.getCode());
        this.removeById((Serializable)((Object)id));
        return Result.OK((String)"\u5220\u9664\u6210\u529f!");
    }

    private void addDynamicDataSource(SysDataSource sysDataSource, String dbPassword) {
        DataSourceProperty dataSourceProperty = new DataSourceProperty();
        dataSourceProperty.setUrl(sysDataSource.getDbUrl());
        dataSourceProperty.setPassword(dbPassword);
        dataSourceProperty.setDriverClassName(sysDataSource.getDbDriver());
        dataSourceProperty.setUsername(sysDataSource.getDbUsername());
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        DataSource dataSource = this.dataSourceCreator.createDataSource(dataSourceProperty);
        try {
            ds.addDataSource(sysDataSource.getCode(), dataSource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeDynamicDataSource(String code) {
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        ds.removeDataSource(code);
    }

    private long checkDbCode(String dbCode) {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(true, SysDataSource::getCode, (Object)dbCode);
        return this.count((Wrapper)qw);
    }
}

