/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.security;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.common.util.security.AbstractQueryBlackListHandler;
import org.springframework.stereotype.Component;

@Component(value="dictQueryBlackListHandler")
public class DictQueryBlackListHandler
extends AbstractQueryBlackListHandler {
    protected List<AbstractQueryBlackListHandler.QueryTable> getQueryTableInfo(String dictCodeString) {
        try {
            if (dictCodeString.contains("%")) {
                dictCodeString = URLDecoder.decode(dictCodeString, "UTF-8");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        dictCodeString = dictCodeString.trim();
        if (dictCodeString != null && dictCodeString.indexOf(",") > 0) {
            String[] arr = dictCodeString.split(",");
            if (arr.length != 3 && arr.length != 4) {
                return null;
            }
            String tableName = this.getTableName(arr[0]);
            AbstractQueryBlackListHandler.QueryTable table = new AbstractQueryBlackListHandler.QueryTable((AbstractQueryBlackListHandler)this, tableName, "");
            table.addField(arr[1].trim());
            String filed = arr[2].trim();
            if (oConvertUtils.isNotEmpty((Object)filed)) {
                table.addField(filed);
            }
            ArrayList<AbstractQueryBlackListHandler.QueryTable> list = new ArrayList<AbstractQueryBlackListHandler.QueryTable>();
            list.add(table);
            return list;
        }
        return null;
    }

    private String getTableName(String str) {
        String[] arr = str.split("\\s+(?i)where\\s+");
        String tableName = arr[0].trim();
        if (tableName.contains(".")) {
            tableName = tableName.substring(tableName.indexOf(".") + 1, tableName.length()).trim();
        }
        if (tableName.contains(" ")) {
            tableName = tableName.substring(0, tableName.indexOf(" ")).trim();
        }
        String reg = "\\s+|\\(|\\)|`";
        return tableName.replaceAll(reg, "");
    }
}

