/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.xkcoding.justauth.AuthRequestFactory;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.request.AuthRequest;
import me.zhyd.oauth.utils.AuthStateUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.constant.enums.MessageTypeEnum;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.util.CommonUtils;
import org.jeecg.common.util.PasswordUtil;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.base.service.BaseCommonService;
import org.jeecg.modules.system.entity.SysThirdAccount;
import org.jeecg.modules.system.entity.SysThirdAppConfig;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.model.ThirdLoginModel;
import org.jeecg.modules.system.service.ISysDictService;
import org.jeecg.modules.system.service.ISysThirdAccountService;
import org.jeecg.modules.system.service.ISysThirdAppConfigService;
import org.jeecg.modules.system.service.ISysUserService;
import org.jeecg.modules.system.service.impl.ThirdAppDingtalkServiceImpl;
import org.jeecg.modules.system.service.impl.ThirdAppWechatEnterpriseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys/thirdLogin"})
public class ThirdLoginController {
    private static final Logger log = LoggerFactory.getLogger(ThirdLoginController.class);
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ISysThirdAccountService sysThirdAccountService;
    @Autowired
    private ISysDictService sysDictService;
    @Autowired
    private BaseCommonService baseCommonService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private AuthRequestFactory factory;
    @Autowired
    private ThirdAppWechatEnterpriseServiceImpl thirdAppWechatEnterpriseService;
    @Autowired
    private ThirdAppDingtalkServiceImpl thirdAppDingtalkService;
    @Autowired
    private ISysThirdAppConfigService appConfigService;

    @RequestMapping(value={"/render/{source}"})
    public void render(@PathVariable(value="source") String source, HttpServletResponse response) throws IOException {
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165render\uff1a" + source);
        AuthRequest authRequest = this.factory.get(source);
        String authorizeUrl = authRequest.authorize(AuthStateUtils.createState());
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8ba4\u8bc1\u5730\u5740\uff1a" + authorizeUrl);
        response.sendRedirect(authorizeUrl);
    }

    @RequestMapping(value={"/{source}/callback"})
    public String loginThird(@PathVariable(value="source") String source, AuthCallback callback, ModelMap modelMap) {
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\uff1a" + source + " params\uff1a" + JSONObject.toJSONString((Object)callback));
        AuthRequest authRequest = this.factory.get(source);
        AuthResponse response = authRequest.login(callback);
        log.info(JSONObject.toJSONString((Object)response));
        Result result = new Result();
        if (response.getCode() == 2000) {
            JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()));
            String username = data.getString("username");
            String avatar = data.getString("avatar");
            String uuid = data.getString("uuid");
            ThirdLoginModel tlm = new ThirdLoginModel(source, uuid, username, avatar);
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(SysThirdAccount::getThirdType, (Object)source);
            query.eq(SysThirdAccount::getTenantId, (Object)CommonConstant.TENANT_ID_DEFAULT_VALUE);
            query.and(q -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)q.eq(SysThirdAccount::getThirdUserUuid, (Object)uuid)).or()).eq(SysThirdAccount::getThirdUserId, (Object)uuid);
            });
            List thridList = this.sysThirdAccountService.list((Wrapper)query);
            SysThirdAccount user = null;
            user = thridList == null || thridList.size() == 0 ? this.sysThirdAccountService.saveThirdUser(tlm, CommonConstant.TENANT_ID_DEFAULT_VALUE) : (SysThirdAccount)thridList.get(0);
            if (oConvertUtils.isNotEmpty((Object)user.getSysUserId())) {
                String sysUserId = user.getSysUserId();
                SysUser sysUser = (SysUser)this.sysUserService.getById((Serializable)((Object)sysUserId));
                String token = this.saveToken(sysUser);
                modelMap.addAttribute("token", (Object)token);
            } else {
                modelMap.addAttribute("token", (Object)("\u7ed1\u5b9a\u624b\u673a\u53f7," + uuid));
            }
        } else {
            modelMap.addAttribute("token", (Object)"\u767b\u5f55\u5931\u8d25");
        }
        result.setSuccess(false);
        result.setMessage("\u7b2c\u4e09\u65b9\u767b\u5f55\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        return "thirdLogin";
    }

    @PostMapping(value={"/user/create"})
    @ResponseBody
    public Result<String> thirdUserCreate(@RequestBody ThirdLoginModel model) {
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u521b\u5efa\u65b0\u8d26\u53f7\uff1a");
        Result res = new Result();
        Object operateCode = this.redisUtil.get("third_login_code");
        if (operateCode == null || !operateCode.toString().equals(model.getOperateCode())) {
            res.setSuccess(false);
            res.setMessage("\u6821\u9a8c\u5931\u8d25");
            return res;
        }
        SysThirdAccount user = this.sysThirdAccountService.saveThirdUser(model, CommonConstant.TENANT_ID_DEFAULT_VALUE);
        if (oConvertUtils.isNotEmpty((Object)user.getSysUserId())) {
            String sysUserId = user.getSysUserId();
            SysUser sysUser = (SysUser)this.sysUserService.getById((Serializable)((Object)sysUserId));
            String token = this.saveToken(sysUser);
            res.setResult((Object)token);
            res.setSuccess(true);
        }
        return res;
    }

    @PostMapping(value={"/user/checkPassword"})
    @ResponseBody
    public Result<String> checkPassword(@RequestBody JSONObject json) {
        Result result = new Result();
        Object operateCode = this.redisUtil.get("third_login_code");
        if (operateCode == null || !operateCode.toString().equals(json.getString("operateCode"))) {
            result.setSuccess(false);
            result.setMessage("\u6821\u9a8c\u5931\u8d25");
            return result;
        }
        String username = json.getString("uuid");
        SysUser user = this.sysUserService.getUserByName(username);
        if (user == null) {
            result.setMessage("\u7528\u6237\u672a\u627e\u5230");
            result.setSuccess(false);
            return result;
        }
        String password = json.getString("password");
        String salt = user.getSalt();
        String passwordEncode = PasswordUtil.encrypt((String)user.getUsername(), (String)password, (String)salt);
        if (!passwordEncode.equals(user.getPassword())) {
            result.setMessage("\u5bc6\u7801\u4e0d\u6b63\u786e");
            result.setSuccess(false);
            return result;
        }
        this.sysUserService.updateById(user);
        result.setSuccess(true);
        String token = this.saveToken(user);
        result.setResult((Object)token);
        return result;
    }

    private String saveToken(SysUser user) {
        String token = JwtUtil.sign((String)user.getUsername(), (String)user.getPassword());
        this.redisUtil.set("prefix_user_token:" + token, (Object)token);
        this.redisUtil.expire("prefix_user_token:" + token, 604800L);
        return token;
    }

    @RequestMapping(value={"/getLoginUser/{token}/{thirdType}/{tenantId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<JSONObject> getThirdLoginUser(@PathVariable(value="token") String token, @PathVariable(value="thirdType") String thirdType, @PathVariable(value="tenantId") String tenantId) throws Exception {
        Result result = new Result();
        String username = JwtUtil.getUsername((String)token);
        SysUser sysUser = this.sysUserService.getUserByName(username);
        result = this.sysUserService.checkUserIsEffective(sysUser);
        if (!result.isSuccess()) {
            return result;
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysThirdAccount::getSysUserId, (Object)sysUser.getId());
        query.eq(SysThirdAccount::getThirdType, (Object)thirdType);
        query.eq(SysThirdAccount::getTenantId, (Object)oConvertUtils.getInt((String)tenantId, (Integer)CommonConstant.TENANT_ID_DEFAULT_VALUE));
        List accountList = this.sysThirdAccountService.list((Wrapper)query);
        SysThirdAccount account = new SysThirdAccount();
        if (CollectionUtil.isNotEmpty((Collection)accountList)) {
            account = (SysThirdAccount)accountList.get(0);
        }
        if (oConvertUtils.isEmpty((Object)sysUser.getRealname())) {
            sysUser.setRealname(account.getRealname());
        }
        if (oConvertUtils.isEmpty((Object)sysUser.getAvatar())) {
            sysUser.setAvatar(account.getAvatar());
        }
        JSONObject obj = new JSONObject();
        obj.put("userInfo", (Object)sysUser);
        obj.put("sysAllDictItems", this.sysDictService.queryAllDictItems());
        obj.put("token", (Object)token);
        result.setResult((Object)obj);
        result.setSuccess(true);
        result.setCode(Integer.valueOf(200));
        this.baseCommonService.addLog("\u7528\u6237\u540d: " + username + ",\u767b\u5f55\u6210\u529f[\u7b2c\u4e09\u65b9\u7528\u6237]\uff01", Integer.valueOf(1), null);
        return result;
    }

    @ApiOperation(value="\u624b\u673a\u53f7\u767b\u5f55\u63a5\u53e3")
    @PostMapping(value={"/bindingThirdPhone"})
    @ResponseBody
    public Result<String> bindingThirdPhone(@RequestBody JSONObject jsonObject) {
        Result result = new Result();
        String phone = jsonObject.getString("mobile");
        String thirdUserUuid = jsonObject.getString("thirdUserUuid");
        String captcha = jsonObject.getString("captcha");
        String redisKey = "phone_msg" + phone;
        Object captchaCache = this.redisUtil.get(redisKey);
        if (oConvertUtils.isEmpty((Object)captcha) || !captcha.equals(captchaCache)) {
            result.setMessage("\u9a8c\u8bc1\u7801\u9519\u8bef");
            result.setSuccess(false);
            return result;
        }
        SysUser sysUser = this.sysUserService.getUserByPhone(phone);
        if (sysUser != null) {
            this.sysThirdAccountService.updateThirdUserId(sysUser, thirdUserUuid);
        } else {
            sysUser = this.sysThirdAccountService.createUser(phone, thirdUserUuid, CommonConstant.TENANT_ID_DEFAULT_VALUE);
        }
        String token = this.saveToken(sysUser);
        result.setSuccess(true);
        result.setResult((Object)token);
        return result;
    }

    @ResponseBody
    @GetMapping(value={"/oauth2/{source}/login"})
    public String oauth2LoginCallback(@PathVariable(value="source") String source, @RequestParam(value="state") String state, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="tenantId", required=false, defaultValue="0") String tenantId) throws Exception {
        String url;
        if (oConvertUtils.isEmpty((Object)tenantId)) {
            return "\u79df\u6237\u7f16\u7801\u672a\u914d\u7f6e";
        }
        if ("WECHAT_ENTERPRISE".equalsIgnoreCase(source)) {
            SysThirdAppConfig config = this.appConfigService.getThirdConfigByThirdType(Integer.valueOf(tenantId), MessageTypeEnum.QYWX.getType());
            if (null == config) {
                return "\u8fd8\u672a\u914d\u7f6e\u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\uff0c\u8bf7\u914d\u7f6e\u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528";
            }
            StringBuilder builder = new StringBuilder();
            builder.append("https://open.weixin.qq.com/connect/oauth2/authorize");
            builder.append("?appid=").append(config.getClientId());
            String redirectUri = CommonUtils.getBaseUrl((HttpServletRequest)request) + "/sys/thirdLogin/oauth2/wechat_enterprise/callback?tenantId=" + tenantId;
            builder.append("&redirect_uri=").append(URLEncoder.encode(redirectUri, "UTF-8"));
            builder.append("&response_type=code");
            builder.append("&scope=snsapi_base");
            builder.append("&state=").append(state);
            builder.append("#wechat_redirect");
            url = builder.toString();
        } else if ("DINGTALK".equalsIgnoreCase(source)) {
            SysThirdAppConfig appConfig = this.appConfigService.getThirdConfigByThirdType(Integer.valueOf(tenantId), MessageTypeEnum.DD.getType());
            if (null == appConfig) {
                return "\u8fd8\u672a\u914d\u7f6e\u9489\u9489\u5e94\u7528\uff0c\u8bf7\u914d\u7f6e\u9489\u9489\u5e94\u7528";
            }
            StringBuilder builder = new StringBuilder();
            builder.append("https://login.dingtalk.com/oauth2/auth");
            String redirectUri = CommonUtils.getBaseUrl((HttpServletRequest)request) + "/sys/thirdLogin/oauth2/dingtalk/callback?tenantId=" + tenantId;
            builder.append("?redirect_uri=").append(URLEncoder.encode(redirectUri, "UTF-8"));
            builder.append("&response_type=code");
            builder.append("&client_id=").append(appConfig.getClientId());
            builder.append("&scope=openid");
            builder.append("&state=").append(state);
            builder.append("&prompt=").append("consent");
            url = builder.toString();
        } else {
            return "\u4e0d\u652f\u6301\u7684source";
        }
        log.info("oauth2 login url:" + url);
        response.sendRedirect(url);
        return "login\u2026";
    }

    @ResponseBody
    @GetMapping(value={"/oauth2/{source}/callback"})
    public String oauth2LoginCallback(@PathVariable(value="source") String source, @RequestParam(value="code", required=false) String code, @RequestParam(value="authCode", required=false) String authCode, @RequestParam(value="state") String state, @RequestParam(name="tenantId", defaultValue="0") String tenantId, HttpServletResponse response) {
        SysUser loginUser;
        if ("WECHAT_ENTERPRISE".equalsIgnoreCase(source)) {
            log.info("\u3010\u4f01\u4e1a\u5fae\u4fe1\u3011OAuth2\u767b\u5f55\u8fdb\u5165callback\uff1acode=" + code + ", state=" + state);
            loginUser = this.thirdAppWechatEnterpriseService.oauth2Login(code, Integer.valueOf(tenantId));
            if (loginUser == null) {
                return "\u767b\u5f55\u5931\u8d25";
            }
        } else if ("DINGTALK".equalsIgnoreCase(source)) {
            log.info("\u3010\u9489\u9489\u3011OAuth2\u767b\u5f55\u8fdb\u5165callback\uff1aauthCode=" + authCode + ", state=" + state);
            loginUser = this.thirdAppDingtalkService.oauth2Login(authCode, Integer.valueOf(tenantId));
            if (loginUser == null) {
                return "\u767b\u5f55\u5931\u8d25";
            }
        } else {
            return "\u4e0d\u652f\u6301\u7684source";
        }
        try {
            String redirect = "";
            if (state.indexOf("?") > 0) {
                String[] arr = state.split("\\?");
                state = arr[0];
                if (arr.length > 1) {
                    redirect = arr[1];
                }
            }
            String token = this.saveToken(loginUser);
            state = state + "/oauth2-app/login?oauth2LoginToken=" + URLEncoder.encode(token, "UTF-8") + "&tenantId=" + URLEncoder.encode(tenantId, "UTF-8");
            state = state + "&thirdType=" + source;
            if (redirect != null && redirect.length() > 0) {
                state = state + "&" + redirect;
            }
            log.info("OAuth2\u767b\u5f55\u91cd\u5b9a\u5411\u5730\u5740: " + state);
            try {
                response.sendRedirect(state);
                return "ok";
            }
            catch (IOException e) {
                e.printStackTrace();
                return "\u91cd\u5b9a\u5411\u5931\u8d25";
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "\u89e3\u7801\u5931\u8d25";
        }
    }

    @ResponseBody
    @PutMapping(value={"/registerBindThirdAccount"})
    public Result<String> registerBindThirdAccount(@RequestBody JSONObject jsonObject, SysUser user) {
        SysUser sysUser3;
        String password;
        String phone = jsonObject.getString("phone");
        String smscode = jsonObject.getString("smscode");
        String redisKey = "phone_msg" + phone;
        Object code = this.redisUtil.get(redisKey);
        String thirdUserUuid = jsonObject.getString("thirdUserUuid");
        String username = jsonObject.getString("username");
        if (oConvertUtils.isEmpty((Object)username)) {
            username = phone;
        }
        if (oConvertUtils.isEmpty((Object)(password = jsonObject.getString("password")))) {
            password = RandomUtil.randomString((int)8);
        }
        String email = jsonObject.getString("email");
        SysUser sysUser1 = this.sysUserService.getUserByName(username);
        if (sysUser1 != null) {
            return Result.error((String)"\u7528\u6237\u540d\u5df2\u6ce8\u518c");
        }
        SysUser sysUser2 = this.sysUserService.getUserByPhone(phone);
        if (sysUser2 != null) {
            return Result.error((String)"\u8be5\u624b\u673a\u53f7\u5df2\u6ce8\u518c");
        }
        if (oConvertUtils.isNotEmpty((Object)email) && (sysUser3 = this.sysUserService.getUserByEmail(email)) != null) {
            return Result.error((String)"\u90ae\u7bb1\u5df2\u88ab\u6ce8\u518c");
        }
        if (null == code) {
            return Result.error((String)"\u624b\u673a\u9a8c\u8bc1\u7801\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6");
        }
        if (!smscode.equals(code.toString())) {
            return Result.error((String)"\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        String realname = jsonObject.getString("realname");
        if (oConvertUtils.isEmpty((Object)realname)) {
            realname = username;
        }
        try {
            user.setCreateTime(new Date());
            String salt = oConvertUtils.randomGen((int)8);
            String passwordEncode = PasswordUtil.encrypt((String)username, (String)password, (String)salt);
            user.setSalt(salt);
            user.setUsername(username);
            user.setRealname(realname);
            user.setPassword(passwordEncode);
            user.setEmail(email);
            user.setPhone(phone);
            user.setStatus(CommonConstant.USER_UNFREEZE);
            user.setDelFlag(CommonConstant.DEL_FLAG_0);
            user.setActivitiSync(CommonConstant.ACT_SYNC_1);
            this.sysUserService.addUserWithRole(user, "");
            this.sysThirdAccountService.updateThirdUserId(user, thirdUserUuid);
            String token = this.saveToken(user);
            return Result.ok((String)token);
        }
        catch (Exception e) {
            return Result.error((String)"\u6ce8\u518c\u5931\u8d25");
        }
    }
}

