/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.RandomUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.PermissionData;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.PasswordUtil;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.modules.base.service.BaseCommonService;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysTenant;
import org.jeecg.modules.system.entity.SysTenantPack;
import org.jeecg.modules.system.entity.SysTenantPackUser;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.entity.SysUserTenant;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.service.ISysTenantPackService;
import org.jeecg.modules.system.service.ISysTenantService;
import org.jeecg.modules.system.service.ISysUserService;
import org.jeecg.modules.system.service.ISysUserTenantService;
import org.jeecg.modules.system.vo.SysUserTenantVo;
import org.jeecg.modules.system.vo.tenant.TenantDepartAuthInfo;
import org.jeecg.modules.system.vo.tenant.TenantPackModel;
import org.jeecg.modules.system.vo.tenant.TenantPackUser;
import org.jeecg.modules.system.vo.tenant.TenantPackUserCount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/tenant"})
public class SysTenantController {
    private static final Logger log = LoggerFactory.getLogger(SysTenantController.class);
    @Autowired
    private ISysTenantService sysTenantService;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ISysUserTenantService relationService;
    @Autowired
    private ISysTenantPackService sysTenantPackService;
    @Autowired
    private BaseCommonService baseCommonService;
    @Autowired
    private ISysDepartService sysDepartService;

    @RequiresPermissions(value={"system:tenant:list"})
    @PermissionData(pageComponent="system/TenantList")
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<IPage<SysTenant>> queryPageList(SysTenant sysTenant, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        Date beginDate = null;
        Date endDate = null;
        if (oConvertUtils.isNotEmpty((Object)sysTenant)) {
            beginDate = sysTenant.getBeginDate();
            endDate = sysTenant.getEndDate();
            sysTenant.setBeginDate(null);
            sysTenant.setEndDate(null);
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysTenant, (Map)req.getParameterMap());
        if (oConvertUtils.isNotEmpty((Object)sysTenant)) {
            queryWrapper.ge(oConvertUtils.isNotEmpty((Object)beginDate), (Object)"begin_date", (Object)beginDate);
            queryWrapper.le(oConvertUtils.isNotEmpty((Object)endDate), (Object)"end_date", (Object)endDate);
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysTenantService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @GetMapping(value={"/recycleBinPageList"})
    @RequiresPermissions(value={"system:tenant:recycleBinPageList"})
    public Result<IPage<SysTenant>> recycleBinPageList(SysTenant sysTenant, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<SysTenant> pageList = this.sysTenantService.getRecycleBinPageList((Page<SysTenant>)page, sysTenant);
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @RequiresPermissions(value={"system:tenant:add"})
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public Result<SysTenant> add(@RequestBody SysTenant sysTenant) {
        Result result = new Result();
        if (this.sysTenantService.getById(sysTenant.getId()) != null) {
            return result.error500("\u8be5\u7f16\u53f7\u5df2\u5b58\u5728!");
        }
        try {
            this.sysTenantService.saveTenant(sysTenant);
            this.sysTenantPackService.addTenantDefaultPack(sysTenant.getId());
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequiresPermissions(value={"system:tenant:edit"})
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<SysTenant> edit(@RequestBody SysTenant tenant) {
        boolean ok;
        Result result = new Result();
        SysTenant sysTenant = (SysTenant)this.sysTenantService.getById(tenant.getId());
        if (sysTenant == null) {
            return result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        }
        if (oConvertUtils.isEmpty((Object)sysTenant.getHouseNumber())) {
            tenant.setHouseNumber(RandomUtil.randomStringUpper((int)6));
        }
        if (ok = this.sysTenantService.updateById(tenant)) {
            result.success("\u4fee\u6539\u6210\u529f!");
        }
        return result;
    }

    @RequiresPermissions(value={"system:tenant:delete"})
    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE, RequestMethod.POST})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            SysTenant sysTenant = (SysTenant)this.sysTenantService.getById((Serializable)((Object)id));
            String username = "admin";
            String createdBy = sysUser.getUsername();
            if (!sysTenant.getCreateBy().equals(createdBy) && !username.equals(createdBy)) {
                this.baseCommonService.addLog("\u672a\u7ecf\u6388\u6743\uff0c\u4e0d\u80fd\u5220\u9664\u975e\u81ea\u5df1\u521b\u5efa\u7684\u79df\u6237\uff0c\u79df\u6237ID\uff1a" + id + "\uff0c\u64cd\u4f5c\u4eba\uff1a" + sysUser.getUsername(), Integer.valueOf(2), Integer.valueOf(3));
                return Result.error((String)"\u5220\u9664\u79df\u6237\u5931\u8d25,\u5f53\u524d\u64cd\u4f5c\u4eba\u4e0d\u662f\u79df\u6237\u7684\u521b\u5efa\u4eba\uff01");
            }
        }
        this.sysTenantService.removeTenantById(id);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @RequiresPermissions(value={"system:tenant:deleteBatch"})
    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.DELETE})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result result = new Result();
        if (oConvertUtils.isEmpty((Object)ids)) {
            result.error500("\u672a\u9009\u4e2d\u79df\u6237\uff01");
        } else {
            String[] ls = ids.split(",");
            ArrayList<Integer> idList = new ArrayList<Integer>();
            for (String id : ls) {
                if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
                    LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
                    SysTenant sysTenant = (SysTenant)this.sysTenantService.getById((Serializable)((Object)id));
                    String username = "admin";
                    String createdBy = sysUser.getUsername();
                    if (!sysTenant.getCreateBy().equals(createdBy) && !username.equals(createdBy)) {
                        this.baseCommonService.addLog("\u672a\u7ecf\u6388\u6743\uff0c\u4e0d\u80fd\u5220\u9664\u975e\u81ea\u5df1\u521b\u5efa\u7684\u79df\u6237\uff0c\u79df\u6237ID\uff1a" + id + "\uff0c\u64cd\u4f5c\u4eba\uff1a" + sysUser.getUsername(), Integer.valueOf(2), Integer.valueOf(3));
                        return Result.error((String)"\u5220\u9664\u79df\u6237\u5931\u8d25,\u5f53\u524d\u64cd\u4f5c\u4eba\u4e0d\u662f\u79df\u6237\u7684\u521b\u5efa\u4eba\uff01");
                    }
                }
                idList.add(Integer.parseInt(id));
            }
            this.sysTenantService.removeByIds(idList);
            result.success("\u5220\u9664\u6210\u529f\uff01");
        }
        return result;
    }

    @RequestMapping(value={"/queryById"}, method={RequestMethod.GET})
    public Result<SysTenant> queryById(@RequestParam(name="id", required=true) String id) {
        Integer loginSessionTenant;
        Result result = new Result();
        if (oConvertUtils.isEmpty((Object)id)) {
            result.error500("\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue() && !"admin".equals(sysUser.getUsername()) && (loginSessionTenant = Integer.valueOf(oConvertUtils.getInt((String)TenantContext.getTenant()))) != null && !loginSessionTenant.equals(Integer.valueOf(id))) {
            result.error500("\u65e0\u6743\u9650\u8bbf\u95ee\u4ed6\u4eba\u79df\u6237\uff01");
            return result;
        }
        SysTenant sysTenant = (SysTenant)this.sysTenantService.getById((Serializable)((Object)id));
        if (sysTenant == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult((Object)sysTenant);
            result.setSuccess(true);
        }
        return result;
    }

    @RequiresPermissions(value={"system:tenant:queryList"})
    @RequestMapping(value={"/queryList"}, method={RequestMethod.GET})
    public Result<List<SysTenant>> queryList(@RequestParam(name="ids", required=false) String ids) {
        Result result = new Result();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysTenant::getStatus, (Object)1);
        if (oConvertUtils.isNotEmpty((Object)ids)) {
            query.in(SysTenant::getId, (Object[])ids.split(","));
        }
        List ls = this.sysTenantService.list((Wrapper)query);
        result.setSuccess(true);
        result.setResult((Object)ls);
        return result;
    }

    @GetMapping(value={"/packList"})
    @RequiresPermissions(value={"system:tenant:packList"})
    public Result<IPage<SysTenantPack>> queryPackPageList(SysTenantPack sysTenantPack, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysTenantPack, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysTenantPackService.page((IPage)page, (Wrapper)queryWrapper);
        List records = pageList.getRecords();
        if (null != records && records.size() > 0) {
            pageList.setRecords(this.sysTenantPackService.setPermissions(records));
        }
        return Result.OK((Object)pageList);
    }

    @PostMapping(value={"/addPackPermission"})
    @RequiresPermissions(value={"system:tenant:add:pack"})
    public Result<String> addPackPermission(@RequestBody SysTenantPack sysTenantPack) {
        this.sysTenantPackService.addPackPermission(sysTenantPack);
        return Result.ok((String)"\u521b\u5efa\u79df\u6237\u4ea7\u54c1\u5305\u6210\u529f");
    }

    @PutMapping(value={"/editPackPermission"})
    @RequiresPermissions(value={"system:tenant:edit:pack"})
    public Result<String> editPackPermission(@RequestBody SysTenantPack sysTenantPack) {
        this.sysTenantPackService.editPackPermission(sysTenantPack);
        return Result.ok((String)"\u4fee\u6539\u79df\u6237\u4ea7\u54c1\u5305\u6210\u529f");
    }

    @DeleteMapping(value={"/deleteTenantPack"})
    @RequiresPermissions(value={"system:tenant:delete:pack"})
    public Result<String> deleteTenantPack(@RequestParam(value="ids") String ids) {
        this.sysTenantPackService.deleteTenantPack(ids);
        return Result.ok((String)"\u5220\u9664\u79df\u6237\u4ea7\u54c1\u5305\u6210\u529f");
    }

    @RequestMapping(value={"/getCurrentUserTenant"}, method={RequestMethod.GET})
    public Result<Map<String, Object>> getCurrentUserTenant() {
        Result result = new Result();
        try {
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            List<Integer> tenantIdList = this.relationService.getTenantIdsByUserId(sysUser.getId());
            HashMap<String, List<SysTenant>> map = new HashMap<String, List<SysTenant>>(5);
            if (null != tenantIdList && tenantIdList.size() > 0) {
                List<SysTenant> tenantList = this.sysTenantService.queryEffectiveTenant(tenantIdList);
                map.put("list", tenantList);
            }
            result.setSuccess(true);
            result.setResult(map);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u67e5\u8be2\u5931\u8d25\uff01");
        }
        return result;
    }

    @PutMapping(value={"/invitationUserJoin"})
    @RequiresPermissions(value={"system:tenant:invitation:user"})
    public Result<String> invitationUserJoin(@RequestParam(value="ids") String ids, @RequestParam(value="phone") String phone) {
        this.sysTenantService.invitationUserJoin(ids, phone);
        return Result.ok((String)"\u9080\u8bf7\u7528\u6237\u6210\u529f");
    }

    @RequestMapping(value={"/getTenantUserList"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"system:tenant:user:list"})
    public Result<IPage<SysUser>> getTenantUserList(SysUser user, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="userTenantId") String userTenantId, HttpServletRequest req) {
        Result result = new Result();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        Page<SysUser> pageList = this.relationService.getPageUserList((Page<SysUser>)page, Integer.valueOf(userTenantId), user);
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @PutMapping(value={"/leaveTenant"})
    @RequiresPermissions(value={"system:tenant:leave"})
    public Result<String> leaveTenant(@RequestParam(value="userIds") String userIds, @RequestParam(value="tenantId") String tenantId) {
        Integer loginSessionTenant;
        Result result = new Result();
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue() && !"admin".equals(sysUser.getUsername()) && (loginSessionTenant = Integer.valueOf(oConvertUtils.getInt((String)TenantContext.getTenant()))) != null && !loginSessionTenant.equals(Integer.valueOf(tenantId))) {
            result.error500("\u65e0\u6743\u9650\u8bbf\u95ee\u4ed6\u4eba\u79df\u6237\uff01");
            return result;
        }
        this.sysTenantService.leaveTenant(userIds, tenantId);
        return Result.ok((String)"\u8bf7\u79bb\u6210\u529f");
    }

    @RequestMapping(value={"/editOwnTenant"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<SysTenant> editOwnTenant(@RequestBody SysTenant tenant, HttpServletRequest req) {
        boolean ok;
        Result result = new Result();
        String tenantId = TokenUtils.getTenantIdByRequest((HttpServletRequest)req);
        if (!tenantId.equals(tenant.getId().toString())) {
            return result.error500("\u65e0\u6743\u4fee\u6539\u4ed6\u4eba\u79df\u6237\uff01");
        }
        SysTenant sysTenant = (SysTenant)this.sysTenantService.getById(tenant.getId());
        if (sysTenant == null) {
            return result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        }
        if (oConvertUtils.isEmpty((Object)sysTenant.getHouseNumber())) {
            tenant.setHouseNumber(RandomUtil.randomStringUpper((int)6));
        }
        if (ok = this.sysTenantService.updateById(tenant)) {
            result.success("\u4fee\u6539\u6210\u529f!");
        }
        return result;
    }

    @PostMapping(value={"/saveTenantJoinUser"})
    public Result<Integer> saveTenantJoinUser(@RequestBody SysTenant sysTenant) {
        Result result = new Result();
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        Integer tenantId = this.sysTenantService.saveTenantJoinUser(sysTenant, sysUser.getId());
        result.setSuccess(true);
        result.setMessage("\u521b\u5efa\u6210\u529f");
        result.setResult((Object)tenantId);
        return result;
    }

    @PostMapping(value={"/joinTenantByHouseNumber"})
    public Result<Integer> joinTenantByHouseNumber(@RequestBody SysTenant sysTenant) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        Integer tenantId = this.sysTenantService.joinTenantByHouseNumber(sysTenant, sysUser.getId());
        Result result = new Result();
        if (tenantId != 0) {
            result.setMessage("\u7533\u8bf7\u52a0\u5165\u7ec4\u7ec7\u6210\u529f");
            result.setSuccess(true);
            result.setResult((Object)tenantId);
            return result;
        }
        result.setMessage("\u8be5\u95e8\u724c\u53f7\u4e0d\u5b58\u5728");
        result.setSuccess(false);
        return result;
    }

    @GetMapping(value={"/getUserTenantPageList"})
    public Result<IPage<SysUserTenantVo>> getUserTenantPageList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="userTenantStatus") String userTenantStatus, @RequestParam(name="type", required=false) String type, SysUser user, HttpServletRequest req) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String tenantId = oConvertUtils.getString((String)TenantContext.getTenant(), (String)"0");
        IPage<SysUserTenantVo> list = this.relationService.getUserTenantPageList((Page<SysUserTenantVo>)page, Arrays.asList(userTenantStatus.split(",")), user, Integer.valueOf(tenantId));
        return Result.ok(list);
    }

    @GetMapping(value={"/getTenantListByUserId"})
    public Result<List<SysUserTenantVo>> getTenantListByUserId(@RequestParam(name="userTenantStatus", required=false) String userTenantStatus) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        List<String> list = null;
        if (oConvertUtils.isNotEmpty((Object)userTenantStatus)) {
            list = Arrays.asList(userTenantStatus.split(","));
        }
        List<SysUserTenantVo> sysTenant = this.relationService.getTenantListByUserId(sysUser.getId(), list);
        return Result.ok(sysTenant);
    }

    @PutMapping(value={"/updateUserTenantStatus"})
    public Result<String> updateUserTenantStatus(@RequestBody SysUserTenant userTenant) {
        String tenantId = TenantContext.getTenant();
        if (oConvertUtils.isEmpty((Object)tenantId)) {
            return Result.error((String)"\u672a\u627e\u5230\u5f53\u524d\u79df\u6237\u4fe1\u606f");
        }
        this.relationService.updateUserTenantStatus(userTenant.getUserId(), tenantId, userTenant.getStatus());
        return Result.ok((String)"\u66f4\u65b0\u7528\u6237\u79df\u6237\u72b6\u6001\u6210\u529f");
    }

    @PutMapping(value={"/cancelTenant"})
    public Result<String> cancelTenant(@RequestBody SysTenant sysTenant, HttpServletRequest request) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        SysTenant tenant = (SysTenant)this.sysTenantService.getById(sysTenant.getId());
        if (null == tenant) {
            return Result.error((String)"\u672a\u627e\u5230\u5f53\u524d\u79df\u6237\u4fe1\u606f");
        }
        if (!sysUser.getUsername().equals(tenant.getCreateBy())) {
            return Result.error((String)"\u65e0\u6743\u9650\uff0c\u53ea\u80fd\u6ce8\u9500\u81ea\u5df1\u521b\u5efa\u7684\u79df\u6237\uff01");
        }
        SysUser userById = (SysUser)this.sysUserService.getById((Serializable)((Object)sysUser.getId()));
        String loginPassword = request.getParameter("loginPassword");
        String passwordEncode = PasswordUtil.encrypt((String)sysUser.getUsername(), (String)loginPassword, (String)userById.getSalt());
        if (!passwordEncode.equals(userById.getPassword())) {
            return Result.error((String)"\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        this.sysTenantService.removeById(sysTenant.getId());
        return Result.ok((String)"\u6ce8\u9500\u6210\u529f");
    }

    @GetMapping(value={"/getTenantStatusCount"})
    public Result<Long> getTenantStatusCount(@RequestParam(value="status", defaultValue="1") String status, HttpServletRequest req) {
        String tenantId = TokenUtils.getTenantIdByRequest((HttpServletRequest)req);
        if (null == tenantId) {
            return Result.error((String)"\u672a\u627e\u5230\u5f53\u524d\u79df\u6237\u4fe1\u606f");
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysUserTenant::getTenantId, (Object)tenantId);
        query.eq(SysUserTenant::getStatus, (Object)status);
        long count = this.relationService.count((Wrapper)query);
        return Result.ok((Object)count);
    }

    @PutMapping(value={"/cancelApplyTenant"})
    public Result<String> cancelApplyTenant(@RequestParam(value="tenantId") String tenantId) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        this.sysTenantService.leaveTenant(sysUser.getId(), tenantId);
        return Result.ok((String)"\u53d6\u6d88\u7533\u8bf7\u6210\u529f");
    }

    @DeleteMapping(value={"/deleteLogicDeleted"})
    @RequiresPermissions(value={"system:tenant:deleteTenantLogic"})
    public Result<String> deleteTenantLogic(@RequestParam(value="ids") String ids) {
        this.sysTenantService.deleteTenantLogic(ids);
        return Result.ok((String)"\u5f7b\u5e95\u5220\u9664\u6210\u529f");
    }

    @PutMapping(value={"/revertTenantLogic"})
    @RequiresPermissions(value={"system:tenant:revertTenantLogic"})
    public Result<String> revertTenantLogic(@RequestParam(value="ids") String ids) {
        this.sysTenantService.revertTenantLogic(ids);
        return Result.ok((String)"\u8fd8\u539f\u6210\u529f");
    }

    @DeleteMapping(value={"/exitUserTenant"})
    public Result<String> exitUserTenant(@RequestBody SysTenant sysTenant, HttpServletRequest request) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        Integer count = this.relationService.userTenantIzExist(sysUser.getId(), sysTenant.getId());
        if (count == 0) {
            return Result.error((String)"\u6b64\u79df\u6237\u4e0b\u6ca1\u6709\u5f53\u524d\u7528\u6237");
        }
        String loginPassword = request.getParameter("loginPassword");
        SysUser userById = (SysUser)this.sysUserService.getById((Serializable)((Object)sysUser.getId()));
        String passwordEncode = PasswordUtil.encrypt((String)sysUser.getUsername(), (String)loginPassword, (String)userById.getSalt());
        if (!passwordEncode.equals(userById.getPassword())) {
            return Result.error((String)"\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        this.sysTenantService.exitUserTenant(sysUser.getId(), sysUser.getUsername(), String.valueOf(sysTenant.getId()));
        return Result.ok((String)"\u9000\u51fa\u79df\u6237\u6210\u529f");
    }

    @PostMapping(value={"/changeOwenUserTenant"})
    public Result<String> changeOwenUserTenant(@RequestParam(value="userId") String userId, @RequestParam(value="tenantId") String tenantId) {
        this.sysTenantService.changeOwenUserTenant(userId, tenantId);
        return Result.ok((String)"\u9000\u51fa\u79df\u6237\u6210\u529f");
    }

    @PostMapping(value={"/invitationUser"})
    public Result<String> invitationUser(@RequestParam(name="phone") String phone, @RequestParam(name="departId", defaultValue="") String departId) {
        return this.sysTenantService.invitationUser(phone, departId);
    }

    @GetMapping(value={"/loadAdminPackCount"})
    public Result<List<TenantPackUserCount>> loadAdminPackCount(@RequestParam(value="tenantId") Integer tenantId) {
        List<TenantPackUserCount> list = this.sysTenantService.queryTenantPackUserCount(tenantId);
        return Result.ok(list);
    }

    @GetMapping(value={"/getTenantPackInfo"})
    public Result<TenantPackModel> getTenantPackInfo(TenantPackModel packModel) {
        TenantPackModel tenantPackModel = this.sysTenantService.queryTenantPack(packModel);
        return Result.ok((Object)tenantPackModel);
    }

    @PostMapping(value={"/addTenantPackUser"})
    public Result<?> addTenantPackUser(@RequestBody SysTenantPackUser sysTenantPackUser) {
        this.sysTenantService.addBatchTenantPackUser(sysTenantPackUser);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PutMapping(value={"/deleteTenantPackUser"})
    public Result<?> deleteTenantPackUser(@RequestBody SysTenantPackUser sysTenantPackUser) {
        this.sysTenantService.deleteTenantPackUser(sysTenantPackUser);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PutMapping(value={"/updateApplyStatus"})
    public Result<?> updateApplyStatus(@RequestBody SysTenant sysTenant) {
        SysTenant entity = (SysTenant)this.sysTenantService.getById(sysTenant.getId());
        if (entity == null) {
            return Result.error((String)"\u79df\u6237\u4e0d\u5b58\u5728!");
        }
        entity.setApplyStatus(sysTenant.getApplyStatus());
        this.sysTenantService.updateById(entity);
        return Result.ok((String)"");
    }

    @GetMapping(value={"/getTenantPackApplyUsers"})
    public Result<?> getTenantPackApplyUsers(@RequestParam(value="tenantId") Integer tenantId) {
        List<TenantPackUser> list = this.sysTenantService.getTenantPackApplyUsers(tenantId);
        return Result.ok(list);
    }

    @PostMapping(value={"/doApplyTenantPackUser"})
    public Result<?> doApplyTenantPackUser(@RequestBody SysTenantPackUser sysTenantPackUser) {
        this.sysTenantService.doApplyTenantPackUser(sysTenantPackUser);
        return Result.ok((String)"\u7533\u8bf7\u6210\u529f\uff01");
    }

    @PutMapping(value={"/passApply"})
    public Result<?> passApply(@RequestBody SysTenantPackUser sysTenantPackUser) {
        this.sysTenantService.passApply(sysTenantPackUser);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PutMapping(value={"/deleteApply"})
    public Result<?> deleteApply(@RequestBody SysTenantPackUser sysTenantPackUser) {
        this.sysTenantService.deleteApply(sysTenantPackUser);
        return Result.ok((String)"");
    }

    @GetMapping(value={"/getApplySuperAdminCount"})
    public Result<Long> getApplySuperAdminCount() {
        Long count = this.sysTenantService.getApplySuperAdminCount();
        return Result.ok((Object)count);
    }

    @RequestMapping(value={"/queryTenantAuthInfo"}, method={RequestMethod.GET})
    public Result<TenantDepartAuthInfo> queryTenantAuthInfo(@RequestParam(name="id", required=true) String id) {
        TenantDepartAuthInfo info = this.sysTenantService.getTenantDepartAuthInfo(Integer.parseInt(id));
        return Result.ok((Object)info);
    }

    @GetMapping(value={"/queryTenantPackUserList"})
    public Result<IPage<TenantPackUser>> queryTenantPackUserList(@RequestParam(value="tenantId") String tenantId, @RequestParam(value="packId") String packId, @RequestParam(value="status") Integer status, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<TenantPackUser> pageList = this.sysTenantService.queryTenantPackUserList(tenantId, packId, status, (Page<TenantPackUser>)page);
        return Result.ok(pageList);
    }

    @GetMapping(value={"/getTenantCount"})
    public Result<Map<String, Long>> getTenantCount(HttpServletRequest request) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        if (oConvertUtils.isEmpty((Object)TokenUtils.getTenantIdByRequest((HttpServletRequest)request))) {
            return Result.error((String)"\u5f53\u524d\u79df\u6237\u4e3a\u7a7a\uff0c\u7981\u6b62\u8bbf\u95ee\uff01");
        }
        Integer tenantId = oConvertUtils.getInt((String)TokenUtils.getTenantIdByRequest((HttpServletRequest)request));
        Long userCount = this.relationService.getUserCount(tenantId, "1");
        map.put("userCount", userCount);
        LambdaQueryWrapper departQuery = new LambdaQueryWrapper();
        departQuery.eq(SysDepart::getDelFlag, (Object)String.valueOf(CommonConstant.DEL_FLAG_0));
        departQuery.eq(SysDepart::getTenantId, (Object)tenantId);
        long departCount = this.sysDepartService.count((Wrapper)departQuery);
        map.put("departCount", departCount);
        return Result.ok(map);
    }

    @GetMapping(value={"/getTenantPageListByUserId"})
    public Result<IPage<SysTenant>> getTenantPageListByUserId(SysUserTenantVo sysUserTenantVo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        List<String> list = null;
        String userTenantStatus = sysUserTenantVo.getUserTenantStatus();
        if (oConvertUtils.isNotEmpty((Object)userTenantStatus)) {
            list = Arrays.asList(userTenantStatus.split(","));
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<SysTenant> pageList = this.relationService.getTenantPageListByUserId((Page<SysTenant>)page, sysUser.getId(), list, sysUserTenantVo);
        return Result.ok(pageList);
    }

    @PutMapping(value={"/agreeOrRefuseJoinTenant"})
    public Result<String> agreeOrRefuseJoinTenant(@RequestParam(value="tenantId") Integer tenantId, @RequestParam(value="status") String status) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String userId = sysUser.getId();
        SysTenant tenant = (SysTenant)this.sysTenantService.getById(tenantId);
        if (null == tenant) {
            return Result.error((String)"\u4e0d\u5b58\u5728\u8be5\u7ec4\u7ec7");
        }
        SysUserTenant sysUserTenant = this.relationService.getUserTenantByTenantId(userId, tenantId);
        if (null == sysUserTenant) {
            return Result.error((String)"\u8be5\u7528\u6237\u4e0d\u5b58\u5728\u8be5\u7ec4\u7ec7\u4e2d\uff0c\u65e0\u6743\u4fee\u6539");
        }
        String content = "";
        SysUser user = new SysUser();
        user.setUsername(sysUserTenant.getCreateBy());
        String realname = oConvertUtils.getString((String)sysUser.getRealname(), (String)sysUser.getUsername());
        if ("1".equals(status)) {
            this.relationService.agreeJoinTenant(userId, tenantId);
            content = content + realname + "\u5df2\u540c\u610f\u60a8\u53d1\u9001\u7684\u52a0\u5165 " + tenant.getName() + " \u7684\u9080\u8bf7";
            this.sysTenantService.sendMsgForAgreeAndRefuseJoin(user, content);
            return Result.OK((String)"\u60a8\u5df2\u540c\u610f\u8be5\u7ec4\u7ec7\u7684\u9080\u8bf7");
        }
        if ("4".equals(status)) {
            this.relationService.refuseJoinTenant(userId, tenantId);
            content = content + realname + "\u62d2\u7edd\u4e86\u60a8\u53d1\u9001\u7684\u52a0\u5165 " + tenant.getName() + " \u7684\u9080\u8bf7";
            this.sysTenantService.sendMsgForAgreeAndRefuseJoin(user, content);
            return Result.OK((String)"\u60a8\u5df2\u6210\u529f\u62d2\u7edd\u8be5\u7ec4\u7ec7\u7684\u9080\u8bf7");
        }
        return Result.error((String)"\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u7981\u6b62\u4fee\u6539\u6570\u636e");
    }

    @DeleteMapping(value={"/deleteUserByPassword"})
    public Result<String> deleteUserByPassword(@RequestBody SysUser sysUser, HttpServletRequest request) {
        Integer tenantId = oConvertUtils.getInteger((Object)TokenUtils.getTenantIdByRequest((HttpServletRequest)request), null);
        this.sysTenantService.deleteUserByPassword(sysUser, tenantId);
        return Result.ok((String)"\u5220\u9664\u7528\u6237\u6210\u529f");
    }

    @RequestMapping(value={"/getCurrentUserTenantForFile"}, method={RequestMethod.GET})
    public Result<Map<String, Object>> getCurrentUserTenantForFile() {
        Result result = new Result();
        try {
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            List<SysTenant> tenantList = this.sysTenantService.getTenantListByUserId(sysUser.getId());
            HashMap<String, List<SysTenant>> map = new HashMap<String, List<SysTenant>>(5);
            if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue() && CollectionUtil.isNotEmpty(tenantList)) {
                map.put("list", tenantList);
            }
            result.setSuccess(true);
            result.setResult(map);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u67e5\u8be2\u5931\u8d25\uff01");
        }
        return result;
    }
}

