/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ImportExcelUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.modules.system.entity.SysPosition;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.service.ISysPositionService;
import org.jeecg.modules.system.service.ISysUserPositionService;
import org.jeecg.modules.system.service.ISysUserService;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@Api(tags={"\u804c\u52a1\u8868"})
@RestController
@RequestMapping(value={"/sys/position"})
public class SysPositionController {
    private static final Logger log = LoggerFactory.getLogger(SysPositionController.class);
    @Autowired
    private ISysPositionService sysPositionService;
    @Autowired
    private ISysUserPositionService userPositionService;
    @Autowired
    private ISysUserService userService;

    @AutoLog(value="\u804c\u52a1\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="\u804c\u52a1\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u804c\u52a1\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<IPage<SysPosition>> queryPageList(SysPosition sysPosition, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            sysPosition.setTenantId(oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0));
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysPosition, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysPositionService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @AutoLog(value="\u804c\u52a1\u8868-\u6dfb\u52a0")
    @ApiOperation(value="\u804c\u52a1\u8868-\u6dfb\u52a0", notes="\u804c\u52a1\u8868-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<SysPosition> add(@RequestBody SysPosition sysPosition) {
        Result result = new Result();
        try {
            if (oConvertUtils.isEmpty((Object)sysPosition.getCode())) {
                sysPosition.setCode(RandomUtil.randomString((int)10));
            }
            this.sysPositionService.save(sysPosition);
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @AutoLog(value="\u804c\u52a1\u8868-\u7f16\u8f91")
    @ApiOperation(value="\u804c\u52a1\u8868-\u7f16\u8f91", notes="\u804c\u52a1\u8868-\u7f16\u8f91")
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<SysPosition> edit(@RequestBody SysPosition sysPosition) {
        Result result = new Result();
        SysPosition sysPositionEntity = (SysPosition)this.sysPositionService.getById((Serializable)((Object)sysPosition.getId()));
        if (sysPositionEntity == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean ok = this.sysPositionService.updateById(sysPosition);
            if (ok) {
                result.success("\u4fee\u6539\u6210\u529f!");
            }
        }
        return result;
    }

    @AutoLog(value="\u804c\u52a1\u8868-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u804c\u52a1\u8868-\u901a\u8fc7id\u5220\u9664", notes="\u804c\u52a1\u8868-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        try {
            this.sysPositionService.removeById((Serializable)((Object)id));
            this.userPositionService.removeByPositionId(id);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u5931\u8d25", (Object)e.getMessage());
            return Result.error((String)"\u5220\u9664\u5931\u8d25!");
        }
        return Result.ok((String)"\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u804c\u52a1\u8868-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u804c\u52a1\u8868-\u6279\u91cf\u5220\u9664", notes="\u804c\u52a1\u8868-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<SysPosition> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result result = new Result();
        if (ids == null || "".equals(ids.trim())) {
            result.error500("\u53c2\u6570\u4e0d\u8bc6\u522b\uff01");
        } else {
            this.sysPositionService.removeByIds(Arrays.asList(ids.split(",")));
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @AutoLog(value="\u804c\u52a1\u8868-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u804c\u52a1\u8868-\u901a\u8fc7id\u67e5\u8be2", notes="\u804c\u52a1\u8868-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<SysPosition> queryById(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        SysPosition sysPosition = (SysPosition)this.sysPositionService.getById((Serializable)((Object)id));
        if (sysPosition == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult((Object)sysPosition);
            result.setSuccess(true);
        }
        return result;
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, HttpServletResponse response) {
        QueryWrapper queryWrapper = null;
        try {
            String paramsStr = request.getParameter("paramsStr");
            if (oConvertUtils.isNotEmpty((Object)paramsStr)) {
                String deString = URLDecoder.decode(paramsStr, "UTF-8");
                SysPosition sysPosition = (SysPosition)JSON.parseObject((String)deString, SysPosition.class);
                if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
                    sysPosition.setTenantId(oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0));
                }
                queryWrapper = QueryGenerator.initQueryWrapper((Object)sysPosition, (Map)request.getParameterMap());
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ModelAndView mv = new ModelAndView((View)new JeecgEntityExcelView());
        List pageList = this.sysPositionService.list((Wrapper)queryWrapper);
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        mv.addObject("fileName", (Object)"\u804c\u52a1\u8868\u5217\u8868");
        mv.addObject("entity", SysPosition.class);
        mv.addObject("params", (Object)new ExportParams("\u804c\u52a1\u8868\u5217\u8868\u6570\u636e", "\u5bfc\u51fa\u4eba:" + user.getRealname(), "\u5bfc\u51fa\u4fe1\u606f"));
        mv.addObject("data", (Object)pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList errorMessage = new ArrayList();
        int successLines = 0;
        int errorLines = 0;
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List listSysPositions = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), SysPosition.class, (ImportParams)params);
                List list = ImportExcelUtil.importDateSave((List)listSysPositions, ISysPositionService.class, errorMessage, (String)"uniq_code");
                successLines += listSysPositions.size() - (errorLines += list.size());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage()));
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ImportExcelUtil.imporReturnRes((int)errorLines, (int)successLines, errorMessage);
    }

    @AutoLog(value="\u804c\u52a1\u8868-\u901a\u8fc7code\u67e5\u8be2")
    @ApiOperation(value="\u804c\u52a1\u8868-\u901a\u8fc7code\u67e5\u8be2", notes="\u804c\u52a1\u8868-\u901a\u8fc7code\u67e5\u8be2")
    @GetMapping(value={"/queryByCode"})
    public Result<SysPosition> queryByCode(@RequestParam(name="code", required=true) String code) {
        Result result = new Result();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code", (Object)code);
        SysPosition sysPosition = (SysPosition)this.sysPositionService.getOne((Wrapper)queryWrapper);
        if (sysPosition == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult((Object)sysPosition);
            result.setSuccess(true);
        }
        return result;
    }

    @AutoLog(value="\u804c\u52a1\u8868-\u901a\u8fc7\u591a\u4e2a\u67e5\u8be2")
    @ApiOperation(value="\u804c\u52a1\u8868-\u901a\u8fc7\u591a\u4e2aid\u67e5\u8be2", notes="\u804c\u52a1\u8868-\u901a\u8fc7\u591a\u4e2aid\u67e5\u8be2")
    @GetMapping(value={"/queryByIds"})
    public Result<List<SysPosition>> queryByIds(@RequestParam(name="ids") String ids) {
        Result result = new Result();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in(true, (Object)"id", (Object[])ids.split(","));
        List list = this.sysPositionService.list((Wrapper)queryWrapper);
        if (list == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult((Object)list);
            result.setSuccess(true);
        }
        return result;
    }

    @GetMapping(value={"/getPositionUserList"})
    public Result<IPage<SysUser>> getPositionUserList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="positionId") String positionId) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<SysUser> pageList = this.userPositionService.getPositionUserList((Page<SysUser>)page, positionId);
        List<String> userIds = pageList.getRecords().stream().map(SysUser::getId).collect(Collectors.toList());
        if (null != userIds && userIds.size() > 0) {
            Map<String, String> useDepNames = this.userService.getDepNamesByUserIds(userIds);
            pageList.getRecords().forEach(item -> item.setOrgCodeTxt((String)useDepNames.get(item.getId())));
        }
        return Result.ok(pageList);
    }

    @PostMapping(value={"/savePositionUser"})
    public Result<String> saveUserPosition(@RequestParam(name="userIds") String userIds, @RequestParam(name="positionId") String positionId) {
        this.userPositionService.saveUserPosition(userIds, positionId);
        return Result.ok((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @DeleteMapping(value={"/removePositionUser"})
    public Result<String> removeUserPosition(@RequestParam(name="userIds") String userIds, @RequestParam(name="positionId") String positionId) {
        this.userPositionService.removePositionUser(userIds, positionId);
        return Result.OK((String)"\u79fb\u9664\u6210\u5458\u6210\u529f");
    }
}

