/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ImportExcelUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.model.DepartIdModel;
import org.jeecg.modules.system.model.SysDepartTreeModel;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.service.ISysUserDepartService;
import org.jeecg.modules.system.service.ISysUserService;
import org.jeecg.modules.system.vo.SysDepartExportVo;
import org.jeecg.modules.system.vo.lowapp.ExportDepartVo;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/sys/sysDepart"})
public class SysDepartController {
    private static final Logger log = LoggerFactory.getLogger(SysDepartController.class);
    @Autowired
    private ISysDepartService sysDepartService;
    @Autowired
    public RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ISysUserDepartService sysUserDepartService;

    @RequestMapping(value={"/queryMyDeptTreeList"}, method={RequestMethod.GET})
    public Result<List<SysDepartTreeModel>> queryMyDeptTreeList() {
        Result result = new Result();
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        try {
            if (oConvertUtils.isNotEmpty((Object)user.getUserIdentity()) && user.getUserIdentity().equals(CommonConstant.USER_IDENTITY_2)) {
                String departIds = user.getDepartIds();
                if (StringUtils.isNotBlank((CharSequence)departIds)) {
                    List<SysDepartTreeModel> list = this.sysDepartService.queryMyDeptTreeList(departIds);
                    result.setResult(list);
                }
                result.setMessage(CommonConstant.USER_IDENTITY_2.toString());
                result.setSuccess(true);
            } else {
                result.setMessage(CommonConstant.USER_IDENTITY_1.toString());
                result.setSuccess(true);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/queryTreeList"}, method={RequestMethod.GET})
    public Result<List<SysDepartTreeModel>> queryTreeList(@RequestParam(name="ids", required=false) String ids) {
        Result result = new Result();
        try {
            if (oConvertUtils.isNotEmpty((Object)ids)) {
                List<SysDepartTreeModel> departList = this.sysDepartService.queryTreeList(ids);
                result.setResult(departList);
            } else {
                List<SysDepartTreeModel> list = this.sysDepartService.queryTreeList();
                result.setResult(list);
            }
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/queryDepartTreeSync"}, method={RequestMethod.GET})
    public Result<List<SysDepartTreeModel>> queryDepartTreeSync(@RequestParam(name="pid", required=false) String parentId, @RequestParam(name="ids", required=false) String ids, @RequestParam(name="primaryKey", required=false) String primaryKey) {
        Result result = new Result();
        try {
            List<SysDepartTreeModel> list = this.sysDepartService.queryTreeListByPid(parentId, ids, primaryKey);
            result.setResult(list);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.setSuccess(false);
            result.setMessage("\u67e5\u8be2\u5931\u8d25");
        }
        return result;
    }

    @GetMapping(value={"/queryAllParentId"})
    public Result queryParentIds(@RequestParam(name="departId", required=false) String departId, @RequestParam(name="orgCode", required=false) String orgCode) {
        try {
            JSONObject data;
            if (oConvertUtils.isNotEmpty((Object)departId)) {
                data = this.sysDepartService.queryAllParentIdByDepartId(departId);
            } else if (oConvertUtils.isNotEmpty((Object)orgCode)) {
                data = this.sysDepartService.queryAllParentIdByOrgCode(orgCode);
            } else {
                return Result.error((String)"departId \u548c orgCode \u4e0d\u80fd\u90fd\u4e3a\u7a7a\uff01");
            }
            return Result.OK((Object)data);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @RequiresPermissions(value={"system:depart:add"})
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @CacheEvict(value={"sys:cache:depart:alldata", "sys:cache:depart:allids"}, allEntries=true)
    public Result<SysDepart> add(@RequestBody SysDepart sysDepart, HttpServletRequest request) {
        Result result = new Result();
        String username = JwtUtil.getUserNameByToken((HttpServletRequest)request);
        try {
            sysDepart.setCreateBy(username);
            this.sysDepartService.saveDepartData(sysDepart, username);
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequiresPermissions(value={"system:depart:edit"})
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    @CacheEvict(value={"sys:cache:depart:alldata", "sys:cache:depart:allids"}, allEntries=true)
    public Result<SysDepart> edit(@RequestBody SysDepart sysDepart, HttpServletRequest request) {
        String username = JwtUtil.getUserNameByToken((HttpServletRequest)request);
        sysDepart.setUpdateBy(username);
        Result result = new Result();
        SysDepart sysDepartEntity = (SysDepart)this.sysDepartService.getById((Serializable)((Object)sysDepart.getId()));
        if (sysDepartEntity == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean ok = this.sysDepartService.updateDepartDataById(sysDepart, username);
            if (ok) {
                result.success("\u4fee\u6539\u6210\u529f!");
            }
        }
        return result;
    }

    @RequiresPermissions(value={"system:depart:delete"})
    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    @CacheEvict(value={"sys:cache:depart:alldata", "sys:cache:depart:allids"}, allEntries=true)
    public Result<SysDepart> delete(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        SysDepart sysDepart = (SysDepart)this.sysDepartService.getById((Serializable)((Object)id));
        if (sysDepart == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            this.sysDepartService.deleteDepart(id);
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @RequiresPermissions(value={"system:depart:deleteBatch"})
    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.DELETE})
    @CacheEvict(value={"sys:cache:depart:alldata", "sys:cache:depart:allids"}, allEntries=true)
    public Result<SysDepart> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result result = new Result();
        if (ids == null || "".equals(ids.trim())) {
            result.error500("\u53c2\u6570\u4e0d\u8bc6\u522b\uff01");
        } else {
            this.sysDepartService.deleteBatchWithChildren(Arrays.asList(ids.split(",")));
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @RequestMapping(value={"/queryIdTree"}, method={RequestMethod.GET})
    public Result<List<DepartIdModel>> queryIdTree() {
        Result result = new Result();
        try {
            List<DepartIdModel> list = this.sysDepartService.queryDepartIdTreeList();
            result.setResult(list);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/searchBy"}, method={RequestMethod.GET})
    public Result<List<SysDepartTreeModel>> searchBy(@RequestParam(name="keyWord", required=true) String keyWord, @RequestParam(name="myDeptSearch", required=false) String myDeptSearch) {
        List<SysDepartTreeModel> treeList;
        Result result = new Result();
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String departIds = null;
        if (oConvertUtils.isNotEmpty((Object)user.getUserIdentity()) && user.getUserIdentity().equals(CommonConstant.USER_IDENTITY_2)) {
            departIds = user.getDepartIds();
        }
        if ((treeList = this.sysDepartService.searchByKeyWord(keyWord, myDeptSearch, departIds)) == null || treeList.size() == 0) {
            result.setSuccess(false);
            result.setMessage("\u672a\u67e5\u8be2\u5339\u914d\u6570\u636e\uff01");
            return result;
        }
        result.setResult(treeList);
        return result;
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(SysDepart sysDepart, HttpServletRequest request) {
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            sysDepart.setTenantId(oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0));
        }
        ModelAndView mv = new ModelAndView((View)new JeecgEntityExcelView());
        Integer tenantId = sysDepart == null ? null : sysDepart.getTenantId();
        List<SysDepartExportVo> sysDepartExportVos = this.sysDepartService.getExportDepart(tenantId);
        mv.addObject("fileName", (Object)"\u90e8\u95e8\u5217\u8868");
        mv.addObject("entity", SysDepartExportVo.class);
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        mv.addObject("params", (Object)new ExportParams("\u5bfc\u5165\u89c4\u5219\uff1a\n1\u3001\u6807\u9898\u4e3a\u7b2c\u4e09\u884c\uff0c\u90e8\u95e8\u8def\u5f84\u548c\u90e8\u95e8\u540d\u79f0\u7684\u6807\u9898\u4e0d\u5141\u8bb8\u4fee\u6539\uff0c\u5426\u5219\u4f1a\u5339\u914d\u5931\u8d25\uff1b\u7b2c\u56db\u884c\u4e3a\u6570\u636e\u586b\u5199\u8303\u56f4;\n2\u3001\u90e8\u95e8\u8def\u5f84\u7528\u82f1\u6587\u5b57\u7b26/\u5206\u5272\uff0c\u90e8\u95e8\u540d\u79f0\u4e3a\u90e8\u95e8\u8def\u5f84\u7684\u6700\u540e\u4e00\u4f4d;\n3\u3001\u90e8\u95e8\u4ece\u4e00\u7ea7\u540d\u79f0\u5f00\u59cb\u521b\u5efa\uff0c\u5982\u679c\u6709\u540c\u7ea7\u5c31\u9700\u8981\u591a\u6dfb\u52a0\u4e00\u884c\uff0c\u5982\u7814\u53d1\u90e8/\u7814\u53d1\u4e00\u90e8;\u7814\u53d1\u90e8/\u7814\u53d1\u4e8c\u90e8;\n4\u3001\u81ea\u5b9a\u4e49\u7684\u90e8\u95e8\u7f16\u7801\u9700\u8981\u6ee1\u8db3\u89c4\u5219\u624d\u80fd\u5bfc\u5165\u3002\u5982\u4e00\u7ea7\u90e8\u95e8\u7f16\u7801\u4e3aA01,\u90a3\u4e48\u5b50\u90e8\u95e8\u4e3aA01A01,\u540c\u7ea7\u5b50\u90e8\u95e8\u4e3aA01A02,\u7f16\u7801\u56fa\u5b9a\u4e3a\u4e09\u4f4d\uff0c\u9996\u5b57\u6bcd\u4e3aA-Z,\u540e\u4e24\u4f4d\u4e3a\u6570\u5b570-99\uff0c\u4f9d\u6b21\u9012\u589e;", "\u5bfc\u51fa\u4eba:" + user.getRealname(), "\u5bfc\u51fa\u4fe1\u606f"));
        mv.addObject("data", sysDepartExportVos);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"system:depart:importExcel"})
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    @CacheEvict(value={"sys:cache:depart:alldata", "sys:cache:depart:allids"}, allEntries=true)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        ArrayList<String> errorMessageList = new ArrayList<String>();
        List listSysDeparts = null;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                listSysDeparts = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), SysDepartExportVo.class, (ImportParams)params);
                this.sysDepartService.importSysDepart(listSysDeparts, errorMessageList);
                Set keys3 = this.redisTemplate.keys((Object)"sys:cache:depart:alldata*");
                Set keys4 = this.redisTemplate.keys((Object)"sys:cache:depart:allids*");
                this.redisTemplate.delete((Collection)keys3);
                this.redisTemplate.delete((Collection)keys4);
                Result result = ImportExcelUtil.imporReturnRes((int)errorMessageList.size(), (int)(listSysDeparts.size() - errorMessageList.size()), errorMessageList);
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage()));
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }

    @GetMapping(value={"listAll"})
    public Result<List<SysDepart>> listAll(@RequestParam(name="id", required=false) String id) {
        Result result = new Result();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.orderByAsc(SysDepart::getOrgCode);
        if (oConvertUtils.isNotEmpty((Object)id)) {
            Object[] arr = id.split(",");
            query.in(SysDepart::getId, arr);
        }
        List ls = this.sysDepartService.list((Wrapper)query);
        result.setSuccess(true);
        result.setResult((Object)ls);
        return result;
    }

    @RequestMapping(value={"/queryTreeByKeyWord"}, method={RequestMethod.GET})
    public Result<Map<String, Object>> queryTreeByKeyWord(@RequestParam(name="keyWord", required=false) String keyWord) {
        Result result = new Result();
        try {
            HashMap<String, List<SysDepartTreeModel>> map = new HashMap<String, List<SysDepartTreeModel>>(5);
            List<SysDepartTreeModel> list = this.sysDepartService.queryTreeByKeyWord(keyWord);
            LambdaQueryWrapper queryUser = new LambdaQueryWrapper();
            queryUser.eq(SysUser::getDelFlag, (Object)CommonConstant.DEL_FLAG_0);
            queryUser.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(SysUser::getUsername, (Object)keyWord)).or()).like(SysUser::getRealname, (Object)keyWord);
            });
            List sysUsers = this.sysUserService.list((Wrapper)queryUser);
            map.put("userList", sysUsers);
            map.put("departList", list);
            result.setResult(map);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @GetMapping(value={"/getDepartName"})
    public Result<SysDepart> getDepartName(@RequestParam(name="orgCode") String orgCode) {
        Result result = new Result();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysDepart::getOrgCode, (Object)orgCode);
        SysDepart sysDepart = (SysDepart)this.sysDepartService.getOne((Wrapper)query);
        result.setSuccess(true);
        result.setResult((Object)sysDepart);
        return result;
    }

    @GetMapping(value={"/getUsersByDepartId"})
    public Result<List<SysUser>> getUsersByDepartId(@RequestParam(name="id") String id) {
        Result result = new Result();
        List<SysUser> sysUsers = this.sysUserDepartService.queryUserByDepId(id);
        result.setSuccess(true);
        result.setResult(sysUsers);
        return result;
    }

    @RequestMapping(value={"/queryByIds"}, method={RequestMethod.GET})
    public Result<Collection<SysDepart>> queryByIds(@RequestParam(name="deptIds") String deptIds) {
        Result result = new Result();
        String[] ids = deptIds.split(",");
        List<String> idList = Arrays.asList(ids);
        List deptList = this.sysDepartService.listByIds(idList);
        result.setSuccess(true);
        result.setResult((Object)deptList);
        return result;
    }

    @GetMapping(value={"/getMyDepartList"})
    public Result<List<SysDepart>> getMyDepartList() {
        List<SysDepart> list = this.sysDepartService.getMyDepartList();
        return Result.ok(list);
    }

    @RequestMapping(value={"/queryBookDepTreeSync"}, method={RequestMethod.GET})
    public Result<List<SysDepartTreeModel>> queryBookDepTreeSync(@RequestParam(name="pid", required=false) String parentId, @RequestParam(name="tenantId") Integer tenantId, @RequestParam(name="departName", required=false) String departName) {
        Result result = new Result();
        try {
            List<SysDepartTreeModel> list = this.sysDepartService.queryBookDepTreeSync(parentId, tenantId, departName);
            result.setResult(list);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @GetMapping(value={"/getUsersByDepartTenantId"})
    public Result<List<SysUser>> getUsersByDepartTenantId(@RequestParam(value="departId") String departId) {
        int tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        List<SysUser> sysUserList = this.sysUserDepartService.getUsersByDepartTenantId(departId, tenantId);
        return Result.ok(sysUserList);
    }

    @RequestMapping(value={"/appExportXls"})
    public ModelAndView appExportXls(SysDepart sysDepart, HttpServletRequest request) {
        int tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        ModelAndView mv = new ModelAndView((View)new JeecgEntityExcelView());
        List<ExportDepartVo> pageList = this.sysDepartService.getExcelDepart(tenantId);
        mv.addObject("fileName", (Object)"\u90e8\u95e8\u5217\u8868");
        mv.addObject("entity", ExportDepartVo.class);
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        mv.addObject("params", (Object)new ExportParams("\u90e8\u95e8\u5217\u8868\u6570\u636e", "\u5bfc\u51fa\u4eba:" + user.getRealname(), "\u5bfc\u51fa\u4fe1\u606f"));
        mv.addObject("data", pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/appImportExcel"}, method={RequestMethod.POST})
    @CacheEvict(value={"sys:cache:depart:alldata", "sys:cache:depart:allids"}, allEntries=true)
    public Result<?> appImportExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        ArrayList<String> errorMessageList = new ArrayList<String>();
        List listSysDeparts = null;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                listSysDeparts = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), ExportDepartVo.class, (ImportParams)params);
                this.sysDepartService.importExcel(listSysDeparts, errorMessageList);
                Set keys3 = this.redisTemplate.keys((Object)"sys:cache:depart:alldata*");
                Set keys4 = this.redisTemplate.keys((Object)"sys:cache:depart:allids*");
                this.redisTemplate.delete((Collection)keys3);
                this.redisTemplate.delete((Collection)keys4);
                Result result = ImportExcelUtil.imporReturnRes((int)errorMessageList.size(), (int)(listSysDeparts.size() - errorMessageList.size()), errorMessageList);
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage()));
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }
}

