/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.dynamic.db.DataSourceCachePool;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.common.util.security.JdbcSecurityUtil;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.modules.system.entity.SysDataSource;
import org.jeecg.modules.system.service.ISysDataSourceService;
import org.jeecg.modules.system.util.SecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u591a\u6570\u636e\u6e90\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/sys/dataSource"})
public class SysDataSourceController
extends JeecgController<SysDataSource, ISysDataSourceService> {
    private static final Logger log = LoggerFactory.getLogger(SysDataSourceController.class);
    @Autowired
    private ISysDataSourceService sysDataSourceService;

    @AutoLog(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @RequiresPermissions(value={"system:datasource:list"})
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SysDataSource sysDataSource, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            sysDataSource.setTenantId(oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0));
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysDataSource, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysDataSourceService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @GetMapping(value={"/options"})
    public Result<?> queryOptions(SysDataSource sysDataSource, HttpServletRequest req) {
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            sysDataSource.setTenantId(oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0));
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysDataSource, (Map)req.getParameterMap());
        List pageList = this.sysDataSourceService.list((Wrapper)queryWrapper);
        JSONArray array = new JSONArray(pageList.size());
        for (SysDataSource item : pageList) {
            JSONObject option = new JSONObject(3);
            option.put("value", (Object)item.getCode());
            option.put("label", (Object)item.getName());
            option.put("text", (Object)item.getName());
            array.add((Object)option);
        }
        return Result.ok((Object)array);
    }

    @AutoLog(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u6dfb\u52a0")
    @ApiOperation(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u6dfb\u52a0", notes="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody SysDataSource sysDataSource) {
        try {
            JdbcSecurityUtil.validate((String)sysDataSource.getDbUrl());
        }
        catch (JeecgBootException e) {
            log.error(e.toString());
            return Result.error((String)("\u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return this.sysDataSourceService.saveDataSource(sysDataSource);
    }

    @AutoLog(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u7f16\u8f91")
    @ApiOperation(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u7f16\u8f91", notes="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u7f16\u8f91")
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<?> edit(@RequestBody SysDataSource sysDataSource) {
        try {
            JdbcSecurityUtil.validate((String)sysDataSource.getDbUrl());
        }
        catch (JeecgBootException e) {
            log.error(e.toString());
            return Result.error((String)("\u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return this.sysDataSourceService.editDataSource(sysDataSource);
    }

    @AutoLog(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664", notes="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        return this.sysDataSourceService.deleteDataSource(id);
    }

    @AutoLog(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u6279\u91cf\u5220\u9664", notes="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        idList.forEach(item -> {
            SysDataSource sysDataSource = (SysDataSource)this.sysDataSourceService.getById((Serializable)((Object)item));
            DataSourceCachePool.removeCache((String)sysDataSource.getCode());
        });
        this.sysDataSourceService.removeByIds(idList);
        return Result.ok((String)"\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @AutoLog(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u901a\u8fc7id\u67e5\u8be2", notes="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) throws InterruptedException {
        SysDataSource sysDataSource = (SysDataSource)this.sysDataSourceService.getById((Serializable)((Object)id));
        String dbPassword = sysDataSource.getDbPassword();
        if (StringUtils.isNotBlank((String)dbPassword)) {
            String decodedStr = SecurityUtil.jiemi(dbPassword);
            sysDataSource.setDbPassword(decodedStr);
        }
        return Result.ok((Object)sysDataSource);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, SysDataSource sysDataSource) {
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            sysDataSource.setTenantId(oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0));
        }
        return super.exportXls(request, (Object)sysDataSource, SysDataSource.class, "\u591a\u6570\u636e\u6e90\u7ba1\u7406");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, SysDataSource.class);
    }
}

