/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.dto.DataLogDTO;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.system.entity.SysComment;
import org.jeecg.modules.system.service.ISysCommentService;
import org.jeecg.modules.system.vo.SysCommentFileVo;
import org.jeecg.modules.system.vo.SysCommentVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u7cfb\u7edf\u8bc4\u8bba\u56de\u590d\u8868"})
@RestController
@RequestMapping(value={"/sys/comment"})
public class SysCommentController
extends JeecgController<SysComment, ISysCommentService> {
    private static final Logger log = LoggerFactory.getLogger(SysCommentController.class);
    @Autowired
    private ISysCommentService sysCommentService;
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Value(value="${jeecg.file-view-domain}/onlinePreview")
    private String onlinePreviewDomain;

    @ApiOperation(value="\u7cfb\u7edf\u8bc4\u8bba\u56de\u590d\u8868-\u5217\u8868\u67e5\u8be2", notes="\u7cfb\u7edf\u8bc4\u8bba\u56de\u590d\u8868-\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/listByForm"})
    public Result<IPage<SysCommentVO>> queryListByForm(SysComment sysComment) {
        List<SysCommentVO> list = this.sysCommentService.queryFormCommentInfo(sysComment);
        Page pageList = new Page();
        pageList.setRecords(list);
        return Result.OK((Object)pageList);
    }

    @ApiOperation(value="\u7cfb\u7edf\u8bc4\u8bba\u56de\u590d\u8868-\u5217\u8868\u67e5\u8be2", notes="\u7cfb\u7edf\u8bc4\u8bba\u56de\u590d\u8868-\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/fileList"})
    public Result<IPage<SysCommentFileVo>> queryFileList(SysComment sysComment) {
        List<SysCommentFileVo> list = this.sysCommentService.queryFormFileList(sysComment.getTableName(), sysComment.getTableDataId());
        Page pageList = new Page();
        pageList.setRecords(list);
        return Result.OK((Object)pageList);
    }

    @ApiOperation(value="\u7cfb\u7edf\u8bc4\u8bba\u8868-\u6dfb\u52a0\u6587\u672c", notes="\u7cfb\u7edf\u8bc4\u8bba\u8868-\u6dfb\u52a0\u6587\u672c")
    @PostMapping(value={"/addText"})
    public Result<String> addText(@RequestBody SysComment sysComment) {
        String commentId = this.sysCommentService.saveOne(sysComment);
        return Result.OK((String)commentId);
    }

    @ApiOperation(value="\u7cfb\u7edf\u8bc4\u8bba\u8868-\u6dfb\u52a0\u6587\u4ef6", notes="\u7cfb\u7edf\u8bc4\u8bba\u8868-\u6dfb\u52a0\u6587\u4ef6")
    @PostMapping(value={"/addFile"})
    public Result<String> addFile(HttpServletRequest request) {
        try {
            this.sysCommentService.saveOneFileComment(request);
            return Result.OK((String)"success");
        }
        catch (Exception e) {
            log.error("\u8bc4\u8bba\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            return Result.error((String)("\u64cd\u4f5c\u5931\u8d25," + e.getMessage()));
        }
    }

    @ApiOperation(value="\u7cfb\u7edf\u8bc4\u8bba\u8868-\u6dfb\u52a0\u6587\u4ef6", notes="\u7cfb\u7edf\u8bc4\u8bba\u8868-\u6dfb\u52a0\u6587\u4ef6")
    @PostMapping(value={"/appAddFile"})
    public Result<String> appAddFile(HttpServletRequest request) {
        try {
            this.sysCommentService.appSaveOneFileComment(request);
            return Result.OK((String)"success");
        }
        catch (Exception e) {
            log.error("\u8bc4\u8bba\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            return Result.error((String)("\u64cd\u4f5c\u5931\u8d25," + e.getMessage()));
        }
    }

    @ApiOperation(value="\u7cfb\u7edf\u8bc4\u8bba\u56de\u590d\u8868-\u901a\u8fc7id\u5220\u9664", notes="\u7cfb\u7edf\u8bc4\u8bba\u56de\u590d\u8868-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/deleteOne"})
    public Result<String> deleteOne(@RequestParam(name="id", required=true) String id) {
        SysComment comment = (SysComment)this.sysCommentService.getById((Serializable)((Object)id));
        if (comment == null) {
            return Result.error((String)"\u8be5\u8bc4\u8bba\u5df2\u88ab\u5220\u9664\uff01");
        }
        String admin = "admin";
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String username = sysUser.getUsername();
        if (!admin.equals(username) && !username.equals(comment.getCreateBy())) {
            return Result.error((String)"\u53ea\u80fd\u5220\u9664\u81ea\u5df1\u7684\u8bc4\u8bba\uff01");
        }
        this.sysCommentService.deleteOne(id);
        String logContent = "\u5220\u9664\u4e86\u8bc4\u8bba\uff0c " + comment.getCommentContent();
        DataLogDTO dataLog = new DataLogDTO(comment.getTableName(), comment.getTableDataId(), logContent, "comment");
        this.sysBaseAPI.saveDataLog(dataLog);
        return Result.OK((String)"\u5220\u9664\u6210\u529f!");
    }

    @GetMapping(value={"/getFileViewDomain"})
    public Result<String> getFileViewDomain() {
        return Result.OK((String)this.onlinePreviewDomain);
    }

    @ApiOperation(value="\u7cfb\u7edf\u8bc4\u8bba\u56de\u590d\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u7cfb\u7edf\u8bc4\u8bba\u56de\u590d\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<IPage<SysComment>> queryPageList(SysComment sysComment, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysComment, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysCommentService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @ApiOperation(value="\u7cfb\u7edf\u8bc4\u8bba\u56de\u590d\u8868-\u6dfb\u52a0", notes="\u7cfb\u7edf\u8bc4\u8bba\u56de\u590d\u8868-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<String> add(@RequestBody SysComment sysComment) {
        this.sysCommentService.save(sysComment);
        return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u7cfb\u7edf\u8bc4\u8bba\u56de\u590d\u8868-\u7f16\u8f91", notes="\u7cfb\u7edf\u8bc4\u8bba\u56de\u590d\u8868-\u7f16\u8f91")
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<String> edit(@RequestBody SysComment sysComment) {
        this.sysCommentService.updateById(sysComment);
        return Result.OK((String)"\u7f16\u8f91\u6210\u529f!");
    }

    @ApiOperation(value="\u7cfb\u7edf\u8bc4\u8bba\u56de\u590d\u8868-\u901a\u8fc7id\u5220\u9664", notes="\u7cfb\u7edf\u8bc4\u8bba\u56de\u590d\u8868-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<String> delete(@RequestParam(name="id", required=true) String id) {
        this.sysCommentService.removeById((Serializable)((Object)id));
        return Result.OK((String)"\u5220\u9664\u6210\u529f!");
    }

    @ApiOperation(value="\u7cfb\u7edf\u8bc4\u8bba\u56de\u590d\u8868-\u6279\u91cf\u5220\u9664", notes="\u7cfb\u7edf\u8bc4\u8bba\u56de\u590d\u8868-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<String> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.sysCommentService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK((String)"\u6279\u91cf\u5220\u9664\u6210\u529f!");
    }

    @ApiOperation(value="\u7cfb\u7edf\u8bc4\u8bba\u56de\u590d\u8868-\u901a\u8fc7id\u67e5\u8be2", notes="\u7cfb\u7edf\u8bc4\u8bba\u56de\u590d\u8868-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<SysComment> queryById(@RequestParam(name="id", required=true) String id) {
        SysComment sysComment = (SysComment)this.sysCommentService.getById((Serializable)((Object)id));
        if (sysComment == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK((Object)sysComment);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, SysComment sysComment) {
        return super.exportXls(request, (Object)sysComment, SysComment.class, "\u7cfb\u7edf\u8bc4\u8bba\u56de\u590d\u8868");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, SysComment.class);
    }
}

