/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jeecg.dingtalk.api.core.response.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.CommonAPI;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.DateRangeUtils;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.modules.message.enums.RangeDateEnum;
import org.jeecg.modules.message.websocket.WebSocket;
import org.jeecg.modules.system.entity.SysAnnouncement;
import org.jeecg.modules.system.entity.SysAnnouncementSend;
import org.jeecg.modules.system.service.ISysAnnouncementSendService;
import org.jeecg.modules.system.service.ISysAnnouncementService;
import org.jeecg.modules.system.service.impl.SysBaseApiImpl;
import org.jeecg.modules.system.service.impl.ThirdAppDingtalkServiceImpl;
import org.jeecg.modules.system.service.impl.ThirdAppWechatEnterpriseServiceImpl;
import org.jeecg.modules.system.util.XssUtils;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/sys/annountCement"})
public class SysAnnouncementController {
    private static final Logger log = LoggerFactory.getLogger(SysAnnouncementController.class);
    @Autowired
    private ISysAnnouncementService sysAnnouncementService;
    @Autowired
    private ISysAnnouncementSendService sysAnnouncementSendService;
    @Resource
    private WebSocket webSocket;
    @Autowired
    ThirdAppWechatEnterpriseServiceImpl wechatEnterpriseService;
    @Autowired
    ThirdAppDingtalkServiceImpl dingtalkService;
    @Autowired
    private SysBaseApiImpl sysBaseApi;
    @Autowired
    @Lazy
    private RedisUtil redisUtil;
    @Autowired
    public RedisTemplate redisTemplate;
    public static ExecutorService cachedThreadPool = new ThreadPoolExecutor(0, 1024, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    public static ExecutorService completeNoteThreadPool = new ThreadPoolExecutor(0, 1024, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<IPage<SysAnnouncement>> queryPageList(SysAnnouncement sysAnnouncement, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            sysAnnouncement.setTenantId(oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0));
        }
        Result result = new Result();
        sysAnnouncement.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysAnnouncement, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysAnnouncementService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public Result<SysAnnouncement> add(@RequestBody SysAnnouncement sysAnnouncement) {
        Result result = new Result();
        try {
            String title = XssUtils.scriptXss(sysAnnouncement.getTitile());
            sysAnnouncement.setTitile(title);
            sysAnnouncement.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
            sysAnnouncement.setSendStatus("0");
            this.sysAnnouncementService.saveAnnouncement(sysAnnouncement);
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<SysAnnouncement> eidt(@RequestBody SysAnnouncement sysAnnouncement) {
        Result result = new Result();
        SysAnnouncement sysAnnouncementEntity = (SysAnnouncement)this.sysAnnouncementService.getById((Serializable)((Object)sysAnnouncement.getId()));
        if (sysAnnouncementEntity == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            String title = XssUtils.scriptXss(sysAnnouncement.getTitile());
            sysAnnouncement.setTitile(title);
            boolean ok = this.sysAnnouncementService.upDateAnnouncement(sysAnnouncement);
            if (ok) {
                result.success("\u4fee\u6539\u6210\u529f!");
            }
        }
        return result;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    public Result<SysAnnouncement> delete(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        SysAnnouncement sysAnnouncement = (SysAnnouncement)this.sysAnnouncementService.getById((Serializable)((Object)id));
        if (sysAnnouncement == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            sysAnnouncement.setDelFlag(CommonConstant.DEL_FLAG_1.toString());
            boolean ok = this.sysAnnouncementService.updateById(sysAnnouncement);
            if (ok) {
                result.success("\u5220\u9664\u6210\u529f!");
            }
        }
        return result;
    }

    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.DELETE})
    public Result<SysAnnouncement> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result result = new Result();
        if (ids == null || "".equals(ids.trim())) {
            result.error500("\u53c2\u6570\u4e0d\u8bc6\u522b\uff01");
        } else {
            String[] id = ids.split(",");
            for (int i = 0; i < id.length; ++i) {
                SysAnnouncement announcement = (SysAnnouncement)this.sysAnnouncementService.getById((Serializable)((Object)id[i]));
                announcement.setDelFlag(CommonConstant.DEL_FLAG_1.toString());
                this.sysAnnouncementService.updateById(announcement);
            }
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @RequestMapping(value={"/queryById"}, method={RequestMethod.GET})
    public Result<SysAnnouncement> queryById(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        SysAnnouncement sysAnnouncement = (SysAnnouncement)this.sysAnnouncementService.getById((Serializable)((Object)id));
        if (sysAnnouncement == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult((Object)sysAnnouncement);
            result.setSuccess(true);
        }
        return result;
    }

    @RequestMapping(value={"/doReleaseData"}, method={RequestMethod.GET})
    public Result<SysAnnouncement> doReleaseData(@RequestParam(name="id", required=true) String id, HttpServletRequest request) {
        Result result = new Result();
        SysAnnouncement sysAnnouncement = (SysAnnouncement)this.sysAnnouncementService.getById((Serializable)((Object)id));
        if (sysAnnouncement == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            sysAnnouncement.setSendStatus("1");
            sysAnnouncement.setSendTime(new Date());
            String currentUserName = JwtUtil.getUserNameByToken((HttpServletRequest)request);
            sysAnnouncement.setSender(currentUserName);
            boolean ok = this.sysAnnouncementService.updateById(sysAnnouncement);
            if (ok) {
                result.success("\u7cfb\u7edf\u901a\u77e5\u63a8\u9001\u6210\u529f");
                if (sysAnnouncement.getMsgType().equals("ALL")) {
                    this.sysAnnouncementService.batchInsertSysAnnouncementSend(sysAnnouncement.getId(), sysAnnouncement.getTenantId());
                    JSONObject obj = new JSONObject();
                    obj.put("cmd", (Object)"topic");
                    obj.put("msgId", (Object)sysAnnouncement.getId());
                    obj.put("msgTxt", (Object)sysAnnouncement.getTitile());
                    this.webSocket.sendMessage(obj.toJSONString());
                } else {
                    String userId = sysAnnouncement.getUserIds();
                    String[] userIds = userId.substring(0, userId.length() - 1).split(",");
                    String anntId = sysAnnouncement.getId();
                    Date refDate = new Date();
                    JSONObject obj = new JSONObject();
                    obj.put("cmd", (Object)"user");
                    obj.put("msgId", (Object)sysAnnouncement.getId());
                    obj.put("msgTxt", (Object)sysAnnouncement.getTitile());
                    this.webSocket.sendMessage(userIds, obj.toJSONString());
                }
                try {
                    Response<String> dtResponse = this.dingtalkService.sendActionCardMessage(sysAnnouncement, null, true);
                    this.wechatEnterpriseService.sendTextCardMessage(sysAnnouncement, true);
                    if (dtResponse != null && dtResponse.isSuccess()) {
                        String taskId = (String)dtResponse.getResult();
                        sysAnnouncement.setDtTaskId(taskId);
                        this.sysAnnouncementService.updateById(sysAnnouncement);
                    }
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65\u53d1\u9001\u7b2c\u4e09\u65b9APP\u6d88\u606f\u5931\u8d25\uff1a", (Throwable)e);
                }
            }
        }
        return result;
    }

    @RequestMapping(value={"/doReovkeData"}, method={RequestMethod.GET})
    public Result<SysAnnouncement> doReovkeData(@RequestParam(name="id", required=true) String id, HttpServletRequest request) {
        Result result = new Result();
        SysAnnouncement sysAnnouncement = (SysAnnouncement)this.sysAnnouncementService.getById((Serializable)((Object)id));
        if (sysAnnouncement == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            sysAnnouncement.setSendStatus("2");
            sysAnnouncement.setCancelTime(new Date());
            boolean ok = this.sysAnnouncementService.updateById(sysAnnouncement);
            if (ok) {
                result.success("\u8be5\u7cfb\u7edf\u901a\u77e5\u64a4\u9500\u6210\u529f");
                if (oConvertUtils.isNotEmpty((Object)sysAnnouncement.getDtTaskId())) {
                    try {
                        this.dingtalkService.recallMessage(sysAnnouncement.getDtTaskId());
                    }
                    catch (Exception e) {
                        log.error("\u7b2c\u4e09\u65b9APP\u64a4\u56de\u6d88\u606f\u5931\u8d25\uff1a", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    @RequestMapping(value={"/listByUser"}, method={RequestMethod.GET})
    public Result<Map<String, Object>> listByUser(@RequestParam(required=false, defaultValue="5") Integer pageSize, HttpServletRequest request) {
        long start = System.currentTimeMillis();
        Result result = new Result();
        HashMap<String, Object> sysMsgMap = new HashMap<String, Object>(5);
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String userId = sysUser.getId();
        Date lastMonthStartDay = DateRangeUtils.getLastMonthStartDay();
        log.info("-----\u67e5\u8be2\u8fd1\u4e24\u4e2a\u6708\u6536\u5230\u7684\u672a\u8bfb\u901a\u77e5-----\uff0c\u8fd12\u6708\u7684\u7b2c\u4e00\u5929\uff1a{}", (Object)lastMonthStartDay);
        Page<SysAnnouncement> anntMsgList = new Page<SysAnnouncement>(0L, (long)pageSize.intValue());
        anntMsgList = this.sysAnnouncementService.querySysCementPageByUserId(anntMsgList, userId, "1", null, lastMonthStartDay);
        sysMsgMap.put("anntMsgList", anntMsgList.getRecords());
        sysMsgMap.put("anntMsgTotal", anntMsgList.getTotal());
        log.info("begin \u83b7\u53d6\u7528\u6237\u8fd12\u4e2a\u6708\u7684\u7cfb\u7edf\u516c\u544a (\u901a\u77e5)" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        Page<SysAnnouncement> sysMsgList = new Page<SysAnnouncement>(0L, (long)pageSize.intValue());
        sysMsgList = this.sysAnnouncementService.querySysCementPageByUserId(sysMsgList, userId, "2", null, lastMonthStartDay);
        sysMsgMap.put("sysMsgList", sysMsgList.getRecords());
        sysMsgMap.put("sysMsgTotal", sysMsgList.getTotal());
        log.info("end \u83b7\u53d6\u7528\u62372\u4e2a\u6708\u7684\u7cfb\u7edf\u516c\u544a (\u7cfb\u7edf\u6d88\u606f)" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        result.setSuccess(true);
        result.setResult(sysMsgMap);
        return result;
    }

    @RequestMapping(value={"/getUnreadMessageCount"}, method={RequestMethod.GET})
    public Result<Integer> getUnreadMessageCount(@RequestParam(required=false, defaultValue="5") Integer pageSize, HttpServletRequest request) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String userId = sysUser.getId();
        Date lastMonthStartDay = DateRangeUtils.getLastMonthStartDay();
        log.info(" ------\u67e5\u8be2\u8fd1\u4e24\u4e2a\u6708\u6536\u5230\u7684\u672a\u8bfb\u901a\u77e5\u6d88\u606f\u6570\u91cf------\uff0c\u8fd12\u6708\u7684\u7b2c\u4e00\u5929\uff1a{}", (Object)lastMonthStartDay);
        Integer unreadMessageCount = this.sysAnnouncementService.getUnreadMessageCountByUserId(userId, lastMonthStartDay);
        return Result.ok((Object)unreadMessageCount);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(SysAnnouncement sysAnnouncement, HttpServletRequest request) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)sysAnnouncement);
        ModelAndView mv = new ModelAndView((View)new JeecgEntityExcelView());
        queryWrapper.eq(SysAnnouncement::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        List pageList = this.sysAnnouncementService.list((Wrapper)queryWrapper);
        mv.addObject("fileName", (Object)"\u7cfb\u7edf\u901a\u544a\u5217\u8868");
        mv.addObject("entity", SysAnnouncement.class);
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        mv.addObject("params", (Object)new ExportParams("\u7cfb\u7edf\u901a\u544a\u5217\u8868\u6570\u636e", "\u5bfc\u51fa\u4eba:" + user.getRealname(), "\u5bfc\u51fa\u4fe1\u606f"));
        mv.addObject("data", (Object)pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List listSysAnnouncements = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), SysAnnouncement.class, (ImportParams)params);
                for (SysAnnouncement sysAnnouncementExcel : listSysAnnouncements) {
                    if (sysAnnouncementExcel.getDelFlag() == null) {
                        sysAnnouncementExcel.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
                    }
                    this.sysAnnouncementService.save(sysAnnouncementExcel);
                }
                Result result = Result.ok((String)("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570\uff1a" + listSysAnnouncements.size()));
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/syncNotic"}, method={RequestMethod.GET})
    public Result<SysAnnouncement> syncNotic(@RequestParam(name="anntId", required=false) String anntId, HttpServletRequest request) {
        Result result = new Result();
        JSONObject obj = new JSONObject();
        if (StringUtils.isNotBlank((String)anntId)) {
            SysAnnouncement sysAnnouncement = (SysAnnouncement)this.sysAnnouncementService.getById((Serializable)((Object)anntId));
            if (sysAnnouncement == null) {
                result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
            } else if (sysAnnouncement.getMsgType().equals("ALL")) {
                obj.put("cmd", (Object)"topic");
                obj.put("msgId", (Object)sysAnnouncement.getId());
                obj.put("msgTxt", (Object)sysAnnouncement.getTitile());
                this.webSocket.sendMessage(obj.toJSONString());
            } else {
                String userId = sysAnnouncement.getUserIds();
                if (oConvertUtils.isNotEmpty((Object)userId)) {
                    String[] userIds = userId.substring(0, userId.length() - 1).split(",");
                    obj.put("cmd", (Object)"user");
                    obj.put("msgId", (Object)sysAnnouncement.getId());
                    obj.put("msgTxt", (Object)sysAnnouncement.getTitile());
                    this.webSocket.sendMessage(userIds, obj.toJSONString());
                }
            }
        } else {
            obj.put("cmd", (Object)"topic");
            obj.put("msgTxt", (Object)"\u6279\u91cf\u8bbe\u7f6e\u5df2\u8bfb");
            this.webSocket.sendMessage(obj.toJSONString());
        }
        return result;
    }

    @GetMapping(value={"/show/{id}"})
    public ModelAndView showContent(ModelAndView modelAndView, @PathVariable(value="id") String id, HttpServletRequest request) {
        SysAnnouncement announcement = (SysAnnouncement)this.sysAnnouncementService.getById((Serializable)((Object)id));
        if (announcement != null) {
            boolean tokenOk = false;
            try {
                tokenOk = TokenUtils.verifyToken((HttpServletRequest)request, (CommonAPI)this.sysBaseApi, (RedisUtil)this.redisUtil);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tokenOk || "1".equals(announcement.getSendStatus())) {
                modelAndView.addObject("data", (Object)announcement);
                modelAndView.setViewName("announcement/showContent");
                return modelAndView;
            }
        }
        modelAndView.setStatus(HttpStatus.NOT_FOUND);
        return modelAndView;
    }

    @RequestMapping(value={"/vue3List"}, method={RequestMethod.GET})
    public Result<List<SysAnnouncement>> vue3List(@RequestParam(name="fromUser", required=false) String fromUser, @RequestParam(name="starFlag", required=false) String starFlag, @RequestParam(name="rangeDateKey", required=false) String rangeDateKey, @RequestParam(name="beginDate", required=false) String beginDate, @RequestParam(name="endDate", required=false) String endDate, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        List<SysAnnouncement> ls;
        long calStartTime = System.currentTimeMillis();
        Date beginTime = null;
        Date endTime = null;
        if (RangeDateEnum.ZDY.getKey().equals(rangeDateKey)) {
            if (oConvertUtils.isNotEmpty((Object)beginDate)) {
                beginTime = DateUtils.parseDatetime((String)beginDate);
            }
            if (oConvertUtils.isNotEmpty((Object)endDate)) {
                endTime = DateUtils.parseDatetime((String)endDate);
            }
        } else {
            Date[] arr = RangeDateEnum.getRangeArray(rangeDateKey);
            if (arr != null) {
                beginTime = arr[0];
                endTime = arr[1];
            }
        }
        if (!CollectionUtils.isEmpty(ls = this.sysAnnouncementService.querySysMessageList(pageSize, pageNo, fromUser, starFlag, beginTime, endTime))) {
            String readed = "1";
            List annoceIdList = ls.stream().filter(item -> !readed.equals(item.getReadFlag())).map(item -> item.getId()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(annoceIdList)) {
                cachedThreadPool.execute(() -> this.sysAnnouncementService.updateReaded(annoceIdList));
            }
        }
        JSONObject obj = new JSONObject();
        obj.put("cmd", (Object)"user");
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        this.webSocket.sendMessage(sysUser.getId(), obj.toJSONString());
        long calEndTime = System.currentTimeMillis();
        long duration = calEndTime - calStartTime;
        System.out.println("\u8017\u65f6\uff1a" + duration + " \u6beb\u79d2");
        return Result.ok(ls);
    }

    @GetMapping(value={"/getLastAnnountTime"})
    public Result<Page<SysAnnouncementSend>> getLastAnnountTime(@RequestParam(name="userId") String userId) {
        Result result = new Result();
        String keyString = String.format("sys:cache:userinfo:user_last_annount_time::%s", userId);
        if (this.redisTemplate.hasKey((Object)keyString).booleanValue()) {
            log.info("[SysAnnouncementSend Redis] \u901a\u8fc7Redis\u7f13\u5b58\u67e5\u8be2\u7528\u6237\u6700\u540e\u4e00\u6b21\u6536\u5230\u7cfb\u7edf\u901a\u77e5\u65f6\u95f4\uff0cuserId={}", (Object)userId);
            Page pageList = (Page)this.redisTemplate.opsForValue().get((Object)keyString);
            result.setSuccess(true);
            result.setResult((Object)pageList);
            return result;
        }
        Page page = new Page(1L, 1L);
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysAnnouncementSend::getUserId, (Object)userId);
        query.ne(SysAnnouncementSend::getCreateTime, (Object)DateRangeUtils.getLastMonthStartDay());
        query.select((Object[])new SFunction[]{SysAnnouncementSend::getCreateTime});
        query.orderByDesc(SysAnnouncementSend::getCreateTime);
        Page pageList = (Page)this.sysAnnouncementSendService.page((IPage)page, (Wrapper)query);
        if (pageList != null && pageList.getSize() > 0L) {
            this.redisTemplate.opsForValue().set((Object)keyString, (Object)pageList, 3600L, TimeUnit.SECONDS);
        }
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @PostMapping(value={"/clearAllUnReadMessage"})
    public Result<String> clearAllUnReadMessage() {
        this.sysAnnouncementService.clearAllUnReadMessage();
        return Result.ok((String)"\u6e05\u9664\u672a\u8bfb\u6d88\u606f\u6210\u529f");
    }
}

