/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.monitor.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.monitor.domain.RedisInfo;
import org.jeecg.modules.monitor.exception.RedisConnectException;
import org.jeecg.modules.monitor.service.RedisService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service(value="redisService")
public class RedisServiceImpl
implements RedisService {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceImpl.class);
    @Resource
    private RedisConnectionFactory redisConnectionFactory;
    private static final String REDIS_MESSAGE = "3";
    private static final Map<String, List<Map<String, Object>>> REDIS_METRICS = new HashMap<String, List<Map<String, Object>>>(2);

    @Override
    public List<RedisInfo> getRedisInfo() throws RedisConnectException {
        Properties info = this.redisConnectionFactory.getConnection().info();
        ArrayList<RedisInfo> infoList = new ArrayList<RedisInfo>();
        RedisInfo redisInfo = null;
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            redisInfo = new RedisInfo();
            redisInfo.setKey(oConvertUtils.getString((Object)entry.getKey()));
            redisInfo.setValue(oConvertUtils.getString((Object)entry.getValue()));
            infoList.add(redisInfo);
        }
        return infoList;
    }

    @Override
    public Map<String, Object> getKeysSize() throws RedisConnectException {
        Long dbSize = this.redisConnectionFactory.getConnection().dbSize();
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("create_time", System.currentTimeMillis());
        map.put("dbSize", dbSize);
        log.debug("--getKeysSize--: " + ((Object)map).toString());
        return map;
    }

    @Override
    public Map<String, Object> getMemoryInfo() throws RedisConnectException {
        HashMap<String, Object> map = null;
        Properties info = this.redisConnectionFactory.getConnection().info();
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            String key = oConvertUtils.getString((Object)entry.getKey());
            if (!"used_memory".equals(key)) continue;
            map = new HashMap<String, Object>(5);
            map.put("used_memory", entry.getValue());
            map.put("create_time", System.currentTimeMillis());
        }
        log.debug("--getMemoryInfo--: " + ((Object)map).toString());
        return map;
    }

    @Override
    public Map<String, JSONArray> getMapForReport(String type) throws RedisConnectException {
        HashMap<String, JSONArray> mapJson = new HashMap<String, JSONArray>(5);
        JSONArray json = new JSONArray();
        if (REDIS_MESSAGE.equals(type)) {
            List<RedisInfo> redisInfo = this.getRedisInfo();
            for (RedisInfo info : redisInfo) {
                HashMap map = Maps.newHashMap();
                BeanMap beanMap = BeanMap.create((Object)info);
                for (Object key : beanMap.keySet()) {
                    map.put(key + "", beanMap.get(key));
                }
                json.add((Object)map);
            }
            mapJson.put("data", json);
            return mapJson;
        }
        int length = 5;
        for (int i = 0; i < length; ++i) {
            Map<String, Object> map;
            JSONObject jo = new JSONObject();
            if ("1".equals(type)) {
                map = this.getKeysSize();
                jo.put("value", map.get("dbSize"));
            } else {
                map = this.getMemoryInfo();
                Integer usedMemory = Integer.valueOf(map.get("used_memory").toString());
                jo.put("value", (Object)(usedMemory / 1000));
            }
            String createTime = DateUtil.formatTime((Date)DateUtil.date((long)((Long)map.get("create_time") - (long)((4 - i) * 1000))));
            jo.put("name", (Object)createTime);
            json.add((Object)jo);
        }
        mapJson.put("data", json);
        return mapJson;
    }

    @Override
    public Map<String, List<Map<String, Object>>> getMetricsHistory() {
        return REDIS_METRICS;
    }

    @Scheduled(fixedRate=60000L)
    public void recordCustomMetric() throws RedisConnectException {
        List<Object> list = new ArrayList();
        if (REDIS_METRICS.containsKey("dbSize")) {
            list = REDIS_METRICS.get("dbSize");
        } else {
            REDIS_METRICS.put("dbSize", list);
        }
        if (list.size() > 60) {
            list.remove(0);
        }
        list.add(this.getKeysSize());
        list = new ArrayList();
        if (REDIS_METRICS.containsKey("memory")) {
            list = REDIS_METRICS.get("memory");
        } else {
            REDIS_METRICS.put("memory", list);
        }
        if (list.size() > 60) {
            list.remove(0);
        }
        list.add(this.getMemoryInfo());
    }
}

