/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.monitor.controller;

import com.alibaba.fastjson.JSONArray;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.filechooser.FileSystemView;
import org.jeecg.common.api.vo.Result;
import org.jeecg.modules.monitor.domain.RedisInfo;
import org.jeecg.modules.monitor.service.RedisService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/actuator/redis"})
public class ActuatorRedisController {
    private static final Logger log = LoggerFactory.getLogger(ActuatorRedisController.class);
    @Autowired
    private RedisService redisService;

    @GetMapping(value={"/info"})
    public Result<?> getRedisInfo() throws Exception {
        List<RedisInfo> infoList = this.redisService.getRedisInfo();
        return Result.ok(infoList);
    }

    @GetMapping(value={"/metrics/history"})
    public Result<?> getMetricsHistory() throws Exception {
        Map<String, List<Map<String, Object>>> metricsHistory = this.redisService.getMetricsHistory();
        return Result.OK(metricsHistory);
    }

    @GetMapping(value={"/keysSize"})
    public Map<String, Object> getKeysSize() throws Exception {
        return this.redisService.getKeysSize();
    }

    @GetMapping(value={"/keysSizeForReport"})
    public Map<String, JSONArray> getKeysSizeReport() throws Exception {
        return this.redisService.getMapForReport("1");
    }

    @GetMapping(value={"/memoryForReport"})
    public Map<String, JSONArray> memoryForReport() throws Exception {
        return this.redisService.getMapForReport("2");
    }

    @GetMapping(value={"/infoForReport"})
    public Map<String, JSONArray> infoForReport() throws Exception {
        return this.redisService.getMapForReport("3");
    }

    @GetMapping(value={"/memoryInfo"})
    public Map<String, Object> getMemoryInfo() throws Exception {
        return this.redisService.getMemoryInfo();
    }

    @GetMapping(value={"/queryDiskInfo"})
    public Result<List<Map<String, Object>>> queryDiskInfo(HttpServletRequest request, HttpServletResponse response) {
        Result res = new Result();
        try {
            FileSystemView fsv = FileSystemView.getFileSystemView();
            File[] fs = File.listRoots();
            log.info("\u67e5\u8be2\u78c1\u76d8\u4fe1\u606f:" + fs.length + "\u4e2a");
            ArrayList list = new ArrayList();
            for (int i = 0; i < fs.length; ++i) {
                if (fs[i].getTotalSpace() == 0L) continue;
                HashMap<String, Object> map = new HashMap<String, Object>(5);
                map.put("name", fsv.getSystemDisplayName(fs[i]));
                map.put("max", fs[i].getTotalSpace());
                map.put("rest", fs[i].getFreeSpace());
                map.put("restPPT", (fs[i].getTotalSpace() - fs[i].getFreeSpace()) * 100L / fs[i].getTotalSpace());
                list.add(map);
                log.info(((Object)map).toString());
            }
            res.setResult(list);
            res.success("\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            res.error500("\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        return res;
    }
}

