/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.monitor.controller;

import cn.hutool.core.util.NumberUtil;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import org.jeecg.common.api.vo.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/actuator/memory"})
public class ActuatorMemoryController {
    private static final Logger log = LoggerFactory.getLogger(ActuatorMemoryController.class);

    @GetMapping(value={"/info"})
    public Result<?> getRedisInfo() {
        Runtime runtime = Runtime.getRuntime();
        HashMap<String, Number> result = new HashMap<String, Number>();
        result.put("memory.runtime.total", runtime.totalMemory());
        result.put("memory.runtime.used", runtime.freeMemory());
        result.put("memory.runtime.max", runtime.totalMemory() - runtime.freeMemory());
        result.put("memory.runtime.free", runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory());
        result.put("memory.runtime.usage", NumberUtil.div((float)(runtime.totalMemory() - runtime.freeMemory()), (float)runtime.totalMemory()));
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystemMXBean instanceof OperatingSystemMXBean) {
            OperatingSystemMXBean opBean = (OperatingSystemMXBean)operatingSystemMXBean;
            long totalPhysicalMemory = opBean.getTotalPhysicalMemorySize();
            long freePhysicalMemory = opBean.getFreePhysicalMemorySize();
            long usedPhysicalMemory = totalPhysicalMemory - freePhysicalMemory;
            result.put("memory.physical.total", totalPhysicalMemory);
            result.put("memory.physical.used", freePhysicalMemory);
            result.put("memory.physical.free", usedPhysicalMemory);
            result.put("memory.physical.usage", NumberUtil.div((float)usedPhysicalMemory, (float)totalPhysicalMemory));
        }
        return Result.ok(result);
    }
}

