/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.message.handle.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.ObjectUtils;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.StaticConfig;
import org.jeecg.modules.message.handle.ISendMsgHandle;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.mapper.SysUserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component(value="emailSendMsgHandle")
public class EmailSendMsgHandle
implements ISendMsgHandle {
    private static final Logger log = LoggerFactory.getLogger(EmailSendMsgHandle.class);
    static String emailFrom;
    @Autowired
    SysUserMapper sysUserMapper;
    @Autowired
    private RedisUtil redisUtil;
    private static final String realNameExp = "{REALNAME}";

    public static void setEmailFrom(String emailFrom) {
        EmailSendMsgHandle.emailFrom = emailFrom;
    }

    @Override
    public void sendMsg(String esReceiver, String esTitle, String esContent) {
        JavaMailSender mailSender = (JavaMailSender)SpringContextUtils.getBean((String)"mailSender");
        MimeMessage message = mailSender.createMimeMessage();
        MimeMessageHelper helper = null;
        if (oConvertUtils.isEmpty((Object)emailFrom)) {
            StaticConfig staticConfig = (StaticConfig)SpringContextUtils.getBean(StaticConfig.class);
            EmailSendMsgHandle.setEmailFrom(staticConfig.getEmailFrom());
        }
        try {
            helper = new MimeMessageHelper(message, true);
            helper.setFrom(emailFrom);
            helper.setTo(esReceiver);
            helper.setSubject(esTitle);
            helper.setText(esContent, true);
            mailSender.send(message);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendMessage(MessageDTO messageDTO) {
        Object[] arr = messageDTO.getToUser().split(",");
        LambdaQueryWrapper query = (LambdaQueryWrapper)new LambdaQueryWrapper().in(SysUser::getUsername, arr);
        List list = this.sysUserMapper.selectList((Wrapper)query);
        String content = messageDTO.getContent();
        String title = messageDTO.getTitle();
        for (SysUser user : list) {
            String email = user.getEmail();
            if (ObjectUtils.isEmpty((Object)email)) continue;
            content = this.replaceContent(user, content);
            log.info("\u90ae\u4ef6\u5185\u5bb9\uff1a" + content);
            this.sendMsg(email, title, content);
        }
        Set toEmailList = messageDTO.getToEmailList();
        if (toEmailList != null && toEmailList.size() > 0) {
            for (String email : toEmailList) {
                if (ObjectUtils.isEmpty((Object)email)) continue;
                log.info("\u90ae\u4ef6\u5185\u5bb9\uff1a" + content);
                this.sendMsg(email, title, content);
            }
        }
        this.sendMessageToCopyUser(messageDTO);
    }

    public void sendMessageToCopyUser(MessageDTO messageDTO) {
        String copyToUser = messageDTO.getCopyToUser();
        if (ObjectUtils.isNotEmpty((Object)copyToUser)) {
            LambdaQueryWrapper query = (LambdaQueryWrapper)new LambdaQueryWrapper().in(SysUser::getUsername, (Object[])copyToUser.split(","));
            List list = this.sysUserMapper.selectList((Wrapper)query);
            String content = messageDTO.getContent();
            String title = messageDTO.getTitle();
            for (SysUser user : list) {
                String email = user.getEmail();
                if (ObjectUtils.isEmpty((Object)email)) continue;
                content = this.replaceContent(user, content);
                log.info("\u90ae\u4ef6\u5185\u5bb9\uff1a" + content);
                this.sendEmail(email, content, title);
            }
            Set ccEmailList = messageDTO.getCcEmailList();
            if (ccEmailList != null && ccEmailList.size() > 0) {
                for (String email : ccEmailList) {
                    if (ObjectUtils.isEmpty((Object)email)) continue;
                    log.info("\u90ae\u4ef6\u5185\u5bb9\uff1a" + content);
                    this.sendEmail(email, content, title);
                }
            }
        }
    }

    private void sendEmail(String email, String content, String title) {
        JavaMailSender mailSender = (JavaMailSender)SpringContextUtils.getBean((String)"mailSender");
        MimeMessage message = mailSender.createMimeMessage();
        MimeMessageHelper helper = null;
        if (oConvertUtils.isEmpty((Object)emailFrom)) {
            StaticConfig staticConfig = (StaticConfig)SpringContextUtils.getBean(StaticConfig.class);
            EmailSendMsgHandle.setEmailFrom(staticConfig.getEmailFrom());
        }
        try {
            helper = new MimeMessageHelper(message, true);
            helper.setFrom(emailFrom);
            helper.setTo(email);
            helper.setCc(email);
            helper.setSubject(title);
            helper.setText(content, true);
            mailSender.send(message);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    private String replaceContent(SysUser user, String content) {
        if (content.indexOf(realNameExp) > 0) {
            content = content.replace("${REALNAME}", user.getRealname()).replace(realNameExp, user.getRealname());
        }
        if (content.indexOf("{LOGIN_TOKEN}") > 0) {
            String token = this.getToken(user);
            try {
                content = content.replace("{LOGIN_TOKEN}", URLEncoder.encode(token, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u90ae\u4ef6\u6d88\u606ftoken\u7f16\u7801\u5931\u8d25", (Object)e.getMessage());
            }
        }
        return content;
    }

    private String getToken(SysUser user) {
        String token = JwtUtil.sign((String)user.getUsername(), (String)user.getPassword());
        this.redisUtil.set("prefix_user_token:" + token, (Object)token);
        this.redisUtil.expire("prefix_user_token:" + token, 302400L);
        return token;
    }
}

