/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.aop;

import java.lang.reflect.Method;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.shiro.SecurityUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jeecg.common.api.dto.LogDTO;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.aop.TenantLog;
import org.jeecg.modules.base.service.BaseCommonService;
import org.jeecg.modules.system.entity.SysTenantPack;
import org.jeecg.modules.system.entity.SysTenantPackUser;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TenantPackUserLogAspect {
    @Resource
    private BaseCommonService baseCommonService;

    @Pointcut(value="@annotation(org.jeecg.modules.aop.TenantLog)")
    public void tenantLogPointCut() {
    }

    @Around(value="tenantLogPointCut()")
    public Object aroundMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        TenantLog log = method.getAnnotation(TenantLog.class);
        if (log != null) {
            int opType = log.value();
            Integer logType = null;
            String content = null;
            Integer tenantId = null;
            Object[] args = joinPoint.getArgs();
            if (args.length > 0) {
                for (Object obj : args) {
                    if (obj instanceof SysTenantPack) {
                        logType = 3;
                        SysTenantPack pack = (SysTenantPack)obj;
                        if (opType == 2) {
                            content = "\u521b\u5efa\u4e86\u89d2\u8272\u6743\u9650 " + pack.getPackName();
                        }
                        tenantId = pack.getTenantId();
                        break;
                    }
                    if (!(obj instanceof SysTenantPackUser)) continue;
                    logType = 3;
                    SysTenantPackUser packUser = (SysTenantPackUser)obj;
                    if (opType == 2) {
                        content = "\u5c06 " + packUser.getRealname() + " \u6dfb\u52a0\u5230\u89d2\u8272 " + packUser.getPackName();
                    } else if (opType == 4) {
                        content = "\u79fb\u9664\u4e86 " + packUser.getPackName() + " \u6210\u5458 " + packUser.getRealname();
                    }
                    tenantId = packUser.getTenantId();
                }
            }
            if (logType != null) {
                LogDTO dto = new LogDTO();
                dto.setLogType(logType);
                dto.setLogContent(content);
                dto.setOperateType(Integer.valueOf(opType));
                dto.setTenantId(tenantId);
                LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
                if (sysUser != null) {
                    dto.setUserid(sysUser.getUsername());
                    dto.setUsername(sysUser.getRealname());
                }
                dto.setCreateTime(new Date());
                this.baseCommonService.addLog(dto);
            }
        }
        return joinPoint.proceed();
    }

    @AfterThrowing(value="tenantLogPointCut()")
    public void afterThrowing() throws Throwable {
        System.out.println("\u5f02\u5e38\u901a\u77e5");
    }
}

