/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.jimureport;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.common.api.CommonAPI;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.SysUserCacheInfo;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.modules.jmreport.api.JmReportTokenServiceI;
import org.jeecg.modules.system.service.impl.SysBaseApiImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class JimuReportTokenService
implements JmReportTokenServiceI {
    private static final Logger log = LoggerFactory.getLogger(JimuReportTokenService.class);
    @Autowired
    private SysBaseApiImpl sysBaseApi;
    @Autowired
    @Lazy
    private RedisUtil redisUtil;

    public String getToken(HttpServletRequest request) {
        try {
            return TokenUtils.getTokenByRequest((HttpServletRequest)request);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getUsername(String token) {
        return JwtUtil.getUsername((String)token);
    }

    public String[] getRoles(String token) {
        String username = JwtUtil.getUsername((String)token);
        Set<String> roles = this.sysBaseApi.getUserRoleSet(username);
        if (CollectionUtils.isEmpty(roles)) {
            return null;
        }
        return roles.toArray(new String[roles.size()]);
    }

    public Boolean verifyToken(String token) {
        return TokenUtils.verifyToken((String)token, (CommonAPI)this.sysBaseApi, (RedisUtil)this.redisUtil);
    }

    public Map<String, Object> getUserInfo(String token) {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        String username = JwtUtil.getUsername((String)token);
        SysUserCacheInfo userInfo = null;
        try {
            userInfo = this.sysBaseApi.getCacheUser(username);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
            return map;
        }
        map.put("sysUserCode", userInfo.getSysUserCode());
        map.put("sysOrgCode", userInfo.getSysOrgCode());
        return map;
    }
}

