/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.service.impl;

import com.xxl.job.admin.core.cron.CronExpression;
import com.xxl.job.admin.core.model.XxlJobGroup;
import com.xxl.job.admin.core.model.XxlJobInfo;
import com.xxl.job.admin.core.model.XxlJobLogReport;
import com.xxl.job.admin.core.route.ExecutorRouteStrategyEnum;
import com.xxl.job.admin.core.util.I18nUtil;
import com.xxl.job.admin.dao.XxlJobGroupDao;
import com.xxl.job.admin.dao.XxlJobInfoDao;
import com.xxl.job.admin.dao.XxlJobLogDao;
import com.xxl.job.admin.dao.XxlJobLogGlueDao;
import com.xxl.job.admin.dao.XxlJobLogReportDao;
import com.xxl.job.admin.service.XxlJobService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;
import com.xxl.job.core.glue.GlueTypeEnum;
import com.xxl.job.core.util.DateUtil;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class XxlJobServiceImpl
implements XxlJobService {
    private static Logger logger = LoggerFactory.getLogger(XxlJobServiceImpl.class);
    @Resource
    private XxlJobGroupDao xxlJobGroupDao;
    @Resource
    private XxlJobInfoDao xxlJobInfoDao;
    @Resource
    public XxlJobLogDao xxlJobLogDao;
    @Resource
    private XxlJobLogGlueDao xxlJobLogGlueDao;
    @Resource
    private XxlJobLogReportDao xxlJobLogReportDao;

    public Map<String, Object> pageList(int start, int length, int jobGroup, int triggerStatus, String jobDesc, String executorHandler, String author) {
        List list = this.xxlJobInfoDao.pageList(start, length, jobGroup, triggerStatus, jobDesc, executorHandler, author);
        int list_count = this.xxlJobInfoDao.pageListCount(start, length, jobGroup, triggerStatus, jobDesc, executorHandler, author);
        HashMap<String, Object> maps = new HashMap<String, Object>();
        maps.put("recordsTotal", list_count);
        maps.put("recordsFiltered", list_count);
        maps.put("data", list);
        return maps;
    }

    public ReturnT<String> add(XxlJobInfo jobInfo) {
        XxlJobGroup group = this.xxlJobGroupDao.load(jobInfo.getJobGroup());
        if (group == null) {
            return new ReturnT(500, I18nUtil.getString((String)"system_please_choose") + I18nUtil.getString((String)"jobinfo_field_jobgroup"));
        }
        if (!CronExpression.isValidExpression((String)jobInfo.getJobCron())) {
            return new ReturnT(500, I18nUtil.getString((String)"jobinfo_field_cron_unvalid"));
        }
        if (jobInfo.getJobDesc() == null || jobInfo.getJobDesc().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString((String)"system_please_input") + I18nUtil.getString((String)"jobinfo_field_jobdesc"));
        }
        if (jobInfo.getAuthor() == null || jobInfo.getAuthor().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString((String)"system_please_input") + I18nUtil.getString((String)"jobinfo_field_author"));
        }
        if (ExecutorRouteStrategyEnum.match((String)jobInfo.getExecutorRouteStrategy(), null) == null) {
            return new ReturnT(500, I18nUtil.getString((String)"jobinfo_field_executorRouteStrategy") + I18nUtil.getString((String)"system_unvalid"));
        }
        if (ExecutorBlockStrategyEnum.match((String)jobInfo.getExecutorBlockStrategy(), null) == null) {
            return new ReturnT(500, I18nUtil.getString((String)"jobinfo_field_executorBlockStrategy") + I18nUtil.getString((String)"system_unvalid"));
        }
        if (GlueTypeEnum.match((String)jobInfo.getGlueType()) == null) {
            return new ReturnT(500, I18nUtil.getString((String)"jobinfo_field_gluetype") + I18nUtil.getString((String)"system_unvalid"));
        }
        if (GlueTypeEnum.BEAN == GlueTypeEnum.match((String)jobInfo.getGlueType()) && (jobInfo.getExecutorHandler() == null || jobInfo.getExecutorHandler().trim().length() == 0)) {
            return new ReturnT(500, I18nUtil.getString((String)"system_please_input") + "JobHandler");
        }
        if (GlueTypeEnum.GLUE_SHELL == GlueTypeEnum.match((String)jobInfo.getGlueType()) && jobInfo.getGlueSource() != null) {
            jobInfo.setGlueSource(jobInfo.getGlueSource().replaceAll("\r", ""));
        }
        if (jobInfo.getChildJobId() != null && jobInfo.getChildJobId().trim().length() > 0) {
            String[] childJobIds;
            for (String childJobIdItem : childJobIds = jobInfo.getChildJobId().split(",")) {
                if (childJobIdItem != null && childJobIdItem.trim().length() > 0 && this.isNumeric(childJobIdItem)) {
                    XxlJobInfo childJobInfo = this.xxlJobInfoDao.loadById(Integer.parseInt(childJobIdItem));
                    if (childJobInfo != null) continue;
                    return new ReturnT(500, MessageFormat.format(I18nUtil.getString((String)"jobinfo_field_childJobId") + "({0})" + I18nUtil.getString((String)"system_not_found"), childJobIdItem));
                }
                return new ReturnT(500, MessageFormat.format(I18nUtil.getString((String)"jobinfo_field_childJobId") + "({0})" + I18nUtil.getString((String)"system_unvalid"), childJobIdItem));
            }
            String temp = "";
            for (String item : childJobIds) {
                temp = temp + item + ",";
            }
            temp = temp.substring(0, temp.length() - 1);
            jobInfo.setChildJobId(temp);
        }
        jobInfo.setAddTime(new Date());
        jobInfo.setUpdateTime(new Date());
        jobInfo.setGlueUpdatetime(new Date());
        this.xxlJobInfoDao.save(jobInfo);
        if (jobInfo.getId() < 1) {
            return new ReturnT(500, I18nUtil.getString((String)"jobinfo_field_add") + I18nUtil.getString((String)"system_fail"));
        }
        return new ReturnT((Object)String.valueOf(jobInfo.getId()));
    }

    private boolean isNumeric(String str) {
        try {
            int result = Integer.valueOf(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public ReturnT<String> update(XxlJobInfo jobInfo) {
        XxlJobGroup jobGroup;
        if (!CronExpression.isValidExpression((String)jobInfo.getJobCron())) {
            return new ReturnT(500, I18nUtil.getString((String)"jobinfo_field_cron_unvalid"));
        }
        if (jobInfo.getJobDesc() == null || jobInfo.getJobDesc().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString((String)"system_please_input") + I18nUtil.getString((String)"jobinfo_field_jobdesc"));
        }
        if (jobInfo.getAuthor() == null || jobInfo.getAuthor().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString((String)"system_please_input") + I18nUtil.getString((String)"jobinfo_field_author"));
        }
        if (ExecutorRouteStrategyEnum.match((String)jobInfo.getExecutorRouteStrategy(), null) == null) {
            return new ReturnT(500, I18nUtil.getString((String)"jobinfo_field_executorRouteStrategy") + I18nUtil.getString((String)"system_unvalid"));
        }
        if (ExecutorBlockStrategyEnum.match((String)jobInfo.getExecutorBlockStrategy(), null) == null) {
            return new ReturnT(500, I18nUtil.getString((String)"jobinfo_field_executorBlockStrategy") + I18nUtil.getString((String)"system_unvalid"));
        }
        if (jobInfo.getChildJobId() != null && jobInfo.getChildJobId().trim().length() > 0) {
            String[] childJobIds;
            for (String childJobIdItem : childJobIds = jobInfo.getChildJobId().split(",")) {
                if (childJobIdItem != null && childJobIdItem.trim().length() > 0 && this.isNumeric(childJobIdItem)) {
                    XxlJobInfo childJobInfo = this.xxlJobInfoDao.loadById(Integer.parseInt(childJobIdItem));
                    if (childJobInfo != null) continue;
                    return new ReturnT(500, MessageFormat.format(I18nUtil.getString((String)"jobinfo_field_childJobId") + "({0})" + I18nUtil.getString((String)"system_not_found"), childJobIdItem));
                }
                return new ReturnT(500, MessageFormat.format(I18nUtil.getString((String)"jobinfo_field_childJobId") + "({0})" + I18nUtil.getString((String)"system_unvalid"), childJobIdItem));
            }
            String temp = "";
            for (String item : childJobIds) {
                temp = temp + item + ",";
            }
            temp = temp.substring(0, temp.length() - 1);
            jobInfo.setChildJobId(temp);
        }
        if ((jobGroup = this.xxlJobGroupDao.load(jobInfo.getJobGroup())) == null) {
            return new ReturnT(500, I18nUtil.getString((String)"jobinfo_field_jobgroup") + I18nUtil.getString((String)"system_unvalid"));
        }
        XxlJobInfo exists_jobInfo = this.xxlJobInfoDao.loadById(jobInfo.getId());
        if (exists_jobInfo == null) {
            return new ReturnT(500, I18nUtil.getString((String)"jobinfo_field_id") + I18nUtil.getString((String)"system_not_found"));
        }
        long nextTriggerTime = exists_jobInfo.getTriggerNextTime();
        if (exists_jobInfo.getTriggerStatus() == 1 && !jobInfo.getJobCron().equals(exists_jobInfo.getJobCron())) {
            try {
                Date nextValidTime = new CronExpression(jobInfo.getJobCron()).getNextValidTimeAfter(new Date(System.currentTimeMillis() + 5000L));
                if (nextValidTime == null) {
                    return new ReturnT(500, I18nUtil.getString((String)"jobinfo_field_cron_never_fire"));
                }
                nextTriggerTime = nextValidTime.getTime();
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return new ReturnT(500, I18nUtil.getString((String)"jobinfo_field_cron_unvalid") + " | " + e.getMessage());
            }
        }
        exists_jobInfo.setJobGroup(jobInfo.getJobGroup());
        exists_jobInfo.setJobCron(jobInfo.getJobCron());
        exists_jobInfo.setJobDesc(jobInfo.getJobDesc());
        exists_jobInfo.setAuthor(jobInfo.getAuthor());
        exists_jobInfo.setAlarmEmail(jobInfo.getAlarmEmail());
        exists_jobInfo.setExecutorRouteStrategy(jobInfo.getExecutorRouteStrategy());
        exists_jobInfo.setExecutorHandler(jobInfo.getExecutorHandler());
        exists_jobInfo.setExecutorParam(jobInfo.getExecutorParam());
        exists_jobInfo.setExecutorBlockStrategy(jobInfo.getExecutorBlockStrategy());
        exists_jobInfo.setExecutorTimeout(jobInfo.getExecutorTimeout());
        exists_jobInfo.setExecutorFailRetryCount(jobInfo.getExecutorFailRetryCount());
        exists_jobInfo.setChildJobId(jobInfo.getChildJobId());
        exists_jobInfo.setTriggerNextTime(nextTriggerTime);
        exists_jobInfo.setUpdateTime(new Date());
        this.xxlJobInfoDao.update(exists_jobInfo);
        return ReturnT.SUCCESS;
    }

    public ReturnT<String> remove(int id) {
        XxlJobInfo xxlJobInfo = this.xxlJobInfoDao.loadById(id);
        if (xxlJobInfo == null) {
            return ReturnT.SUCCESS;
        }
        this.xxlJobInfoDao.delete((long)id);
        this.xxlJobLogDao.delete(id);
        this.xxlJobLogGlueDao.deleteByJobId(id);
        return ReturnT.SUCCESS;
    }

    public ReturnT<String> start(int id) {
        XxlJobInfo xxlJobInfo = this.xxlJobInfoDao.loadById(id);
        long nextTriggerTime = 0L;
        try {
            Date nextValidTime = new CronExpression(xxlJobInfo.getJobCron()).getNextValidTimeAfter(new Date(System.currentTimeMillis() + 5000L));
            if (nextValidTime == null) {
                return new ReturnT(500, I18nUtil.getString((String)"jobinfo_field_cron_never_fire"));
            }
            nextTriggerTime = nextValidTime.getTime();
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ReturnT(500, I18nUtil.getString((String)"jobinfo_field_cron_unvalid") + " | " + e.getMessage());
        }
        xxlJobInfo.setTriggerStatus(1);
        xxlJobInfo.setTriggerLastTime(0L);
        xxlJobInfo.setTriggerNextTime(nextTriggerTime);
        xxlJobInfo.setUpdateTime(new Date());
        this.xxlJobInfoDao.update(xxlJobInfo);
        return ReturnT.SUCCESS;
    }

    public ReturnT<String> stop(int id) {
        XxlJobInfo xxlJobInfo = this.xxlJobInfoDao.loadById(id);
        xxlJobInfo.setTriggerStatus(0);
        xxlJobInfo.setTriggerLastTime(0L);
        xxlJobInfo.setTriggerNextTime(0L);
        xxlJobInfo.setUpdateTime(new Date());
        this.xxlJobInfoDao.update(xxlJobInfo);
        return ReturnT.SUCCESS;
    }

    public Map<String, Object> dashboardInfo() {
        int jobInfoCount = this.xxlJobInfoDao.findAllCount();
        int jobLogCount = 0;
        int jobLogSuccessCount = 0;
        XxlJobLogReport xxlJobLogReport = this.xxlJobLogReportDao.queryLogReportTotal();
        if (xxlJobLogReport != null) {
            jobLogCount = xxlJobLogReport.getRunningCount() + xxlJobLogReport.getSucCount() + xxlJobLogReport.getFailCount();
            jobLogSuccessCount = xxlJobLogReport.getSucCount();
        }
        HashSet executorAddressSet = new HashSet();
        List groupList = this.xxlJobGroupDao.findAll();
        if (groupList != null && !groupList.isEmpty()) {
            for (XxlJobGroup group : groupList) {
                if (group.getRegistryList() == null || group.getRegistryList().isEmpty()) continue;
                executorAddressSet.addAll(group.getRegistryList());
            }
        }
        int executorCount = executorAddressSet.size();
        HashMap<String, Object> dashboardMap = new HashMap<String, Object>();
        dashboardMap.put("jobInfoCount", jobInfoCount);
        dashboardMap.put("jobLogCount", jobLogCount);
        dashboardMap.put("jobLogSuccessCount", jobLogSuccessCount);
        dashboardMap.put("executorCount", executorCount);
        return dashboardMap;
    }

    public ReturnT<Map<String, Object>> chartInfo(Date startDate, Date endDate) {
        ArrayList<String> triggerDayList = new ArrayList<String>();
        ArrayList<Integer> triggerDayCountRunningList = new ArrayList<Integer>();
        ArrayList<Integer> triggerDayCountSucList = new ArrayList<Integer>();
        ArrayList<Integer> triggerDayCountFailList = new ArrayList<Integer>();
        int triggerCountRunningTotal = 0;
        int triggerCountSucTotal = 0;
        int triggerCountFailTotal = 0;
        List logReportList = this.xxlJobLogReportDao.queryLogReport(startDate, endDate);
        if (logReportList != null && logReportList.size() > 0) {
            for (XxlJobLogReport item : logReportList) {
                String day = DateUtil.formatDate((Date)item.getTriggerDay());
                int triggerDayCountRunning = item.getRunningCount();
                int triggerDayCountSuc = item.getSucCount();
                int triggerDayCountFail = item.getFailCount();
                triggerDayList.add(day);
                triggerDayCountRunningList.add(triggerDayCountRunning);
                triggerDayCountSucList.add(triggerDayCountSuc);
                triggerDayCountFailList.add(triggerDayCountFail);
                triggerCountRunningTotal += triggerDayCountRunning;
                triggerCountSucTotal += triggerDayCountSuc;
                triggerCountFailTotal += triggerDayCountFail;
            }
        } else {
            for (int i = -6; i <= 0; ++i) {
                triggerDayList.add(DateUtil.formatDate((Date)DateUtil.addDays((Date)new Date(), (int)i)));
                triggerDayCountRunningList.add(0);
                triggerDayCountSucList.add(0);
                triggerDayCountFailList.add(0);
            }
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("triggerDayList", triggerDayList);
        result.put("triggerDayCountRunningList", triggerDayCountRunningList);
        result.put("triggerDayCountSucList", triggerDayCountSucList);
        result.put("triggerDayCountFailList", triggerDayCountFailList);
        result.put("triggerCountRunningTotal", Integer.valueOf(triggerCountRunningTotal));
        result.put("triggerCountSucTotal", Integer.valueOf(triggerCountSucTotal));
        result.put("triggerCountFailTotal", Integer.valueOf(triggerCountFailTotal));
        return new ReturnT(result);
    }
}

