/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.core.scheduler;

import com.xxl.job.admin.core.conf.XxlJobAdminConfig;
import com.xxl.job.admin.core.thread.JobFailMonitorHelper;
import com.xxl.job.admin.core.thread.JobLogReportHelper;
import com.xxl.job.admin.core.thread.JobLosedMonitorHelper;
import com.xxl.job.admin.core.thread.JobRegistryMonitorHelper;
import com.xxl.job.admin.core.thread.JobScheduleHelper;
import com.xxl.job.admin.core.thread.JobTriggerPoolHelper;
import com.xxl.job.admin.core.util.I18nUtil;
import com.xxl.job.core.biz.ExecutorBiz;
import com.xxl.job.core.biz.client.ExecutorBizClient;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlJobScheduler {
    private static final Logger logger = LoggerFactory.getLogger(XxlJobScheduler.class);
    private static ConcurrentMap<String, ExecutorBiz> executorBizRepository = new ConcurrentHashMap();

    public void init() throws Exception {
        this.initI18n();
        JobRegistryMonitorHelper.getInstance().start();
        JobFailMonitorHelper.getInstance().start();
        JobLosedMonitorHelper.getInstance().start();
        JobTriggerPoolHelper.toStart();
        JobLogReportHelper.getInstance().start();
        JobScheduleHelper.getInstance().start();
        logger.info(">>>>>>>>> init xxl-job admin success.");
    }

    public void destroy() throws Exception {
        JobScheduleHelper.getInstance().toStop();
        JobLogReportHelper.getInstance().toStop();
        JobTriggerPoolHelper.toStop();
        JobLosedMonitorHelper.getInstance().toStop();
        JobFailMonitorHelper.getInstance().toStop();
        JobRegistryMonitorHelper.getInstance().toStop();
    }

    private void initI18n() {
        for (ExecutorBlockStrategyEnum item : ExecutorBlockStrategyEnum.values()) {
            item.setTitle(I18nUtil.getString((String)"jobconf_block_".concat(item.name())));
        }
    }

    public static ExecutorBiz getExecutorBiz(String address) throws Exception {
        if (address == null || address.trim().length() == 0) {
            return null;
        }
        ExecutorBiz executorBiz = (ExecutorBiz)executorBizRepository.get(address = address.trim());
        if (executorBiz != null) {
            return executorBiz;
        }
        executorBiz = new ExecutorBizClient(address, XxlJobAdminConfig.getAdminConfig().getAccessToken());
        executorBizRepository.put(address, executorBiz);
        return executorBiz;
    }
}

