/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.controller;

import com.xxl.job.admin.controller.annotation.PermissionLimit;
import com.xxl.job.admin.core.model.XxlJobUser;
import com.xxl.job.admin.core.util.I18nUtil;
import com.xxl.job.admin.dao.XxlJobGroupDao;
import com.xxl.job.admin.dao.XxlJobUserDao;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/user"})
public class UserController {
    @Resource
    private XxlJobUserDao xxlJobUserDao;
    @Resource
    private XxlJobGroupDao xxlJobGroupDao;

    @RequestMapping
    @PermissionLimit(adminuser=true)
    public String index(Model model) {
        List groupList = this.xxlJobGroupDao.findAll();
        model.addAttribute("groupList", (Object)groupList);
        return "user/user.index";
    }

    @RequestMapping(value={"/pageList"})
    @ResponseBody
    @PermissionLimit(adminuser=true)
    public Map<String, Object> pageList(@RequestParam(required=false, defaultValue="0") int start, @RequestParam(required=false, defaultValue="10") int length, String username, int role) {
        List list = this.xxlJobUserDao.pageList(start, length, username, role);
        int list_count = this.xxlJobUserDao.pageListCount(start, length, username, role);
        HashMap<String, Object> maps = new HashMap<String, Object>();
        maps.put("recordsTotal", list_count);
        maps.put("recordsFiltered", list_count);
        maps.put("data", list);
        return maps;
    }

    @RequestMapping(value={"/add"})
    @ResponseBody
    @PermissionLimit(adminuser=true)
    public ReturnT<String> add(XxlJobUser xxlJobUser) {
        if (!StringUtils.hasText((String)xxlJobUser.getUsername())) {
            return new ReturnT(500, I18nUtil.getString((String)"system_please_input") + I18nUtil.getString((String)"user_username"));
        }
        xxlJobUser.setUsername(xxlJobUser.getUsername().trim());
        if (xxlJobUser.getUsername().length() < 4 || xxlJobUser.getUsername().length() > 20) {
            return new ReturnT(500, I18nUtil.getString((String)"system_lengh_limit") + "[4-20]");
        }
        if (!StringUtils.hasText((String)xxlJobUser.getPassword())) {
            return new ReturnT(500, I18nUtil.getString((String)"system_please_input") + I18nUtil.getString((String)"user_password"));
        }
        xxlJobUser.setPassword(xxlJobUser.getPassword().trim());
        if (xxlJobUser.getPassword().length() < 4 || xxlJobUser.getPassword().length() > 20) {
            return new ReturnT(500, I18nUtil.getString((String)"system_lengh_limit") + "[4-20]");
        }
        xxlJobUser.setPassword(DigestUtils.md5DigestAsHex((byte[])xxlJobUser.getPassword().getBytes()));
        XxlJobUser existUser = this.xxlJobUserDao.loadByUserName(xxlJobUser.getUsername());
        if (existUser != null) {
            return new ReturnT(500, I18nUtil.getString((String)"user_username_repeat"));
        }
        this.xxlJobUserDao.save(xxlJobUser);
        return ReturnT.SUCCESS;
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    @PermissionLimit(adminuser=true)
    public ReturnT<String> update(HttpServletRequest request, XxlJobUser xxlJobUser) {
        XxlJobUser loginUser = (XxlJobUser)request.getAttribute("XXL_JOB_LOGIN_IDENTITY");
        if (loginUser.getUsername().equals(xxlJobUser.getUsername())) {
            return new ReturnT(ReturnT.FAIL.getCode(), I18nUtil.getString((String)"user_update_loginuser_limit"));
        }
        if (StringUtils.hasText((String)xxlJobUser.getPassword())) {
            xxlJobUser.setPassword(xxlJobUser.getPassword().trim());
            if (xxlJobUser.getPassword().length() < 4 || xxlJobUser.getPassword().length() > 20) {
                return new ReturnT(500, I18nUtil.getString((String)"system_lengh_limit") + "[4-20]");
            }
            xxlJobUser.setPassword(DigestUtils.md5DigestAsHex((byte[])xxlJobUser.getPassword().getBytes()));
        } else {
            xxlJobUser.setPassword(null);
        }
        this.xxlJobUserDao.update(xxlJobUser);
        return ReturnT.SUCCESS;
    }

    @RequestMapping(value={"/remove"})
    @ResponseBody
    @PermissionLimit(adminuser=true)
    public ReturnT<String> remove(HttpServletRequest request, int id) {
        XxlJobUser loginUser = (XxlJobUser)request.getAttribute("XXL_JOB_LOGIN_IDENTITY");
        if (loginUser.getId() == id) {
            return new ReturnT(ReturnT.FAIL.getCode(), I18nUtil.getString((String)"user_update_loginuser_limit"));
        }
        this.xxlJobUserDao.delete(id);
        return ReturnT.SUCCESS;
    }

    @RequestMapping(value={"/updatePwd"})
    @ResponseBody
    public ReturnT<String> updatePwd(HttpServletRequest request, String password) {
        if (password == null || password.trim().length() == 0) {
            return new ReturnT(ReturnT.FAIL.getCode(), "\u5bc6\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if ((password = password.trim()).length() < 4 || password.length() > 20) {
            return new ReturnT(500, I18nUtil.getString((String)"system_lengh_limit") + "[4-20]");
        }
        String md5Password = DigestUtils.md5DigestAsHex((byte[])password.getBytes());
        XxlJobUser loginUser = (XxlJobUser)request.getAttribute("XXL_JOB_LOGIN_IDENTITY");
        XxlJobUser existUser = this.xxlJobUserDao.loadByUserName(loginUser.getUsername());
        existUser.setPassword(md5Password);
        this.xxlJobUserDao.update(existUser);
        return ReturnT.SUCCESS;
    }
}

