/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.controller;

import com.xxl.job.admin.core.cron.CronExpression;
import com.xxl.job.admin.core.exception.XxlJobException;
import com.xxl.job.admin.core.model.XxlJobGroup;
import com.xxl.job.admin.core.model.XxlJobInfo;
import com.xxl.job.admin.core.model.XxlJobUser;
import com.xxl.job.admin.core.route.ExecutorRouteStrategyEnum;
import com.xxl.job.admin.core.thread.JobTriggerPoolHelper;
import com.xxl.job.admin.core.trigger.TriggerTypeEnum;
import com.xxl.job.admin.core.util.I18nUtil;
import com.xxl.job.admin.dao.XxlJobGroupDao;
import com.xxl.job.admin.service.XxlJobService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;
import com.xxl.job.core.glue.GlueTypeEnum;
import com.xxl.job.core.util.DateUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/jobinfo"})
public class JobInfoController {
    @Resource
    private XxlJobGroupDao xxlJobGroupDao;
    @Resource
    private XxlJobService xxlJobService;

    @RequestMapping
    public String index(HttpServletRequest request, Model model, @RequestParam(required=false, defaultValue="-1") int jobGroup) {
        model.addAttribute("ExecutorRouteStrategyEnum", (Object)ExecutorRouteStrategyEnum.values());
        model.addAttribute("GlueTypeEnum", (Object)GlueTypeEnum.values());
        model.addAttribute("ExecutorBlockStrategyEnum", (Object)ExecutorBlockStrategyEnum.values());
        List jobGroupList_all = this.xxlJobGroupDao.findAll();
        List jobGroupList = JobInfoController.filterJobGroupByRole((HttpServletRequest)request, (List)jobGroupList_all);
        if (jobGroupList == null || jobGroupList.size() == 0) {
            throw new XxlJobException(I18nUtil.getString((String)"jobgroup_empty"));
        }
        model.addAttribute("JobGroupList", (Object)jobGroupList);
        model.addAttribute("jobGroup", (Object)jobGroup);
        return "jobinfo/jobinfo.index";
    }

    public static List<XxlJobGroup> filterJobGroupByRole(HttpServletRequest request, List<XxlJobGroup> jobGroupList_all) {
        List<XxlJobGroup> jobGroupList = new ArrayList<XxlJobGroup>();
        if (jobGroupList_all != null && jobGroupList_all.size() > 0) {
            XxlJobUser loginUser = (XxlJobUser)request.getAttribute("XXL_JOB_LOGIN_IDENTITY");
            if (loginUser.getRole() == 1) {
                jobGroupList = jobGroupList_all;
            } else {
                List<Object> groupIdStrs = new ArrayList();
                if (loginUser.getPermission() != null && loginUser.getPermission().trim().length() > 0) {
                    groupIdStrs = Arrays.asList(loginUser.getPermission().trim().split(","));
                }
                for (XxlJobGroup groupItem : jobGroupList_all) {
                    if (!groupIdStrs.contains(String.valueOf(groupItem.getId()))) continue;
                    jobGroupList.add(groupItem);
                }
            }
        }
        return jobGroupList;
    }

    public static void validPermission(HttpServletRequest request, int jobGroup) {
        XxlJobUser loginUser = (XxlJobUser)request.getAttribute("XXL_JOB_LOGIN_IDENTITY");
        if (!loginUser.validPermission(jobGroup)) {
            throw new RuntimeException(I18nUtil.getString((String)"system_permission_limit") + "[username=" + loginUser.getUsername() + "]");
        }
    }

    @RequestMapping(value={"/pageList"})
    @ResponseBody
    public Map<String, Object> pageList(@RequestParam(required=false, defaultValue="0") int start, @RequestParam(required=false, defaultValue="10") int length, int jobGroup, int triggerStatus, String jobDesc, String executorHandler, String author) {
        return this.xxlJobService.pageList(start, length, jobGroup, triggerStatus, jobDesc, executorHandler, author);
    }

    @RequestMapping(value={"/add"})
    @ResponseBody
    public ReturnT<String> add(XxlJobInfo jobInfo) {
        return this.xxlJobService.add(jobInfo);
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    public ReturnT<String> update(XxlJobInfo jobInfo) {
        return this.xxlJobService.update(jobInfo);
    }

    @RequestMapping(value={"/remove"})
    @ResponseBody
    public ReturnT<String> remove(int id) {
        return this.xxlJobService.remove(id);
    }

    @RequestMapping(value={"/stop"})
    @ResponseBody
    public ReturnT<String> pause(int id) {
        return this.xxlJobService.stop(id);
    }

    @RequestMapping(value={"/start"})
    @ResponseBody
    public ReturnT<String> start(int id) {
        return this.xxlJobService.start(id);
    }

    @RequestMapping(value={"/trigger"})
    @ResponseBody
    public ReturnT<String> triggerJob(int id, String executorParam, String addressList) {
        if (executorParam == null) {
            executorParam = "";
        }
        JobTriggerPoolHelper.trigger((int)id, (TriggerTypeEnum)TriggerTypeEnum.MANUAL, (int)-1, null, (String)executorParam, (String)addressList);
        return ReturnT.SUCCESS;
    }

    @RequestMapping(value={"/nextTriggerTime"})
    @ResponseBody
    public ReturnT<List<String>> nextTriggerTime(String cron) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            CronExpression cronExpression = new CronExpression(cron);
            Date lastTime = new Date();
            for (int i = 0; i < 5 && (lastTime = cronExpression.getNextValidTimeAfter(lastTime)) != null; ++i) {
                result.add(DateUtil.formatDateTime((Date)lastTime));
            }
        }
        catch (ParseException e) {
            return new ReturnT(500, I18nUtil.getString((String)"jobinfo_field_cron_unvalid"));
        }
        return new ReturnT(result);
    }
}

