/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.test.seata.account.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import io.seata.core.context.RootContext;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.jeecg.modules.test.seata.account.entity.SeataAccount;
import org.jeecg.modules.test.seata.account.mapper.SeataAccountMapper;
import org.jeecg.modules.test.seata.account.service.SeataAccountService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SeataAccountServiceImpl
implements SeataAccountService {
    private static final Logger log = LoggerFactory.getLogger(SeataAccountServiceImpl.class);
    @Resource
    private SeataAccountMapper accountMapper;

    @Override
    @DS(value="account")
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void reduceBalance(Long userId, BigDecimal amount) {
        log.info("xid:" + RootContext.getXID());
        log.info("=============ACCOUNT START=================");
        SeataAccount account = (SeataAccount)this.accountMapper.selectById(userId);
        Assert.notNull((Object)account, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        BigDecimal balance = account.getBalance();
        log.info("\u4e0b\u5355\u7528\u6237{}\u4f59\u989d\u4e3a {},\u5546\u54c1\u603b\u4ef7\u4e3a{}", new Object[]{userId, balance, amount});
        if (balance.compareTo(amount) == -1) {
            log.warn("\u7528\u6237 {} \u4f59\u989d\u4e0d\u8db3\uff0c\u5f53\u524d\u4f59\u989d:{}", (Object)userId, (Object)balance);
            throw new RuntimeException("\u4f59\u989d\u4e0d\u8db3");
        }
        log.info("\u5f00\u59cb\u6263\u51cf\u7528\u6237 {} \u4f59\u989d", (Object)userId);
        BigDecimal currentBalance = account.getBalance().subtract(amount);
        account.setBalance(currentBalance);
        this.accountMapper.updateById(account);
        log.info("\u6263\u51cf\u7528\u6237 {} \u4f59\u989d\u6210\u529f,\u6263\u51cf\u540e\u7528\u6237\u8d26\u6237\u4f59\u989d\u4e3a{}", (Object)userId, (Object)currentBalance);
        log.info("=============ACCOUNT END=================");
    }
}

