/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.flyway;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import java.util.Map;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class FlywayConfig {
    private static final Logger log = LoggerFactory.getLogger(FlywayConfig.class);
    @Autowired
    private DataSource dataSource;
    @Autowired
    private Environment environment;
    @Value(value="${spring.flyway.enabled:false}")
    private Boolean enabled;
    @Value(value="${spring.flyway.encoding:UTF-8}")
    private String encoding;
    @Value(value="${spring.flyway.locations:classpath:flyway/sql/mysql}")
    private String locations;
    @Value(value="${spring.flyway.sql-migration-prefix:V}")
    private String sqlMigrationPrefix;
    @Value(value="${spring.flyway.sql-migration-separator:__}")
    private String sqlMigrationSeparator;
    @Value(value="${spring.flyway.placeholder-prefix:#(}")
    private String placeholderPrefix;
    @Value(value="${spring.flyway.placeholder-suffix:)}")
    private String placeholderSuffix;
    @Value(value="${spring.flyway.sql-migration-suffixes:.sql}")
    private String sqlMigrationSuffixes;
    @Value(value="${spring.flyway.validate-on-migrate:true}")
    private Boolean validateOnMigrate;
    @Value(value="${spring.flyway.baseline-on-migrate:true}")
    private Boolean baselineOnMigrate;
    @Value(value="${spring.flyway.clean-disabled:true}")
    private Boolean cleanDisabled;

    @Bean
    public void migrate() {
        if (!this.enabled.booleanValue()) {
            return;
        }
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        Map dataSources = ds.getDataSources();
        dataSources.forEach((k, v) -> {
            if ("master".equals(k)) {
                String databaseType = this.environment.getProperty("spring.datasource.dynamic.datasource." + k + ".url");
                if (databaseType != null && databaseType.contains("mysql")) {
                    try {
                        Flyway flyway = Flyway.configure().dataSource(v).locations(new String[]{this.locations}).encoding(this.encoding).sqlMigrationPrefix(this.sqlMigrationPrefix).sqlMigrationSeparator(this.sqlMigrationSeparator).placeholderPrefix(this.placeholderPrefix).placeholderSuffix(this.placeholderSuffix).sqlMigrationSuffixes(new String[]{this.sqlMigrationSuffixes}).validateOnMigrate(this.validateOnMigrate.booleanValue()).baselineOnMigrate(this.baselineOnMigrate.booleanValue()).cleanDisabled(this.cleanDisabled.booleanValue()).load();
                        flyway.migrate();
                        log.info("\u3010\u6570\u636e\u5e93\u5347\u7ea7\u3011\u5e73\u53f0\u96c6\u6210\u4e86MySQL\u5e93\u7684Flyway\uff0c\u6570\u636e\u5e93\u7248\u672c\u81ea\u52a8\u5347\u7ea7! ");
                    }
                    catch (FlywayException e) {
                        log.error("\u3010\u6570\u636e\u5e93\u5347\u7ea7\u3011flyway\u6267\u884csql\u811a\u672c\u5931\u8d25", (Throwable)e);
                    }
                } else {
                    log.warn("\u3010\u6570\u636e\u5e93\u5347\u7ea7\u3011\u5e73\u53f0\u53ea\u96c6\u6210\u4e86MySQL\u5e93\u7684Flyway\uff0c\u5b9e\u73b0\u4e86\u6570\u636e\u5e93\u7248\u672c\u81ea\u52a8\u5347\u7ea7! \u5176\u4ed6\u7c7b\u578b\u7684\u6570\u636e\u5e93\uff0c\u60a8\u53ef\u4ee5\u8003\u8651\u624b\u5de5\u5347\u7ea7~");
                }
            }
        });
    }
}

