/*
 * Decompiled with CFR 0.152.
 */
package com.simba.web.service.services;

import com.simba.common.socket.framework.annotation.NetJsonService;
import com.simba.common.socket.framework.base.service.JsonService;
import com.simba.services.ScreenService;
import com.simba.services.SlotService;
import com.simba.services.SortInfoService;
import com.simba.services.beans.SortInfo;
import com.simba.web.service.config.EwmMsgTools;
import java.util.List;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

@NetJsonService(managerNames={"ewmJsonServiceManager"})
public class WtEwmService
implements JsonService {
    private static final Logger log = LoggerFactory.getLogger(WtEwmService.class);
    private final SortInfoService sortInfoService;
    private final SlotService slotService;
    private final ScreenService screenService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public String getName() {
        return "WT";
    }

    public void handleRequest(Channel channel, Object content, String routeKey) {
        if (!(content instanceof List)) {
            return;
        }
        List list = (List)content;
        if (list.size() < 8) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\u53d1\u5c04\u673a: ").append((String)list.get(0)).append(", ");
        builder.append("\u6536\u4ef6\u4eba: ").append((String)list.get(1)).append(", ");
        builder.append("\u901a\u4fe1\u70b9: ").append((String)list.get(2)).append(", ");
        builder.append("\u63e1\u624b: ").append((String)list.get(3)).append(", ");
        String strWt = (String)list.get(4);
        builder.append("\u7535\u62a5\u53f7\u7801: ").append(strWt).append(", ");
        builder.append("\u65b9\u6848\u9519\u8bef: ").append((String)list.get(5)).append(", ");
        builder.append("\u7535\u62a5\u7c7b\u578b: ").append((String)list.get(6)).append(", ");
        String msg = (String)list.get(7);
        int cursor = 0;
        String objectNumber = EwmMsgTools.parseItem((String)msg, (int)cursor, (int)(cursor + 20));
        builder.append("\u5bf9\u8c61\u7f16\u53f7: ").append(objectNumber).append(", ");
        String source = EwmMsgTools.parseItem((String)msg, (int)(cursor += 20), (int)(cursor + 18));
        builder.append("\u6765\u6e90: ").append(source).append(", ");
        String appointment = EwmMsgTools.parseItem((String)msg, (int)(cursor += 18), (int)(cursor + 18));
        builder.append("\u4efb\u547d: ").append(appointment).append(", ");
        String objectPIKNumber = EwmMsgTools.parseItem((String)msg, (int)(cursor += 18), (int)(cursor + 10));
        builder.append("\u5bf9\u8c61PIK\u7f16\u53f7: ").append(objectPIKNumber).append(";");
        log.info("WT barcode{},objectPIKNumber{},appointment, Info {}", new Object[]{objectNumber, objectPIKNumber, appointment});
        this.setPlotInfo(appointment, objectPIKNumber, objectNumber);
        StringBuilder request = new StringBuilder();
        request.append("WCS_M_SSSAPEWM^^^^^^^^^^^^^^^^^^^^A^");
        request.append(strWt);
        request.append("^^^^WT^^");
        String barcodeStr = EwmMsgTools.fillItem((String)objectNumber, (int)20);
        request.append(barcodeStr);
        String sourceStr = EwmMsgTools.fillItem((String)source, (int)18);
        request.append(sourceStr);
        String appointmentStr = EwmMsgTools.fillItem((String)appointment, (int)18);
        request.append(appointmentStr);
        String objectPIKNumberStr = EwmMsgTools.fillItem((String)objectPIKNumber, (int)10);
        request.append(objectPIKNumberStr);
        String contentNew = String.valueOf(request);
        contentNew = contentNew.replaceAll("\\^", " ");
        log.info("start CLIENT_WT barcode {} {}", (Object)objectNumber, (Object)contentNew);
        log.info("end CLIENT_WT barcode {} {}", (Object)objectNumber, (Object)contentNew);
    }

    private void setPlotInfo(String appointment, String objectPIKNumber, String objectNumber) {
        SortInfo sortInfo = this.sortInfoService.getSortInfo(objectPIKNumber);
        try {
            if (sortInfo == null) {
                log.error("WT setPlotInfo error barcode{},objectPIKNumber{},appointment, Info {}", new Object[]{objectNumber, objectPIKNumber, appointment});
                sortInfo.setErrorCodeSVR(13);
                return;
            }
            sortInfo.setErrorCodeSVR(0);
            if (appointment.equals("U003_SS")) {
                appointment = "B201_SS";
            }
            if (appointment.equals("U004_SS")) {
                appointment = "B202_SS";
            }
            String plotType = appointment.substring(0, 1);
            log.info("WT setPlotInfo error barcode{},objectPIKNumber{},plotType, Info {}", new Object[]{objectNumber, objectPIKNumber, plotType});
            String plotPoint = appointment.substring(1).replaceAll("_SS", "");
            log.info("WT setPlotInfo error barcode{},objectPIKNumber{},plotType, Info {}", new Object[]{objectNumber, objectPIKNumber, plotPoint});
            sortInfo.getSlotsList().add(Integer.valueOf(plotPoint));
            sortInfo.setRoadSlotName(plotType);
            log.info("WT setPlotInfo success barcode{},objectPIKNumber{},appointment, Info {}", new Object[]{objectNumber, objectPIKNumber, appointment});
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Sort info not found! Car Id:" + objectPIKNumber);
            sortInfo.setErrorCodeSVR(12);
            sortInfo.getSlotsList().clear();
        }
    }

    public static void main(String[] args) {
        System.out.println(Integer.valueOf("011"));
    }

    public boolean isLog() {
        return true;
    }

    public WtEwmService(SortInfoService sortInfoService, SlotService slotService, ScreenService screenService) {
        this.sortInfoService = sortInfoService;
        this.slotService = slotService;
        this.screenService = screenService;
    }
}

