/*
 * Decompiled with CFR 0.152.
 */
package com.simba.web.service.config;

import cn.hutool.core.util.StrUtil;
import com.simba.common.socket.framework.base.manager.handler.BaseJsonServiceManager;
import com.simba.common.socket.framework.base.service.JsonService;
import com.simba.web.service.config.EwmMsgTools;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EwmJsonServiceManager
extends BaseJsonServiceManager {
    private static final Logger log = LoggerFactory.getLogger(EwmJsonServiceManager.class);
    private final String name = StrUtil.lowerFirst((CharSequence)this.getClass().getSimpleName());
    private String routeKey = "0";

    public EwmJsonServiceManager(int corePoolSize, int maxPoolSize) {
        super.init(corePoolSize, maxPoolSize);
    }

    public List<String> parseRequestData(byte[] request) {
        ArrayList<String> requestContent = new ArrayList<String>();
        try {
            String msg = new String(request, StandardCharsets.UTF_8);
            int cursor = 0;
            requestContent.add(EwmMsgTools.parseItem((String)msg, (int)cursor, (int)(cursor + 8)));
            requestContent.add(EwmMsgTools.parseItem((String)msg, (int)(cursor += 8), (int)(cursor + 8)));
            requestContent.add(EwmMsgTools.parseItem((String)msg, (int)(cursor += 8), (int)(cursor + 18)));
            requestContent.add(EwmMsgTools.parseItem((String)msg, (int)(cursor += 18), (int)(cursor + 2)));
            requestContent.add(EwmMsgTools.parseItem((String)msg, (int)(cursor += 2), (int)(cursor + 10)));
            requestContent.add(EwmMsgTools.parseItem((String)msg, (int)(cursor += 10), (int)(cursor + 4)));
            requestContent.add(EwmMsgTools.parseItem((String)msg, (int)(cursor += 4), (int)(cursor + 4)));
            requestContent.add(msg.substring(cursor += 4, msg.length() - 1));
        }
        catch (Exception e) {
            log.error("[{}] parse data error -- {}", (Object)this.getName(), (Object)e.getMessage());
        }
        return requestContent;
    }

    public String buildResponseData(List<String> response) {
        StringBuilder responseContent = new StringBuilder();
        try {
            for (String s : response) {
                responseContent.append(s).append("^");
            }
        }
        catch (Exception e) {
            log.error("[{}] build data error -- {}", (Object)this.getName(), (Object)e.getMessage());
        }
        return responseContent.toString();
    }

    public void onReceived(Object sender, Channel channel, String message, Object content) {
        byte[] request = (byte[])content;
        Runnable serviceTask = () -> {
            String routeKey = this.bindRouteKey();
            String remoteAddress = channel.getRemoteAddress().toString();
            try {
                Class<?> clz;
                Method[] methods;
                if (this.printReceivedLog) {
                    this.printReceivedInfo(channel, request);
                }
                if (!this.examineReceivedInfo(channel, request)) {
                    log.error("Channel-[{}] Examine data failure", (Object)remoteAddress);
                    return;
                }
                List requestContentList = this.parseRequestData(request);
                if (requestContentList == null) {
                    log.error("Channel-[{}] Request data is empty", (Object)remoteAddress);
                    return;
                }
                String serviceName = (String)requestContentList.get(Integer.parseInt(routeKey));
                if (StrUtil.isBlank((CharSequence)serviceName)) {
                    log.error("Channel-[{}] Request route is empty", (Object)remoteAddress);
                    return;
                }
                JsonService accessor = this.container.getJsonService(serviceName);
                if (accessor == null) {
                    log.error("Channel-[{}] Request handle is empty", (Object)remoteAddress);
                    return;
                }
                if (!this.printReceivedLog && accessor.isLog()) {
                    this.printReceivedInfo(channel, request);
                }
                if ((methods = (clz = accessor.getClass()).getDeclaredMethods()).length < 1) {
                    accessor.handleRequest(channel, (Object)requestContentList, routeKey);
                    return;
                }
                accessor.handleRequest(channel, (Object)requestContentList, routeKey);
            }
            catch (Exception ex) {
                log.error("[{}] when json server handlerRequest exception  [{}] -- {}", new Object[]{this.getName(), remoteAddress, ex.getMessage()});
            }
        };
        this.execute(serviceTask);
    }

    protected void initServices() {
        this.autoLoadServices();
    }

    protected String bindRouteKey() {
        return this.routeKey;
    }

    protected void printReceivedInfo(Channel channel, byte[] content) {
        String info = new String(content, StandardCharsets.UTF_8);
        log.info("Channel-[" + channel.getRemoteAddress() + "] Read json data-[" + info + "]");
    }

    protected boolean examineReceivedInfo(Channel channel, byte[] content) {
        return true;
    }

    protected String getName() {
        return this.name;
    }

    public void setRouteKey(String routeKey) {
        this.routeKey = routeKey;
    }
}

