/*
 * Decompiled with CFR 0.152.
 */
package com.simba.web.client;

import com.alibaba.fastjson.JSONObject;
import com.simba.common.command.Command;
import com.simba.common.command.ICommand;
import com.simba.common.command.RC;
import com.simba.services.SlotService;
import com.simba.services.beans.SortInfo;
import com.simba.services.params.MachineParams;
import com.simba.services.params.SortConfig;
import com.simba.wbapi.ApiClientExample;
import com.simba.wbapi.ResponseEntities;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

@Command
public class WebSortInfoCmd
implements ICommand {
    private static final Logger log = LoggerFactory.getLogger(WebSortInfoCmd.class);
    public static final String NAME = WebSortInfoCmd.class.getName();
    private final MachineParams machineParams;
    private final SortConfig sortConfig;
    private final SlotService slotService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private ApiClientExample apiClientExample;

    public String getName() {
        return NAME;
    }

    public RC run(Object params) {
        SortInfo sortInfo = (SortInfo)params;
        int errorCode7Error = 7;
        int errorCode10OtherError = 10;
        try {
            String barcode = sortInfo.getBarcode();
            String carIdInt = sortInfo.getCarId();
            log.info("start barcode {} carId {} send to", (Object)barcode, (Object)carIdInt);
            String result = "";
            try {
                String area = this.sortConfig.getArea();
                String sorterId = sortInfo.getSorterId();
                sorterId = sorterId.length() == 1 ? "0" + sorterId : sorterId;
                String inFeedPlaceId = area + sorterId;
                result = this.apiClientExample.getItemSortingInfo(barcode, Integer.parseInt(inFeedPlaceId));
            }
            catch (Exception e) {
                log.info("getItemSortingInfo1 Error {}", (Object)e.getMessage());
                sortInfo.setErrorCodeSVR(errorCode7Error);
                return RC.error((int)1006);
            }
            if (!result.contains("outbound_chutes")) {
                if (result.contains("#404#") && result.contains("READ_BARCODE_ERROR")) {
                    sortInfo.setErrorCodeSVR(errorCode7Error);
                    log.info("barcode {} carId {} get slotsList  error", (Object)barcode, (Object)carIdInt);
                    return RC.error((int)1006);
                }
                log.info("barcode {} carId {} get slotsList  error", (Object)barcode, (Object)carIdInt);
                sortInfo.setErrorCodeSVR(errorCode10OtherError);
                return RC.error((int)1006);
            }
            ResponseEntities.ItemSortingInfo itemSortingInfo = (ResponseEntities.ItemSortingInfo)JSONObject.parseObject((String)result, ResponseEntities.ItemSortingInfo.class);
            List outboundChutes = itemSortingInfo.getOutbound_chutes();
            List slotsList = sortInfo.getSlotsList();
            slotsList.addAll(outboundChutes);
            return RC.ok();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("get factualSlot by sortInfo error: " + ex.getMessage());
            sortInfo.setErrorCodeSVR(errorCode7Error);
            return RC.error((int)1006);
        }
    }

    private void analysisSlots(SortInfo sortInfo, String physicalSlot) {
        ArrayList<Integer> physicalSlots = new ArrayList<Integer>();
        physicalSlots.add(1);
        for (Integer slot : physicalSlots) {
            if (slot <= 0 || slot > this.slotService.getSlotInfoCount()) continue;
            sortInfo.getSlotsList().add(slot);
        }
        if (sortInfo.getSlotsList().isEmpty()) {
            sortInfo.setErrorCodeSVR(11);
        }
    }

    public WebSortInfoCmd(MachineParams machineParams, SortConfig sortConfig, SlotService slotService) {
        this.machineParams = machineParams;
        this.sortConfig = sortConfig;
        this.slotService = slotService;
    }
}

