/*
 * Decompiled with CFR 0.152.
 */
package com.simba.web.client;

import com.simba.common.command.Command;
import com.simba.common.command.ICommand;
import com.simba.common.command.RC;
import com.simba.common.util.CacheUtils;
import com.simba.services.beans.SortInfo;
import com.simba.services.params.MachineParams;
import com.simba.services.params.SortConfig;
import com.simba.wbapi.ApiClientExample;
import com.simba.wbapi.udp.SorterMonitorSystem;
import com.simba.web.service.config.EwmMsgTools;
import com.simba.web.service.config.EwmNetTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command
public class WebPacketOffCmd
implements ICommand {
    private static final Logger log = LoggerFactory.getLogger(WebPacketOffCmd.class);
    public static final String NAME = WebPacketOffCmd.class.getName();
    private final MachineParams machineParams;
    private final SortConfig sortConfig;
    private final ApiClientExample apiClientExample;
    private final SorterMonitorSystem sorterMonitorSystem;

    public String getName() {
        return NAME;
    }

    public RC run(Object params) {
        SortInfo sortInfo = (SortInfo)params;
        try {
            if (this.sortConfig.isDebug()) {
                log.error("Upload package off error: debug mode doesn't upload data!");
                return RC.error((int)1004);
            }
            log.info("sendSortInfoToWcs start barcode {}, carId {}, slot {}", new Object[]{sortInfo.getBarcode(), sortInfo.getCarId(), sortInfo.getSlotsList()});
            this.sendSortInfoToWcs(sortInfo);
            log.info("sendSortInfoToWcs end barcode {}, carId {}, slot {}", new Object[]{sortInfo.getBarcode(), sortInfo.getCarId(), sortInfo.getSlotsList()});
            return RC.ok();
        }
        catch (Exception e) {
            log.error("Upload package sendSortInfoToWcs off error: " + e);
            return RC.error((int)1006);
        }
    }

    private void sendSortInfoToSap(SortInfo sortInfo) {
        try {
            StringBuilder request = new StringBuilder();
            request.append("WCS_M_SSSAPEWM^^^^^^^^^^^^^^^^^^^^R^");
            Integer wtco = 0;
            wtco = wtco + 1;
            String numberNew = EwmMsgTools.fillItemLeft((String)(wtco + ""), (int)10);
            CacheUtils.WTCO = wtco;
            log.info("sendSortInfoToSap numberNew:{}", (Object)numberNew);
            int turnNumber = sortInfo.getTurnNumber();
            String turnNumberStr = EwmMsgTools.fillItem((String)String.valueOf(turnNumber), (int)10);
            request.append(numberNew);
            request.append("^^^^WTCO");
            String barcode = EwmMsgTools.fillItem((String)sortInfo.getBarcode(), (int)20);
            request.append(barcode);
            request.append("INBA_SS_15^^^^^^^^");
            String plotPoint = EwmMsgTools.fillItemLeft((String)((Integer)sortInfo.getSlotsList().get(0)).toString(), (int)3);
            String input = sortInfo.getRoadSlotName() + plotPoint + "_SS";
            log.info("sendSortInfoToSap input1:{}", (Object)input);
            if (input.equals("B201_SS")) {
                input = "U003_SS";
            }
            if (input.equals("B202_SS")) {
                input = "U004_SS";
            }
            log.info("sendSortInfoToSap input2:{}", (Object)input);
            String slot = EwmMsgTools.fillItem((String)input, (int)18);
            request.append(slot);
            request.append("^^^^");
            String carId = EwmMsgTools.fillItem((String)sortInfo.getCarId(), (int)10);
            request.append(carId);
            String content = String.valueOf(request).replaceAll("\\^", " ");
            log.info("sendSortInfoToSap barcode{},carId{}, content:{}", new Object[]{sortInfo.getBarcode(), sortInfo.getCarId(), content});
            EwmNetTools.getClient((String)"wtco").sendJsonContent(content);
        }
        catch (Exception e) {
            log.error("sortInfo barcode {} sendSortInfoToSap error:{}", (Object)sortInfo.getBarcode(), (Object)e.getMessage());
        }
    }

    public void sendSortInfoToWcs(SortInfo sortInfo) {
        String barcode = sortInfo.getBarcode();
        int droppedSlotId = sortInfo.getDroppedSlotId();
        try {
            int sortPlaceId = this.sortConfig.getSortPlaceId();
            int employeeId = Integer.parseInt(null == sortInfo.getWorkerNo() ? "0" : sortInfo.getWorkerNo());
            String result = this.apiClientExample.saveItemSortingResult(barcode, droppedSlotId, sortPlaceId, employeeId);
            log.info("sendSortInfoToSap barcode{},carId{}, content:{}", new Object[]{barcode, sortInfo.getCarId(), result});
            try {
                String sorterId = sortInfo.getSorterId();
                String area = this.sortConfig.getArea();
                sorterId = sorterId.length() == 1 ? "0" + sorterId : sorterId;
                this.sorterMonitorSystem.sendBarCodeToSap(barcode, area + sorterId, Integer.valueOf(2));
            }
            catch (Exception e) {
                log.error("sendBarCodeToSap error: " + e.getMessage());
            }
        }
        catch (Exception e) {
            log.error("sortInfo barcode {} sendSortInfoToSap error:{}", (Object)barcode, (Object)e.getMessage());
        }
    }

    public WebPacketOffCmd(MachineParams machineParams, SortConfig sortConfig, ApiClientExample apiClientExample, SorterMonitorSystem sorterMonitorSystem) {
        this.machineParams = machineParams;
        this.sortConfig = sortConfig;
        this.apiClientExample = apiClientExample;
        this.sorterMonitorSystem = sorterMonitorSystem;
    }
}

