/*
 * Decompiled with CFR 0.152.
 */
package com.simba.wbapi.udp;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.simba.wbapi.udp.SorterItem;
import com.simba.wbapi.udp.SorterStatus;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UdpCommunicator {
    private static final Logger log = LoggerFactory.getLogger(UdpCommunicator.class);
    private final String targetHost;
    private final int targetPort;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public UdpCommunicator(@Value(value="${udp.target.host}") String udpTargetHost, @Value(value="${udp.target.port}") Integer udpTargetPort) {
        this.targetHost = udpTargetHost;
        this.targetPort = udpTargetPort;
    }

    public void sendItemData(SorterItem item) throws Exception {
        String json = this.objectMapper.writeValueAsString((Object)item);
        log.info("sendItemData{}", (Object)json);
        this.sendUdpPacket(json);
    }

    public void sendStatusData(SorterStatus status) throws Exception {
        String json = this.objectMapper.writeValueAsString((Object)status);
        this.sendUdpPacket(json);
    }

    private void sendUdpPacket(String data) throws Exception {
        try (DatagramSocket socket = new DatagramSocket();){
            byte[] buffer = data.getBytes();
            InetAddress address = InetAddress.getByName(this.targetHost);
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length, address, this.targetPort);
            socket.send(packet);
        }
    }
}

